/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.IExpression;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.ISelection;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.BinNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.datasets.TransientDataset;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.ArrayList;
import java.util.List;

public class FromCommand
extends CommandNode {
    private final Dataset dataset;
    private final IWherePredicate where;
    private final IGroupBy[] groupBy;
    private final List<String> selectableFields;
    private final List<String> selectedFields;
    private final List<AggregateNode> selectedAggregates;
    private final ISelection[] selections;
    private final IOrdering[] orderings;

    public FromCommand(Dataset dataset) {
        this(dataset, null, null, null, null);
    }

    public FromCommand(Dataset dataset, IWherePredicate where) {
        this(dataset, where, null, null, null);
    }

    public FromCommand(Dataset dataset, IWherePredicate where, ISelection[] selections) throws IllegalArgumentException {
        this(dataset, where, null, selections, null);
    }

    public FromCommand(Dataset dataset, IWherePredicate where, IGroupBy[] groupBy, ISelection[] selections, IOrdering[] orderings) throws IllegalArgumentException {
        super("from", CommandType.SP_EVENTS, new FieldsAndProperties().from(where, groupBy, selections, orderings).array());
        FromCommand embeddedFrom = null;
        if (dataset instanceof TransientDataset && ((TransientDataset)dataset).getSource() instanceof FromCommand) {
            embeddedFrom = (FromCommand)((TransientDataset)dataset).getSource();
        }
        if (embeddedFrom != null && embeddedFrom.supportsShorthand()) {
            this.dataset = embeddedFrom.dataset;
        } else {
            if (embeddedFrom != null && where == null && groupBy == null && selections == null && orderings == null) {
                this.dataset = embeddedFrom.dataset;
                this.groupBy = embeddedFrom.groupBy;
                this.orderings = embeddedFrom.orderings;
                this.selections = embeddedFrom.selections;
                this.selectedFields = embeddedFrom.selectedFields;
                this.selectableFields = embeddedFrom.selectableFields;
                this.selectedAggregates = embeddedFrom.selectedAggregates;
                this.where = embeddedFrom.where;
                return;
            }
            this.dataset = dataset;
        }
        this.where = where;
        if (selections == null || selections.length == 0) {
            this.orderings = orderings;
            if (groupBy != null && groupBy.length > 0) {
                throw new IllegalArgumentException("When specifying a GROUP BY clause you must do a SELECT clause too.");
            }
            this.selections = null;
            this.groupBy = null;
            this.selectedFields = null;
            this.selectableFields = null;
            this.selectedAggregates = null;
        } else if (groupBy == null || groupBy.length == 0) {
            this.orderings = orderings;
            this.selections = selections;
            this.selectedAggregates = new ArrayList<AggregateNode>();
            this.selectedFields = new ArrayList<String>();
            this.selectableFields = null;
            for (ISelection iSelection : this.selections) {
                if (iSelection instanceof AggregateNode) {
                    this.selectedAggregates.add((AggregateNode)iSelection);
                    continue;
                }
                if (!(iSelection instanceof FieldNode)) continue;
                this.selectedFields.add(((FieldNode)iSelection).getFieldName());
            }
            IGroupBy[] iGroupByArray = this.groupBy = !this.selectedAggregates.isEmpty() ? new IGroupBy[]{} : null;
            if (!this.selectedAggregates.isEmpty() && !this.selectedFields.isEmpty()) {
                throw new IllegalArgumentException("If SELECT includes one or more AggregateNodes any selected FieldNodes must be part of the GROUP BY clause.");
            }
        } else {
            this.orderings = orderings;
            this.groupBy = groupBy;
            this.selections = selections;
            this.selectableFields = new ArrayList<String>();
            this.selectedAggregates = null;
            for (IGroupBy iGroupBy : this.groupBy) {
                this.selectableFields.add(iGroupBy.getByName());
                if (!(iGroupBy instanceof BinNode)) continue;
                this.selectableFields.add(((BinNode)iGroupBy).getField().getFieldName());
            }
            this.selectedFields = new ArrayList<String>();
            for (IExpression iExpression : this.selections) {
                if (!(iExpression instanceof FieldNode)) continue;
                this.selectedFields.add(((FieldNode)iExpression).getFieldName());
            }
            for (String selected : this.selectedFields) {
                if (this.selectableFields.contains(selected)) continue;
                throw new IllegalArgumentException("Fields referenced in a SELECT after a GROUP BY clause must be part of the GROUP BY clause. selected_field='" + selected + "'.");
            }
        }
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    public IWherePredicate getWhere() {
        return this.where;
    }

    public IGroupBy[] getGroupBy() {
        return this.groupBy;
    }

    public ISelection[] getSelections() {
        return this.selections;
    }

    public IOrdering[] getOrderings() {
        return this.orderings;
    }

    public boolean isValidSpl() {
        return this.isSupportedByV1() || this.isSupportedBySSC();
    }

    public boolean supportsShorthand() {
        return this.where == null && this.selections == null && this.groupBy == null && this.orderings == null;
    }

    private boolean isSupportedByV1() {
        return this.dataset.isSupportedByV1() && this.supportsShorthand();
    }

    private boolean isSupportedBySSC() {
        return this.dataset.isSupportedByV1();
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

