/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.BinNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.visitors.NodeVisitor;

public class BinCommand
extends CommandNode {
    private final BinNode binNode;
    private final FieldNode newField;

    public BinCommand(CommandNode source, BinNode binNode) {
        this(source, binNode, null);
    }

    public BinCommand(CommandNode source, BinNode binNode, FieldNode newField) {
        super(source, "bin", CommandType.SP_STREAM, new FieldsAndProperties().bin(binNode.getField(), newField).array());
        if (binNode == null || binNode.getField() == null) {
            throw new IllegalArgumentException("A binNode with a field is required.");
        }
        this.binNode = binNode;
        this.newField = newField;
    }

    public BinNode getBinNode() {
        return this.binNode;
    }

    public FieldNode getNewField() {
        return this.newField;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        BinCommand.assertNotNull(source);
        return new BinCommand(source, this.binNode, this.newField);
    }
}

