/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes;

import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.Predicate;
import com.splunk.commons.ast.nodes.commands.RenameNode;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.AndNode;
import com.splunk.commons.ast.nodes.expressions.AssignmentNode;
import com.splunk.commons.ast.nodes.expressions.BooleanNode;
import com.splunk.commons.ast.nodes.expressions.Cardinality;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.InNode;
import com.splunk.commons.ast.nodes.expressions.MultiValueNode;
import com.splunk.commons.ast.nodes.expressions.NavigationNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.Operator;
import com.splunk.commons.ast.nodes.expressions.OrNode;
import com.splunk.commons.ast.nodes.expressions.PercentageAggregateNode;
import com.splunk.commons.ast.nodes.expressions.SparklineAggregateNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.expressions.XorNode;
import java.util.List;

public final class Expression {
    private Expression() {
    }

    public static StringNode string(String value) {
        return new StringNode(value);
    }

    public static NumberNode number(Number value) {
        return new NumberNode(value);
    }

    public static BooleanNode bool(Boolean value) {
        return BooleanNode.load(value);
    }

    public static MultiValueNode multivalue(String[] mv) {
        StringNode[] sn = new StringNode[mv.length];
        for (int i = 0; i < mv.length; ++i) {
            sn[i] = new StringNode(mv[i]);
        }
        return new MultiValueNode(sn);
    }

    public static MultiValueNode multivalue(StringNode[] mv) {
        return new MultiValueNode(mv);
    }

    public static FieldNode field(String fieldName) {
        return new FieldNode(fieldName);
    }

    public static FieldNode field(NavigationNode navigation, String fieldName) {
        return new FieldNode(navigation, fieldName);
    }

    public static NavigationNode navigation(String navigationName) {
        return new NavigationNode(navigationName);
    }

    public static NavigationNode navigation(String navigationName, Cardinality cardinality) {
        return new NavigationNode(navigationName, cardinality);
    }

    public static NavigationNode navigation(NavigationNode source, String navigation) {
        return new NavigationNode(source, navigation);
    }

    public static NavigationNode navigation(NavigationNode source, String navigation, Cardinality cardinality) {
        return new NavigationNode(source, navigation, cardinality);
    }

    public static AggregateNode aggregate(AggregateFunction function, String field) {
        return new AggregateNode(function, field);
    }

    public static AggregateNode aggregate(AggregateFunction function, String field, String asField) {
        return new AggregateNode(function, field, asField);
    }

    public static AggregateNode all(String fieldName) {
        return new AggregateNode(AggregateFunction.ALL, new FieldNode(fieldName));
    }

    public static AssignmentNode assignment(String fieldName, TypeNode expression) {
        return new AssignmentNode(fieldName, expression);
    }

    public static AssignmentNode assignment(String fieldName, TypeNode expression, int bracketIndex) {
        return new AssignmentNode(new FieldNode(fieldName), expression, bracketIndex);
    }

    public static RenameNode rename(String field, String newField) {
        return new RenameNode(field, newField);
    }

    public static ComparisonNode equal(TypeNode lhs, TypeNode rhs) {
        return new ComparisonNode(Operator.EQUAL, lhs, rhs);
    }

    public static ComparisonNode equal(String fieldName, String value) {
        return new ComparisonNode(Operator.EQUAL, Expression.field(fieldName), Expression.string(value));
    }

    public static ComparisonNode equalEqual(TypeNode lhs, TypeNode rhs) {
        return new ComparisonNode(Operator.EQUAL_EQUAL, lhs, rhs);
    }

    public static ComparisonNode equalEqual(String fieldName, String value) {
        return new ComparisonNode(Operator.EQUAL_EQUAL, Expression.field(fieldName), Expression.string(value));
    }

    public static ComparisonNode notEqual(TypeNode lhs, TypeNode rhs) {
        return new ComparisonNode(Operator.NOT_EQUAL, lhs, rhs);
    }

    public static ComparisonNode greaterThan(TypeNode lhs, TypeNode rhs) {
        return new ComparisonNode(Operator.GREATER_THAN, lhs, rhs);
    }

    public static ComparisonNode greaterThanOrEqual(TypeNode lhs, TypeNode rhs) {
        return new ComparisonNode(Operator.GREATER_THAN_OR_EQUAL, lhs, rhs);
    }

    public static ComparisonNode lessThan(TypeNode lhs, TypeNode rhs) {
        return new ComparisonNode(Operator.LESS_THAN, lhs, rhs);
    }

    public static ComparisonNode lessThanOrEqual(TypeNode lhs, TypeNode rhs) {
        return new ComparisonNode(Operator.LESS_THAN_OR_EQUAL, lhs, rhs);
    }

    public static AndNode and(List<IWherePredicate> args) {
        return new AndNode(args);
    }

    public static AndNode and(IWherePredicate lhs, IWherePredicate rhs) {
        return new AndNode(lhs, rhs);
    }

    public static AndNode and(IPredicate lhs, IPredicate rhs) {
        return Expression.and(Predicate.where(lhs), Predicate.where(rhs));
    }

    public static OrNode or(List<IWherePredicate> args) {
        return new OrNode(args);
    }

    public static OrNode or(IWherePredicate lhs, IWherePredicate rhs) {
        return new OrNode(lhs, rhs);
    }

    public static OrNode or(IPredicate lhs, IPredicate rhs) {
        return Expression.or(Predicate.where(lhs), Predicate.where(rhs));
    }

    public static XorNode xor(List<IWherePredicate> args) {
        return new XorNode(args);
    }

    public static XorNode xor(IWherePredicate lhs, IWherePredicate rhs) {
        return new XorNode(lhs, rhs);
    }

    public static XorNode xor(IPredicate lhs, IPredicate rhs) {
        return Expression.xor(Predicate.where(lhs), Predicate.where(rhs));
    }

    public static InNode in(TypeNode[] args) {
        return new InNode(args);
    }

    public static AggregateNode avg(String fieldName) {
        return new AggregateNode(AggregateFunction.AVG, new FieldNode(fieldName));
    }

    public static AggregateNode count(String fieldName) {
        return new AggregateNode(AggregateFunction.COUNT, new FieldNode(fieldName));
    }

    public static AggregateNode count() {
        return new AggregateNode(AggregateFunction.COUNT, new FieldNode(""));
    }

    public static AggregateNode dc(String fieldName) {
        return new AggregateNode(AggregateFunction.DC, new FieldNode(fieldName));
    }

    public static AggregateNode earliest(String fieldName) {
        return new AggregateNode(AggregateFunction.EARLIEST, new FieldNode(fieldName));
    }

    public static AggregateNode estdc(String fieldName) {
        return new AggregateNode(AggregateFunction.ESTDC, new FieldNode(fieldName));
    }

    public static AggregateNode estdc_error(String fieldName) {
        return new AggregateNode(AggregateFunction.ESTDC_ERROR, new FieldNode(fieldName));
    }

    public static AggregateNode exactperc_x(String fieldName, int percentage) {
        return new PercentageAggregateNode(AggregateFunction.EXACTPERC_X, new FieldNode(fieldName), percentage);
    }

    public static AggregateNode first(String fieldName) {
        return new AggregateNode(AggregateFunction.FIRST, new FieldNode(fieldName));
    }

    public static AggregateNode latest(String fieldName) {
        return new AggregateNode(AggregateFunction.LATEST, new FieldNode(fieldName));
    }

    public static AggregateNode last(String fieldName) {
        return new AggregateNode(AggregateFunction.LAST, new FieldNode(fieldName));
    }

    public static AggregateNode list(String fieldName) {
        return new AggregateNode(AggregateFunction.LIST, new FieldNode(fieldName));
    }

    public static AggregateNode max(String fieldName) {
        return new AggregateNode(AggregateFunction.MAX, new FieldNode(fieldName));
    }

    public static AggregateNode mean(String fieldName) {
        return new AggregateNode(AggregateFunction.MEAN, new FieldNode(fieldName));
    }

    public static AggregateNode median(String fieldName) {
        return new AggregateNode(AggregateFunction.MEDIAN, new FieldNode(fieldName));
    }

    public static AggregateNode min(String fieldName) {
        return new AggregateNode(AggregateFunction.MIN, new FieldNode(fieldName));
    }

    public static AggregateNode mode(String fieldName) {
        return new AggregateNode(AggregateFunction.MODE, new FieldNode(fieldName));
    }

    public static AggregateNode per_day(String fieldName) {
        return new AggregateNode(AggregateFunction.PER_DAY, new FieldNode(fieldName));
    }

    public static AggregateNode per_hour(String fieldName) {
        return new AggregateNode(AggregateFunction.PER_HOUR, new FieldNode(fieldName));
    }

    public static AggregateNode per_minute(String fieldName) {
        return new AggregateNode(AggregateFunction.PER_MINUTE, new FieldNode(fieldName));
    }

    public static AggregateNode per_second(String fieldName) {
        return new AggregateNode(AggregateFunction.PER_SECOND, new FieldNode(fieldName));
    }

    public static AggregateNode perc_x(String fieldName, int percentage) {
        return new PercentageAggregateNode(AggregateFunction.PERC_X, new FieldNode(fieldName), percentage);
    }

    public static AggregateNode sparkline(String fieldName, String sparklineAggFunction) {
        return Expression.sparkline(fieldName, sparklineAggFunction, "1s");
    }

    public static AggregateNode sparkline(String fieldName, String sparklineAggFunction, String timeInterval) {
        return new SparklineAggregateNode(AggregateFunction.fromString(sparklineAggFunction), new FieldNode(fieldName), new StringNode(timeInterval), null);
    }

    public static AggregateNode sparkline() {
        return new SparklineAggregateNode(null);
    }

    public static AggregateNode range(String fieldName) {
        return new AggregateNode(AggregateFunction.RANGE, new FieldNode(fieldName));
    }

    public static AggregateNode stdev(String fieldName) {
        return new AggregateNode(AggregateFunction.STDEV, new FieldNode(fieldName));
    }

    public static AggregateNode stdevp(String fieldName) {
        return new AggregateNode(AggregateFunction.STDEVP, new FieldNode(fieldName));
    }

    public static AggregateNode sum(String fieldName) {
        return new AggregateNode(AggregateFunction.SUM, new FieldNode(fieldName));
    }

    public static AggregateNode sumsq(String fieldName) {
        return new AggregateNode(AggregateFunction.SUMSQ, new FieldNode(fieldName));
    }

    public static AggregateNode upperperc_x(String fieldName, int percentage) {
        return new PercentageAggregateNode(AggregateFunction.UPPERPERC_X, new FieldNode(fieldName), percentage);
    }

    public static AggregateNode values(String fieldName) {
        return new AggregateNode(AggregateFunction.VALUES, new FieldNode(fieldName));
    }

    public static AggregateNode var(String fieldName) {
        return new AggregateNode(AggregateFunction.VAR, new FieldNode(fieldName));
    }

    public static AggregateNode varp(String fieldName) {
        return new AggregateNode(AggregateFunction.VARP, new FieldNode(fieldName));
    }
}

