/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import com.splunk.io.SearchOutputStream;
import com.splunk.mr.CommandHandler;
import com.splunk.mr.SplunkMR;
import com.splunk.roll.Roller;
import com.splunk.roll.ThrottledIO;
import com.splunk.roll.util.ConfU;
import com.splunk.roll.util.DateU;
import com.splunk.roll.util.OutputUtil;
import com.splunk.util.JsonUtil;
import com.splunk.util.Tuple;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class RollHandler
implements CommandHandler {
    private static final Logger gLogger = Logger.getLogger(RollHandler.class);
    public static final String CONF_OUTPUT_BUCKET_PATH = "output.buckets.path";
    public static final String CONF_SPLUNK_INDEX_HOME_PATH = "homePath_expanded";
    public static final String CONF_SPLUNK_INDEX_COLD_PATH = "coldPath_expanded";
    public static final String CONF_ROLL_BUCKETS_OLDER_THAN_SECS = "output.buckets.older.than";
    public static final String CONF_ROLL_INDEXES = "output.buckets.from.indexes";
    public static final String CONF_ROLL_NAME_KEY = "name";

    @Override
    public void execute(Configuration conf, Map<String, Object> vixRequest, SearchOutputStream out) throws Exception {
        this.adjustNoisyLogLevels();
        JsonNode jsonTree = JsonUtil.valueToTree(new ObjectMapper(), vixRequest);
        this.putAllRollArgsToConf(conf, jsonTree);
        conf.set("splunk.roll.local.home", this.getRollLocalHome(conf));
        JsonNode erpConf = jsonTree.path("conf");
        JsonNode provConf = erpConf.path("provider");
        String name = provConf.path(CONF_ROLL_NAME_KEY).getTextValue();
        JsonNode vixesNode = erpConf.path("indexes");
        if (vixesNode.size() == 0) {
            gLogger.warn((Object)("provider=" + name + ", does not have any vixes to roll buckets to."));
        }
        Iterator vixes = vixesNode.iterator();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        while (vixes.hasNext()) {
            JsonNode vix = (JsonNode)vixes.next();
            String vixName = null;
            try {
                this.verifyVixHasRequiredFields(vix);
                vixName = this.getVixName(vix);
                this.executeCopyToVix(conf, vix, erpConf.path("splunk-indexes"));
            }
            catch (Exception e) {
                gLogger.error((Object)("Exception=" + e.getClass().getSimpleName() + ", when rolling buckets to virtual_index=" + vixName + ", message=\"" + e.getMessage() + "\""));
                exceptions.add(e);
                if (e instanceof OutputUtil.UnableToWriteToParentProcessException) break;
            }
            gLogger.debug((Object)("Done rolling buckets to virtual_index=" + vixName));
        }
        if (!exceptions.isEmpty()) {
            throw new RuntimeException(this.concatExceptionMessages(exceptions));
        }
    }

    private void adjustNoisyLogLevels() {
        Logger.getLogger((String)"org.apache.hadoop.hdfs.DFSClient").setLevel(Level.INFO);
    }

    private String getVixName(JsonNode vix) {
        return vix.path(CONF_ROLL_NAME_KEY).getTextValue();
    }

    private void verifyVixHasRequiredFields(JsonNode vix) {
        List<String> requiredConfFields = Arrays.asList(CONF_ROLL_NAME_KEY, CONF_ROLL_BUCKETS_OLDER_THAN_SECS, CONF_ROLL_INDEXES, CONF_OUTPUT_BUCKET_PATH);
        ArrayList<String> verificationMessages = new ArrayList<String>();
        for (String requiredField : requiredConfFields) {
            if (JsonUtil.has(vix, requiredField)) continue;
            verificationMessages.add("virtual_index=" + this.getVixName(vix) + ", did not have required conf field=" + requiredField);
        }
        if (!verificationMessages.isEmpty()) {
            throw new RuntimeException(((Object)verificationMessages).toString());
        }
    }

    private void executeCopyToVix(Configuration conf, JsonNode vix, JsonNode splunkIndexes) throws IOException {
        long rollBucketsOlderThanSecs = JsonUtil.getPositiveLong(vix, CONF_ROLL_BUCKETS_OLDER_THAN_SECS, 0L);
        long bucketsOlderThanDate = System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(rollBucketsOlderThanSecs, TimeUnit.SECONDS);
        ConfU.setRollOlderThanTime(conf, bucketsOlderThanDate, TimeUnit.MILLISECONDS);
        ConfU.setRollRemoteHome(conf, new Path(vix.path(CONF_OUTPUT_BUCKET_PATH).getTextValue()));
        ConfU.setRollVix(conf, this.getVixName(vix));
        this.executeCopyFromSplunkIndex(conf, vix, splunkIndexes, bucketsOlderThanDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeCopyFromSplunkIndex(Configuration conf, JsonNode vix, JsonNode splunkIndexes, long bucketsOlderThanDate) throws IOException {
        List<String> splunkIndexNames = this.getSplunkIndexNames(vix.path(CONF_ROLL_INDEXES).getTextValue());
        ThrottledIO throttledIO = ThrottledIO.create(conf).start();
        try {
            for (String splunkIndexName : splunkIndexNames) {
                try {
                    if (JsonUtil.has(splunkIndexes, splunkIndexName)) {
                        this.doCopyFromSplunkIndex(conf, vix, splunkIndexes, bucketsOlderThanDate, splunkIndexName, throttledIO);
                        continue;
                    }
                    gLogger.warn((Object)("Could not find splunk_index=" + splunkIndexName + ", ignoring ..."));
                }
                catch (Exception e) {
                    gLogger.error((Object)("Exception when copying to splunk_index=" + splunkIndexName + ", exception=" + e.getClass().getSimpleName() + ", message=\"" + e.getMessage() + "\""), (Throwable)e);
                    if (!(e instanceof IOException)) continue;
                    throw (IOException)e;
                    return;
                }
            }
        }
        finally {
            throttledIO.stop();
        }
    }

    private void doCopyFromSplunkIndex(Configuration conf, JsonNode vix, JsonNode splunkIndexes, long bucketsOlderThanDate, String splunkIndexName, ThrottledIO throttledIO) throws IOException {
        JsonNode splunkIndexMap = splunkIndexes.path(splunkIndexName);
        ArrayList<String> indexPaths = new ArrayList<String>();
        this.addPathIfExists(indexPaths, splunkIndexMap.path(CONF_SPLUNK_INDEX_COLD_PATH));
        this.addPathIfExists(indexPaths, splunkIndexMap.path(CONF_SPLUNK_INDEX_HOME_PATH));
        ConfU.setBucketDirs(conf, indexPaths);
        ConfU.setRollIndex(conf, splunkIndexName);
        gLogger.info((Object)("Copying buckets from splunk_index=" + splunkIndexName + ", to virtual_index=" + this.getVixName(vix) + ", for buckets with max_earliest_time=\"" + DateU.getDate(bucketsOlderThanDate, TimeUnit.MILLISECONDS) + "\""));
        Roller.create(conf, throttledIO).copy();
    }

    private List<String> getSplunkIndexNames(String indexesToRoll) {
        String[] indexes;
        ArrayList<String> indexNames = new ArrayList<String>();
        for (String indexName : indexes = indexesToRoll.split(",")) {
            indexName = indexName.trim();
            indexNames.add(indexName);
        }
        return indexNames;
    }

    private void addPathIfExists(List<String> indexPaths, JsonNode path) {
        if (!path.isMissingNode()) {
            indexPaths.add(path.getTextValue());
        }
    }

    private String concatExceptionMessages(List<Exception> exceptions) {
        StringBuffer sb = new StringBuffer();
        for (Exception e : exceptions) {
            sb.append("{");
            sb.append("exception=" + e.getClass().getName());
            sb.append(", ");
            sb.append("message=" + e.getMessage());
            sb.append(", ");
            sb.append("stack=" + Arrays.toString(e.getStackTrace()));
            sb.append("}");
        }
        return sb.toString();
    }

    private String getRollLocalHome(Configuration conf) {
        return conf.get("splunk.roll.local.home", this.getDefaultRollLocalHome(conf));
    }

    private String getDefaultRollLocalHome(Configuration conf) {
        String sep = File.separator;
        return new File(SplunkMR.getSHSplunkHome(conf), "var" + sep + "run" + sep + "splunk" + sep + "hunk" + sep + "roll").getAbsolutePath();
    }

    private void putAllRollArgsToConf(Configuration conf, JsonNode jsonTree) {
        JsonNode roll = jsonTree.path("args").path("roll");
        for (Tuple<String, JsonNode> t : JsonUtil.getFields(roll)) {
            if (((JsonNode)t.value).isTextual()) {
                conf.set((String)t.key, ((JsonNode)t.value).getTextValue());
                continue;
            }
            gLogger.warn((Object)("Conf value was not string. Does not put key=" + (String)t.key + " value=" + t.value + " in conf"));
        }
    }
}

