/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.collect;

import com.splunk.collect.AbstractEventWriter;
import com.splunk.collect.EventWriterUtil;
import com.splunk.datasource.parquet.JsonWriteSupport;
import com.splunk.datasource.parquet.converter.Group;
import com.splunk.s2s.Channel;
import com.splunk.s2s.Event;
import com.splunk.s2s.S2SValue;
import com.splunk.util.StrUtil;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ParquetEventWriter
extends AbstractEventWriter {
    private static Logger gLogger = Logger.getLogger(ParquetEventWriter.class);
    private ParquetWriter<Group> writer;
    private static MessageType schema = new MessageType("HunkEvent", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "_raw"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "host"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "source"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "sourcetype"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "extra"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "forwardhost"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "_time"), new GroupType(Type.Repetition.OPTIONAL, "others", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "map", OriginalType.MAP_KEY_VALUE, new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "key"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "value")})})});
    private CompressionCodecName codec;
    private Group group;
    private Path outputDir;
    private Path currentFile = null;
    private Configuration conf = null;
    private String compressionCodec;
    private boolean renameOnClose;
    int blockSize;
    int pageSize;
    int dictSize;
    boolean enableDict;
    boolean enableValidation;

    public ParquetEventWriter(Configuration conf, Path outputDir, String compressionCodec, boolean renameOnClose) throws IOException {
        super(false);
        this.conf = conf;
        this.outputDir = outputDir;
        this.compressionCodec = compressionCodec;
        this.renameOnClose = renameOnClose;
        this.configureParquet();
    }

    private void configureParquet() {
        this.blockSize = this.getPositiveInt("data.delivery.parquet.block.size", 0x8000000);
        this.pageSize = this.getPositiveInt("data.delivery.parquet.page.size", 0x100000);
        this.dictSize = this.getPositiveInt("data.delivery.parquet.dict.size", 0x100000);
        this.enableDict = this.getBoolean("data.delivery.parquet.enable.dict", true);
        this.enableValidation = this.getBoolean("data.delivery.parquet.enable.validating", false);
        gLogger.info((Object)("Configuring parquet writer to use settings block-size=" + this.blockSize + " page-size=" + this.pageSize + " enable-dictionary=" + this.enableDict + " dict-size=" + this.dictSize + " enable-validating=" + this.enableValidation));
    }

    private int getPositiveInt(String key, int defaultVal) {
        int value = defaultVal;
        String txt = this.conf.get(key);
        if (null != txt) {
            try {
                int n = Integer.parseInt(txt);
                if (n > 0) {
                    value = n;
                } else {
                    gLogger.warn((Object)("Ignoring non-positive value for " + key + ":" + n));
                }
            }
            catch (NumberFormatException ex) {
                gLogger.warn((Object)("Ignoring unparsable value for " + key + ":" + txt));
            }
        }
        return value;
    }

    private boolean getBoolean(String key, boolean defaultVal) {
        return StrUtil.parseBoolean(this.conf.get(key), defaultVal);
    }

    private void init(Event e) throws IOException {
        if (this.writer != null) {
            return;
        }
        String codecFileExt = "";
        if (null == this.compressionCodec || "uncompressed".equalsIgnoreCase(this.compressionCodec) || "none".equalsIgnoreCase(this.compressionCodec)) {
            this.codec = CompressionCodecName.UNCOMPRESSED;
        } else if ("snappy".equalsIgnoreCase(this.compressionCodec)) {
            this.codec = CompressionCodecName.SNAPPY;
            codecFileExt = ".snappy";
        } else if ("lzo".equalsIgnoreCase(this.compressionCodec)) {
            this.codec = CompressionCodecName.LZO;
            codecFileExt = ".lzo";
        } else if ("gzip".equalsIgnoreCase(this.compressionCodec)) {
            this.codec = CompressionCodecName.GZIP;
            codecFileExt = ".gz";
        } else {
            gLogger.warn((Object)("Unrecognized codec '" + this.compressionCodec + "' will be ignored. Supported codecs are: none|snappy|lzo|gzip"));
            this.codec = CompressionCodecName.UNCOMPRESSED;
        }
        StringBuilder name = new StringBuilder();
        name.append(e.isParsedEvent() ? "hunk_pv1" : "hunk_rv1");
        name.append('_').append(System.currentTimeMillis());
        name.append(codecFileExt);
        name.append(".parquet");
        if (this.renameOnClose) {
            name.append(".tmp");
        }
        this.currentFile = new Path(this.outputDir, name.toString());
        JsonWriteSupport.setSchema(schema, this.conf);
        this.writer = new ParquetWriter(this.currentFile, (WriteSupport)new JsonWriteSupport(schema), this.codec, this.blockSize, this.pageSize, this.dictSize, this.enableDict, this.enableValidation, ParquetProperties.WriterVersion.PARQUET_2_0, this.conf);
        this.group = new Group((GroupType)schema);
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.writer != null) {
                this.writer.close();
                EventWriterUtil.postCloseCleanup(this.conf, this.currentFile, this.getRawEventBytes(), this.getEventCount(), this.renameOnClose);
            }
        }
        finally {
            this.writer = null;
        }
    }

    @Override
    public String getName() {
        return "parquet";
    }

    @Override
    protected void commitImpl() {
    }

    @Override
    public void addEventImpl(Event e) throws IOException {
        this.init(e);
        this.group.reset();
        this.group.add("_raw", e.getRaw().getBytes());
        this.group.add("_time", e.getNonNullTime().toString());
        Channel c = e.getChannel();
        this.group.add("host", c.getHost() == null ? "" : c.getHost());
        this.group.add("source", c.getSource() == null ? "" : c.getSource());
        this.group.add("sourcetype", c.getSourcetype() == null ? "" : c.getSourcetype());
        if (c.getExtra() != null) {
            this.group.add("extra", c.getExtra());
        }
        this.group.add("forwardhost", c.getFwdSignature().getHostname() + ":" + c.getFwdSignature().getPort());
        if (!e.getFields().isEmpty()) {
            Group others = this.group.addGroup("others");
            for (Event.KVPair kv : e.getFields()) {
                String k = kv._key.toString();
                if (k.charAt(0) == '_') continue;
                Group map = others.addGroup("map");
                map.add("key", k);
                S2SValue v = kv._val;
                if (v.isNumber()) {
                    Number n = v.asNumber();
                    map.add("value", String.valueOf(n.longValue()));
                    continue;
                }
                map.add("value", v.getBytes(), v.getOffset(), v.size());
            }
        }
        this.writer.write((Object)this.group);
    }
}

