/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import com.splunk.roll.BucketLister;
import com.splunk.roll.BucketName;
import com.splunk.roll.util.DateU;
import com.splunk.roll.util.TimeRange;
import java.io.File;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;

public class Bucket {
    public static final String BUCKET_PREFIX = "db";
    public static final String REPLICATED_BUCKET_PREFIX = "rb";
    private final BucketName bucketName;
    private final String index;
    private final String serverGuid;

    public Bucket(BucketName bucketName, String index, String serverGuid) {
        this.bucketName = bucketName;
        this.index = index;
        this.serverGuid = serverGuid;
    }

    public Date getLatest() {
        return DateU.getDate(this.bucketName.getLatest(), TimeUnit.SECONDS);
    }

    public Date getEarliest() {
        return DateU.getDate(this.bucketName.getEarliest(), TimeUnit.SECONDS);
    }

    public TimeRange getTimeRange() {
        return new TimeRange(this.getLatest(), this.getEarliest());
    }

    public String getIndex() {
        return this.index;
    }

    public String getName() {
        return this.bucketName.getName();
    }

    public long getNumber() {
        return this.bucketName.getBucketNumber();
    }

    public boolean isReplicated() {
        return Bucket.isReplicated(this.getName());
    }

    public boolean isFrozen() {
        return false;
    }

    public static boolean isReplicated(String bucketName) {
        return bucketName.startsWith(REPLICATED_BUCKET_PREFIX);
    }

    public String getServerGuid() {
        if (this.bucketName.hasGuid()) {
            return this.bucketName.getGuid();
        }
        return this.serverGuid;
    }

    public String toString() {
        return "bucket_name=" + this.getName() + ", splunk_index=" + this.getIndex();
    }

    public static class RemoteBucket
    extends Bucket {
        private final Path path;

        public RemoteBucket(Path path, BucketName name, String index, String serverGuid) {
            super(name, index, serverGuid);
            this.path = path;
        }

        public Path getPath() {
            return this.path;
        }

        @Override
        public String toString() {
            return super.toString() + ", path=" + this.path;
        }
    }

    public static class LocalBucket
    extends Bucket {
        private final File dir;

        public LocalBucket(File dir, BucketName name, String index, String serverGuid) {
            super(name, index, serverGuid);
            this.dir = dir;
        }

        public File getDir() {
            return this.dir;
        }

        public boolean exists() {
            return this.dir.exists();
        }

        @Override
        public boolean isFrozen() {
            return BucketLister.hasFrozenPrefix(this.dir);
        }

        @Override
        public String toString() {
            return super.toString() + ", dir=" + this.dir;
        }
    }
}

