/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.search.processors;

import com.splunk.mr.AsyncMRJob;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.input.ObjectAcceptor;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.mr.input.VixSplitGenerator;
import com.splunk.search.SearchProcessor;
import com.splunk.search.SearchResults;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;

public class MetadataProcessor
extends SearchProcessor
implements Runnable,
ObjectAcceptor<VixInputSplit> {
    private Thread thread = null;
    private List<VixInputSplit> splits = null;
    private Configuration conf = null;
    private VixSplitGenerator tif = null;
    private boolean full = false;
    private boolean done = false;

    public MetadataProcessor(Configuration conf, VixSplitGenerator tif) {
        this.conf = new Configuration(conf);
        this.tif = tif;
    }

    @Override
    public boolean isGenerating() {
        return true;
    }

    @Override
    public void initFrom(Map<String, Object> data, int pipeLocation) {
        if (pipeLocation != 0) {
            throw new IllegalArgumentException("metadata must be the first search processor");
        }
        super.initFrom(data, pipeLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Runnable dummy = new AsyncMRJob(this.conf, this.conf.get(SplunkMR.CONF_SEARCH_ID));
            this.tif.generateSplits((JobContext)dummy, this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            MetadataProcessor metadataProcessor = this;
            synchronized (metadataProcessor) {
                this.full = true;
                this.done = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends VixInputSplit> boolean accept(T split) {
        MetadataProcessor metadataProcessor = this;
        synchronized (metadataProcessor) {
            while (this.full && !this.done) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.splits.add(split);
            if (this.splits.size() > 500) {
                this.full = true;
                this.notifyAll();
            }
            return true;
        }
    }

    @Override
    public void aboutToExecute() {
        this.splits = new ArrayList<VixInputSplit>();
        this.thread = new Thread(this);
        this.thread.setName("MetadataProcessor");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(SearchResults results) {
        List<VixInputSplit> localSplits = null;
        MetadataProcessor metadataProcessor = this;
        synchronized (metadataProcessor) {
            while (!this.full && !this.done) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            localSplits = this.splits;
            this.splits = new ArrayList<VixInputSplit>();
            this.full = false;
            this.notifyAll();
        }
        results.clear();
        if (localSplits != null && !localSplits.isEmpty()) {
            int si = results.keyIndex("source");
            int tci = results.keyIndex("totalCount");
            int ti = results.keyIndex("type");
            int rti = results.keyIndex("recentTime");
            int lti = results.keyIndex("lastTime");
            int fti = results.keyIndex("firstTime");
            for (VixInputSplit split : localSplits) {
                SearchResults.Result r = results.addNewResult();
                r.set(si, (Object)split.getPath().toUri().getPath());
                r.set(tci, (Object)String.valueOf(split.getLength()));
                r.set(ti, (Object)"sources");
                r.set(rti, (Object)String.valueOf(split.getModTime()));
                r.set(lti, (Object)String.valueOf(split.getLatestTime()));
                r.set(fti, (Object)String.valueOf(split.getEarliestTime()));
            }
        }
        return results.isEmpty();
    }
}

