/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.support.model.AddAttachmentsToSetRequest;
import com.amazonaws.services.support.model.Attachment;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class AddAttachmentsToSetRequestMarshaller
implements Marshaller<Request<AddAttachmentsToSetRequest>, AddAttachmentsToSetRequest> {
    @Override
    public Request<AddAttachmentsToSetRequest> marshall(AddAttachmentsToSetRequest addAttachmentsToSetRequest) {
        if (addAttachmentsToSetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddAttachmentsToSetRequest> request = new DefaultRequest<AddAttachmentsToSetRequest>(addAttachmentsToSetRequest, "AWSSupport");
        String target = "AWSSupport_20130415.AddAttachmentsToSet";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag attachmentsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (addAttachmentsToSetRequest.getAttachmentSetId() != null) {
                jsonWriter.key("attachmentSetId").value(addAttachmentsToSetRequest.getAttachmentSetId());
            }
            if (!((attachmentsList = (ListWithAutoConstructFlag)addAttachmentsToSetRequest.getAttachments()) == null || attachmentsList.isAutoConstruct() && attachmentsList.isEmpty())) {
                jsonWriter.key("attachments");
                jsonWriter.array();
                for (Attachment attachmentsListValue : attachmentsList) {
                    if (attachmentsListValue == null) continue;
                    jsonWriter.object();
                    if (attachmentsListValue.getFileName() != null) {
                        jsonWriter.key("fileName").value(attachmentsListValue.getFileName());
                    }
                    if (attachmentsListValue.getData() != null) {
                        jsonWriter.key("data").value(attachmentsListValue.getData());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

