/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="sort_array", value="_FUNC_(array(obj1, obj2,...)) - Sorts the input array in ascending order according to the natural ordering of the array elements.", extended="Example:\n  > SELECT _FUNC_(array('b', 'd', 'c', 'a')) FROM src LIMIT 1;\n  'a', 'b', 'c', 'd'")
public class GenericUDFSortArray
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] converters;
    private final List<Object> ret = new ArrayList<Object>();
    private transient ObjectInspector[] argumentOIs;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        GenericUDFUtils.ReturnObjectInspectorResolver returnOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("The function SORT_ARRAY(array(obj1, obj2,...)) needs one argument.");
        }
        switch (arguments[0].getCategory()) {
            case LIST: {
                if (((ListObjectInspector)arguments[0]).getListElementObjectInspector().getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Argument 1 of function SORT_ARRAY must be array<" + (Object)((Object)ObjectInspector.Category.PRIMITIVE) + ">, but " + arguments[0].getTypeName() + " was found.");
            }
        }
        ObjectInspector elementObjectInspector = ((ListObjectInspector)arguments[0]).getListElementObjectInspector();
        this.argumentOIs = arguments;
        this.converters = new ObjectInspectorConverters.Converter[arguments.length];
        ObjectInspector returnOI = returnOIResolver.get();
        if (returnOI == null) {
            returnOI = elementObjectInspector;
        }
        this.converters[0] = ObjectInspectorConverters.getConverter(elementObjectInspector, returnOI);
        return ObjectInspectorFactory.getStandardListObjectInspector(returnOI);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0].get() == null) {
            return null;
        }
        Object array = arguments[0].get();
        ListObjectInspector arrayOI = (ListObjectInspector)this.argumentOIs[0];
        List<?> retArray = arrayOI.getList(array);
        final ObjectInspector valInspector = arrayOI.getListElementObjectInspector();
        Collections.sort(retArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ObjectInspectorUtils.compare(o1, valInspector, o2, valInspector);
            }
        });
        this.ret.clear();
        for (int i = 0; i < retArray.size(); ++i) {
            this.ret.add(this.converters[0].convert(retArray.get(i)));
        }
        return this.ret;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        return "sort_array(" + children[0] + ")";
    }
}

