/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="log2", value="_FUNC_(x) - Returns the logarithm of x with base 2", extended="Example:\n  > SELECT _FUNC_(2) FROM src LIMIT 1;\n  1")
public class UDFLog2
extends UDF {
    private static double log2 = Math.log(2.0);
    private DoubleWritable result = new DoubleWritable();

    public DoubleWritable evaluate(DoubleWritable a) {
        if (a == null || a.get() <= 0.0) {
            return null;
        }
        this.result.set(Math.log(a.get()) / log2);
        return this.result;
    }
}

