/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Repl State Log", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ReplStateLogWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ReplLogger replLogger;
    private final LOG_TYPE logType;
    private String eventId;
    private String eventType;
    private String tableName;
    private TableType tableType;
    private String functionName;
    private String lastReplId;

    public ReplStateLogWork(ReplLogger replLogger, String eventId, String eventType) {
        this.logType = LOG_TYPE.EVENT;
        this.replLogger = replLogger;
        this.eventId = eventId;
        this.eventType = eventType;
    }

    public ReplStateLogWork(ReplLogger replLogger, String tableName, TableType tableType) {
        this.logType = LOG_TYPE.TABLE;
        this.replLogger = replLogger;
        this.tableName = tableName;
        this.tableType = tableType;
    }

    public ReplStateLogWork(ReplLogger replLogger, String functionName) {
        this.logType = LOG_TYPE.FUNCTION;
        this.replLogger = replLogger;
        this.functionName = functionName;
    }

    public ReplStateLogWork(ReplLogger replLogger, Map<String, String> dbProps) {
        this.logType = LOG_TYPE.END;
        this.replLogger = replLogger;
        this.lastReplId = ReplicationSpec.getLastReplicatedStateFromParameters(dbProps);
    }

    public void replStateLog() {
        switch (this.logType) {
            case TABLE: {
                this.replLogger.tableLog(this.tableName, this.tableType);
                break;
            }
            case FUNCTION: {
                this.replLogger.functionLog(this.functionName);
                break;
            }
            case EVENT: {
                this.replLogger.eventLog(this.eventId, this.eventType);
                break;
            }
            case END: {
                this.replLogger.endLog(this.lastReplId);
            }
        }
    }

    private static enum LOG_TYPE {
        TABLE,
        FUNCTION,
        EVENT,
        END;

    }
}

