/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache;

import com.splunk.mr.cache.CacheIndexer;
import com.splunk.mr.cache.JobQueue;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;

public class JobQueueProcesser {
    private static final int NO_LIMIT = -1;
    private final JobQueue jobQueue;
    private final CacheIndexer cacheIndexer;
    private final CacheJobDeleter jobDeleter;

    public JobQueueProcesser(JobQueue jobQueue, CacheIndexer cacheIndexer, CacheJobDeleter jobDeleter) {
        this.jobQueue = jobQueue;
        this.cacheIndexer = cacheIndexer;
        this.jobDeleter = jobDeleter;
    }

    public int indexJobQueue() throws IOException {
        return this.indexJobQueue(-1);
    }

    public int indexJobQueue(int limit) throws IOException {
        List<JobQueue.CacheJob> jobs = this.jobQueue.listJobs();
        if (limit != -1) {
            jobs = jobs.subList(0, Math.min(limit, jobs.size()));
        }
        if (!jobs.isEmpty()) {
            this.processJobs(jobs);
        }
        return jobs.size();
    }

    private void processJobs(List<JobQueue.CacheJob> jobs) throws IOException {
        try {
            this.doProcessJobs(jobs);
        }
        catch (IOException ioe) {
            this.cacheIndexer.failed();
            throw ioe;
        }
        catch (RuntimeException re) {
            this.cacheIndexer.failed();
            throw re;
        }
        finally {
            this.cacheIndexer.teardown();
        }
    }

    private void doProcessJobs(List<JobQueue.CacheJob> jobs) throws IOException {
        this.cacheIndexer.setup();
        for (JobQueue.CacheJob job : jobs) {
            this.cacheIndexer.indexJob(job);
        }
        this.cacheIndexer.doneProcessingJobs();
        for (JobQueue.CacheJob job : jobs) {
            this.jobDeleter.deleteJob(job);
        }
    }

    public static class CacheJobDeleter {
        private final FileSystem fileSystem;

        public CacheJobDeleter(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
        }

        public void deleteJob(JobQueue.CacheJob job) throws IOException {
            this.fileSystem.delete(job.getPath(), true);
        }
    }
}

