/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import com.splunk.datamodel.DataModelBuckets;
import com.splunk.datamodel.DataModelCreator;
import com.splunk.io.SearchMetricsReporter;
import com.splunk.mr.AsyncMRJob;
import com.splunk.mr.JobInfo;
import com.splunk.mr.JobStartException;
import com.splunk.mr.JobSubmitterInputFormat;
import com.splunk.mr.SearchController;
import com.splunk.mr.SearchReducer;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.cache.compact.CompactionListener;
import com.splunk.mr.cache.integration.CacheKey;
import com.splunk.mr.cache.integration.CacheSplitListener;
import com.splunk.mr.input.InputSplitListener;
import com.splunk.mr.input.ObjectAcceptor;
import com.splunk.mr.input.RegexPathFilter;
import com.splunk.mr.input.VixInputSplit;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TIPStatus;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.log4j.Logger;

public class JobSubmitter
implements InputSplitListener,
CacheSplitListener {
    private static Logger gLogger = Logger.getLogger(JobSubmitter.class);
    protected static final int DEFAULT_SPLITS_MULTIPLIER = 10;
    protected static final int DEFAULT_MIN_SPLITS = 100;
    protected static final int DEFAULT_MAX_SPLITS = 10000;
    protected static final int DEFAULT_POLL_MS = 1000;
    protected static final int DEFAULT_SPLITS_PER_COMPACTION = 1000;
    protected int _cacheCompactionGrowth;
    protected int _nextCacheCompaction;
    protected int splitsCompleted = 0;
    protected int _nextDataModelFinalizeSplits = 0;
    protected boolean _writeToDM;
    protected DataModelBuckets _dataModelBuckets;
    protected boolean _createdLockFile = false;
    protected boolean _rampupSplits = false;
    protected float _splitsMultiplier = 10.0f;
    protected int _minSplitCount = 100;
    protected int _maxSplitCount = 10000;
    protected int _curMinSplitCount;
    protected int _jobCompletionPollMs = 1000;
    protected String _jobBaseName = String.valueOf(System.currentTimeMillis());
    protected Configuration _baseConf = null;
    protected ObjectAcceptor _resultAcceptor = null;
    protected SearchMetricsReporter _metrics = null;
    protected CompactionListener compactionListener;
    protected LinkedList<InputSplit> _splits = new LinkedList();
    protected Map<String, VixInputSplit> _cachedSplits = new ConcurrentHashMap<String, VixInputSplit>();
    protected volatile boolean _done = false;
    HashMap<String, Integer> _jobName2MapCount = new HashMap();
    protected long _totalSplits = 0L;
    protected AsyncMRJob _job = null;
    protected SearchController _searchController = null;
    protected ArrayList<AsyncMRJob> _jobHistory = new ArrayList();
    private Class<? extends Mapper> _mapperClass = SplunkMR.SearchHandler.DEFAULT_MAPPER_CLASS;
    protected SplunkMR.SearchHandler _searchHandler = null;
    protected File _searchDispatchDir = null;
    private int lastCompactionSplitNumber = 0;
    private WeakHashMap<Job, Boolean> hasWaitedForJob = new WeakHashMap();
    private Set<String> processedCompletionEventsFromOutputDir;
    static Map<String, JobSubmitter> SUBMITTERS = new HashMap<String, JobSubmitter>();

    protected JobSubmitter(Configuration conf, String baseName, ObjectAcceptor eventAcceptor, SearchMetricsReporter metrics) {
        this._baseConf = conf;
        this._jobBaseName = "SPLK_" + SplunkMR.HOSTNAME + "_" + baseName;
        this._resultAcceptor = eventAcceptor;
        this._metrics = metrics;
        this._maxSplitCount = this._baseConf.getInt(SplunkMR.CONF_MAX_SPLITS, 10000);
        if (this._maxSplitCount < 0) {
            this._maxSplitCount = 10000;
        }
        this._splitsMultiplier = this._baseConf.getFloat(SplunkMR.CONF_SPLITS_MULTIPLITER, 10.0f);
        if (this._splitsMultiplier < 1.0f) {
            this._splitsMultiplier = 10.0f;
        }
        this._minSplitCount = this._baseConf.getInt(SplunkMR.CONF_MIN_SPLITS, 100);
        if (this._minSplitCount < 0 || this._minSplitCount > this._maxSplitCount) {
            this._minSplitCount = Math.min(100, this._maxSplitCount);
        }
        this._curMinSplitCount = this._minSplitCount;
        this._jobCompletionPollMs = this._baseConf.getInt(SplunkMR.CONF_MR_POLL_MS, 1000);
        if (this._jobCompletionPollMs < 0) {
            this._jobCompletionPollMs = 1000;
        }
        this._cacheCompactionGrowth = this._baseConf.getInt(SplunkMR.CONF_SPLITS_PER_COMPACTION, 1000);
        if (this._cacheCompactionGrowth < 0) {
            this._cacheCompactionGrowth = 1000;
        }
        this._nextCacheCompaction = this._cacheCompactionGrowth;
        this._searchDispatchDir = SplunkMR.getSearchDispatchDir(conf);
        this._searchController = SearchController.init(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDone() throws IOException {
        try {
            LinkedList<InputSplit> linkedList = this._splits;
            synchronized (linkedList) {
                return this._done && this._splits.isEmpty() && this._cachedSplits.isEmpty() && (this._job == null || this.hasWaitedForJob.get(this._job) != false && this._job.isComplete());
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public synchronized void waitForCompletion() throws ClassNotFoundException, IOException, InterruptedException, InstantiationException {
        while (!this.isDone() && this._job != null) {
            this.waitForCurrentJobToComplete();
        }
    }

    public synchronized void shutdown(boolean force) throws InterruptedException, IOException {
        if (this._job != null && !this._job.isComplete() && !this.isDone()) {
            this._job.kill();
            this._job = null;
        }
        this.setDoneForced(force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InputSplit> getSplits(String jobName) {
        gLogger.info((Object)("_curMinSplitCount=" + this._curMinSplitCount + ",_splits.size=" + this._splits.size() + ", _minSplitCount=" + this._minSplitCount + ", _maxSplitCount=" + this._maxSplitCount));
        LinkedList<InputSplit> result = new LinkedList<InputSplit>();
        LinkedList<InputSplit> linkedList = this._splits;
        synchronized (linkedList) {
            int count = Math.min(this._curMinSplitCount, this._splits.size());
            for (int i = 0; i < count; ++i) {
                result.add(this._splits.removeFirst());
            }
            this._jobName2MapCount.put(jobName, count);
            this._curMinSplitCount = this._minSplitCount;
        }
        return result;
    }

    private void processIntermediateResults(Set<TaskID> processedIds, boolean reduceTasks) throws IOException {
        FileStatus[] files;
        if (this._writeToDM) {
            return;
        }
        gLogger.debug((Object)("processing intermediate results based on filesystem, jobId=" + this._job.getJobID()));
        Configuration jobConf = this._job.getConfiguration();
        Path p = SplunkMR.getHDFSDispatchHome(jobConf);
        FileSystem fs = p.getFileSystem(jobConf);
        for (FileStatus fstat : files = fs.listStatus(p)) {
            TaskID tid;
            if (fstat.isDir()) continue;
            String fileName = fstat.getPath().getName();
            if (fileName.startsWith("part-m-")) {
                try {
                    fs.delete(fstat.getPath(), false);
                }
                catch (Exception exception) {}
                continue;
            }
            Matcher m = SplunkMR.JOB_FILE_REGEX.matcher(fileName);
            if (!m.matches()) continue;
            String taskType = m.group(1);
            String taskId = m.group(2);
            if (taskType == null || taskId == null) {
                gLogger.warn((Object)("Invalid intermediate file name=" + fileName + ", skipping ..."));
                continue;
            }
            boolean isMap = "m".equals(taskType);
            if (reduceTasks == isMap || processedIds.contains(tid = new TaskID(this._job.getJobID(), isMap, Integer.parseInt(taskId)))) continue;
            TaskCompletionEvent tce = new TaskCompletionEvent(1, new TaskAttemptID(tid, 0), tid.getId(), isMap, TaskCompletionEvent.Status.SUCCEEDED, null);
            if (!this._resultAcceptor.accept(CompletionEvent.create(this._job, tce, isMap))) {
                throw new IOException("Result acceptor stopped accepting results ...");
            }
            processedIds.add(tid);
        }
    }

    private synchronized void finalizeDataModelFiles(boolean forceFinalize) throws FileNotFoundException, IOException {
        if (forceFinalize || this.splitsCompleted - this._nextDataModelFinalizeSplits >= 1000) {
            this._nextDataModelFinalizeSplits = this.splitsCompleted;
            gLogger.debug((Object)("splitsCompleted=" + this.splitsCompleted + ", finalizing data model files ..."));
            this._dataModelBuckets.finalizeDataModelFiles();
        }
    }

    private synchronized int processCompletionEvents(int startId, Set<TaskID> processedIds, boolean reduceTasks) throws IOException {
        RunningJob rj = this._job.getRunningJob();
        TaskCompletionEvent[] events = this._job.getRunningJob().getTaskCompletionEvents(startId);
        while (events.length > 0) {
            startId += events.length;
            this.splitsCompleted += events.length;
            if (this._writeToDM) {
                this.finalizeDataModelFiles(false);
            } else {
                this.compactCache();
                for (TaskCompletionEvent tce : events) {
                    TaskID tid;
                    gLogger.debug((Object)("Got a completion task. jobId=" + rj.getID() + ", taskId=" + String.valueOf(tce.getTaskAttemptId()) + ", eventId=" + String.valueOf(tce.getEventId()) + ", state=" + tce.getTaskStatus() + ", mapTask=" + tce.isMapTask()));
                    boolean isMap = tce.getTaskAttemptId().toString().contains("_m_");
                    if (isMap && !tce.isMapTask() || reduceTasks == isMap || tce.getTaskStatus() != TaskCompletionEvent.Status.SUCCEEDED || processedIds.contains(tid = tce.getTaskAttemptId().getTaskID())) continue;
                    if (!this._resultAcceptor.accept(CompletionEvent.create(this._job, tce, isMap))) {
                        throw new IOException("Result acceptor stopped accepting results ...");
                    }
                    processedIds.add(tid);
                }
            }
            events = this._job.getRunningJob().getTaskCompletionEvents(startId);
        }
        gLogger.debug((Object)("finished processing until eventId=" + startId + ", processed total=" + processedIds.size()));
        return startId;
    }

    private synchronized void compactCache() throws IOException {
        if (this.compactionListener != null && this._nextCacheCompaction < this.splitsCompleted) {
            int splitsSinceLastCompaction = this.splitsCompleted - this.lastCompactionSplitNumber;
            this.lastCompactionSplitNumber = this.splitsCompleted;
            this._nextCacheCompaction = this.splitsCompleted + this._cacheCompactionGrowth;
            this.compactionListener.compact(splitsSinceLastCompaction);
        }
    }

    private int updateMRCountMetrics(String jobName, float mapProgress, int reported, int added) {
        if (this._metrics == null) {
            return reported;
        }
        int completed = (int)((float)this._jobName2MapCount.get(jobName).intValue() * mapProgress);
        if (completed == reported && added == 0) {
            return reported;
        }
        this._metrics.addCountMetric("MR", added, completed - reported);
        this._metrics.addCountMetric("MR." + jobName, added, completed - reported);
        return completed;
    }

    private long updateMRMetrics(String jobName, long lastReportTime) {
        if (this._metrics == null) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        this._metrics.addMetric("MR", now - lastReportTime, 1L);
        this._metrics.addMetric("MR." + jobName, now - lastReportTime, 1L);
        return now;
    }

    private void updateFailedTasksMetrics(String jobName, Map<TIPStatus, List<TaskReport>> groupedTasksByStatus) {
        int failedTasks = this.sumFailedAndKilledTasks(groupedTasksByStatus);
        String failedTasksMetric = "MR.failed.tasks";
        this._metrics.addMetric(failedTasksMetric, 1L, 1L);
        this._metrics.addCountMetric(failedTasksMetric, 0L, failedTasks);
        String failedTasksByJob = failedTasksMetric + "." + jobName;
        this._metrics.addMetric(failedTasksByJob, 1L, 1L);
        this._metrics.addCountMetric(failedTasksByJob, 0L, failedTasks);
    }

    private File getRemoteLogsDir(Configuration conf) {
        File remoteLogsDir = new File(this._searchDispatchDir, "remote_logs");
        if (!remoteLogsDir.exists()) {
            remoteLogsDir.mkdirs();
        }
        return remoteLogsDir;
    }

    private void removeEmptyFile(File f) {
        if (f.isFile() && f.length() == 0L) {
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMapErrorsToDispatchDir() {
        if (this._job != null) {
            long starttime = System.currentTimeMillis();
            Configuration conf = this._job.getConfiguration();
            File remoteLogsDir = this.getRemoteLogsDir(conf);
            File mapErrLog = new File(remoteLogsDir, "erp_" + conf.get(SplunkMR.CONF_PROVIDER) + "_tasks.search.log");
            HashMap<String, TaskReport[]> trMap = new HashMap<String, TaskReport[]>();
            BufferedOutputStream out = null;
            try {
                trMap.put("SETUP", this._job.getSetupTaskReports());
                trMap.put("MAP", this._job.getMapTaskReports());
                trMap.put("CLEANUP", this._job.getCleanupTaskReports());
                out = new BufferedOutputStream(FileUtils.openOutputStream((File)mapErrLog, (boolean)true));
                for (Map.Entry me : trMap.entrySet()) {
                    for (TaskReport tr : (TaskReport[])me.getValue()) {
                        String[] errors = tr.getDiagnostics();
                        gLogger.debug((Object)("task report for taskreport=" + tr.getTaskID().toString() + ", numerrors=" + errors.length));
                        if (errors.length <= 0) continue;
                        IOUtils.write((String)(tr.getTaskID().toString() + " [" + (String)me.getKey() + "]\n"), (OutputStream)out);
                        for (String s : errors) {
                            IOUtils.write((String)(s + "\n"), (OutputStream)out);
                        }
                        IOUtils.write((String)"\n", (OutputStream)out);
                    }
                }
                IOUtils.closeQuietly((OutputStream)out);
                this.removeEmptyFile(mapErrLog);
            }
            catch (Exception e) {
                gLogger.warn((Object)("Failed to collect map errors for job " + this._job.getJobName()), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly(out);
                this.removeEmptyFile(mapErrLog);
            }
            gLogger.info((Object)("time spent writing map errors, elapsed_ms=" + (System.currentTimeMillis() - starttime)));
        }
    }

    private synchronized void waitForCurrentJobToComplete() throws ClassNotFoundException, IOException, InterruptedException, InstantiationException {
        if (this._job != null && !this.hasWaitedForJob.get(this._job).booleanValue()) {
            boolean isJobSuccessful;
            this.hasWaitedForJob.put(this._job, true);
            String jobName = this._job.getJobName();
            RunningJob rj = this._job.getRunningJob();
            if (rj == null) {
                throw new IllegalStateException("Failed to get the running job instance. Please make sure you have the correct hadoop client library.");
            }
            int startId = 0;
            int reported = 0;
            long lastReportTime = this._job.getSubmitTime();
            boolean processReduceTasks = this._job.getNumReduceTasks() > 0;
            HashSet<TaskID> processedTaksIds = new HashSet<TaskID>();
            if (!this._job.isComplete()) {
                gLogger.info((Object)("waiting for job to complete job.name=" + jobName));
                float mapProgress = 0.0f;
                while (!this._job.isComplete()) {
                    if (this._searchController.shouldStop()) {
                        gLogger.warn((Object)this._searchController.getStopReason());
                        this.shutdown(true);
                        return;
                    }
                    this.wait(this._jobCompletionPollMs);
                    mapProgress = rj.mapProgress();
                    gLogger.info((Object)String.format("JobId=%s, Map: %.2f%%, Reduce: %.2f%%\n", rj.getID(), Float.valueOf(mapProgress * 100.0f), Float.valueOf(rj.reduceProgress() * 100.0f)));
                    startId = this.processCompletionEvents(startId, processedTaksIds, processReduceTasks);
                    reported = this.updateMRCountMetrics(jobName, mapProgress, reported, 0);
                    lastReportTime = this.updateMRMetrics(jobName, lastReportTime);
                }
                Map<TIPStatus, List<TaskReport>> groupedTasksByStatus = this.groupTasksByLatestStatus();
                this.logJobsTasksStatuses(jobName, groupedTasksByStatus);
                this.updateFailedTasksMetrics(jobName, groupedTasksByStatus);
            } else {
                gLogger.info((Object)("job already completed, job.name=" + jobName));
            }
            if (this._writeToDM) {
                this.finalizeDataModelFiles(true);
            }
            Map<TIPStatus, List<TaskReport>> groupedTasksByStatus = this.groupTasksByLatestStatus();
            this.logJobsTasksStatuses(jobName, groupedTasksByStatus);
            this.updateFailedTasksMetrics(jobName, groupedTasksByStatus);
            this.writeMapErrorsToDispatchDir();
            this.writeSearchProcessErrorsToDispatchDir();
            try {
                isJobSuccessful = this._job.isSuccessful();
            }
            catch (Exception e) {
                String message = "Error while checking whether the job is successful or not, job.name=" + jobName + (SplunkMR.isYarn(this._job.getConfiguration()) ? ". This error might be caused by not having configured vix.mapreduce.jobhistory.address, please configure this for the vix provider and retry." : "");
                gLogger.error((Object)message, (Throwable)e);
                throw new IOException(message, e);
            }
            if (isJobSuccessful) {
                if (SplunkMR.isIntegrationTestRun(this._baseConf)) {
                    this.processCompletionEventsFromOutputDir(processedTaksIds);
                }
            } else {
                JobInfo info = JobInfo.getInstance(this._job);
                throw new IOException("Error while waiting for MapReduce job to complete, job_id=[!" + rj.getTrackingURL() + " " + this._job.getJobID() + "], state=" + info.getRunState() + ", reason=" + info.getFailureInfo());
            }
            this.processIntermediateResults(processedTaksIds, processReduceTasks);
            reported = this.updateMRCountMetrics(jobName, 1.0f, reported, 0);
            lastReportTime = this.updateMRMetrics(jobName, lastReportTime);
            gLogger.info((Object)("Finished waiting for job=" + this._job.getJobName() + ", consumed tasks=" + processedTaksIds.size()));
        }
    }

    private void processCompletionEventsFromOutputDir(Set<TaskID> processedTaksIds) throws IOException {
        if (this._writeToDM) {
            return;
        }
        if (this.processedCompletionEventsFromOutputDir == null) {
            this.processedCompletionEventsFromOutputDir = new HashSet<String>();
        }
        Path outputDirectory = new Path(this._job.getConfiguration().get("mapred.output.dir"));
        FileSystem fs = FileSystem.get((Configuration)this._baseConf);
        if (fs.exists(outputDirectory)) {
            FileStatus[] ls;
            try {
                ls = fs.listStatus(outputDirectory);
            }
            catch (Exception e) {
                ls = fs.listStatus(outputDirectory);
            }
            for (FileStatus status : ls) {
                String path = status.getPath().toUri().getPath();
                String filename = status.getPath().getName();
                boolean isPartFile = filename.startsWith("part");
                if (!isPartFile || this.processedCompletionEventsFromOutputDir.contains(path)) continue;
                boolean isMapEvent = filename.split("-")[1].equals("m");
                int taskId = Integer.parseInt(filename.split("-")[2]);
                processedTaksIds.add(new TaskID(this._job.getJobID(), isMapEvent, taskId));
                this._resultAcceptor.accept(new CompletionEvent(this._job, isMapEvent, taskId, TaskCompletionEvent.Status.SUCCEEDED));
                this.processedCompletionEventsFromOutputDir.add(path);
            }
        } else {
            gLogger.warn((Object)("Mapred output directory did not exist: " + outputDirectory));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSearchProcessErrorsToDispatchDir() {
        Configuration conf = this._job.getConfiguration();
        File remoteLogsDir = this.getRemoteLogsDir(conf);
        File spErrLog = new File(remoteLogsDir, "erp_" + conf.get(SplunkMR.CONF_PROVIDER) + "_splunk.search.log");
        Path hdfsDispatchDir = new Path(conf.get(SplunkMR.CONF_DISPATCH_DIR));
        BufferedOutputStream out = null;
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            FileStatus[] errFiles = fs.listStatus(hdfsDispatchDir, (PathFilter)new RegexPathFilter("splunk-err-[mr]-\\d+$"));
            out = new BufferedOutputStream(FileUtils.openOutputStream((File)spErrLog, (boolean)true));
            for (FileStatus efs : errFiles) {
                Path efsPath = efs.getPath();
                if (efs.getLen() == 0L) continue;
                FSDataInputStream in = fs.open(efsPath);
                try {
                    IOUtils.write((String)("task_id=" + efsPath.getName().substring("splunk-err-".length()) + "\n"), (OutputStream)out);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    IOUtils.write((String)"\n", (OutputStream)out);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
        }
        catch (Exception e) {
            try {
                gLogger.warn((Object)("Failed to collect search process errors for job " + this._job.getJobName()), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                this.removeEmptyFile(spErrLog);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
            this.removeEmptyFile(spErrLog);
        }
        IOUtils.closeQuietly((OutputStream)out);
        this.removeEmptyFile(spErrLog);
    }

    private Map<TIPStatus, List<TaskReport>> groupTasksByLatestStatus() throws IOException {
        HashMap<TIPStatus, List<TaskReport>> statuses = new HashMap<TIPStatus, List<TaskReport>>();
        for (TIPStatus tIPStatus : TIPStatus.values()) {
            statuses.put(tIPStatus, new ArrayList());
        }
        for (TIPStatus tIPStatus : this._job.getMapTaskReports()) {
            ((List)statuses.get(tIPStatus.getCurrentStatus())).add(tIPStatus);
        }
        return statuses;
    }

    private void logJobsTasksStatuses(String jobName, Map<TIPStatus, List<TaskReport>> statuses) throws IOException {
        String logPrefix = "job.name" + jobName;
        gLogger.info((Object)(logPrefix + ", Successful tasks: " + this.getTasks(statuses, TIPStatus.COMPLETE)));
        gLogger.info((Object)(logPrefix + ", Failed or killed tasks: " + this.sumFailedAndKilledTasks(statuses)));
    }

    private int getTasks(Map<TIPStatus, List<TaskReport>> tasksGroupedByStatus, TIPStatus status) {
        return tasksGroupedByStatus.get(status).size();
    }

    private int sumFailedAndKilledTasks(Map<TIPStatus, List<TaskReport>> statuses) {
        return this.getTasks(statuses, TIPStatus.KILLED) + this.getTasks(statuses, TIPStatus.FAILED);
    }

    private synchronized void startJobImpl() throws ClassNotFoundException, IOException, InterruptedException, InstantiationException {
        this.waitForCurrentJobToComplete();
        if (this._done) {
            gLogger.info((Object)("JobSubmitter is done, not submitting job! split.count=" + this._splits.size()));
            return;
        }
        if (this._job != null) {
            this._jobHistory.add(this._job);
        }
        if (this._jobHistory.isEmpty() && this._searchHandler != null) {
            this._searchHandler.setupMREnv(this._baseConf);
        }
        gLogger.info((Object)("creating new job, current split.count=" + this._splits.size()));
        long st = System.currentTimeMillis();
        int id = this._jobHistory.size();
        String jobName = this._jobBaseName + "_" + id;
        Configuration conf = new Configuration(this._baseConf);
        String jobOutputHome = SplunkMR.getHDFSDispatchHome(conf).toString();
        if (conf.get("splunk.search.multistep") != null && conf.get("splunk.search.multistep").equals("1")) {
            gLogger.debug((Object)"Multi Step search found...");
            jobOutputHome = jobOutputHome + "_" + System.currentTimeMillis();
        }
        Path outputDir = new Path(jobOutputHome, String.valueOf(id));
        conf.set(SplunkMR.CONF_DISPATCH_DIR, outputDir.toString());
        this._jobName2MapCount.put(jobName, 0);
        AsyncMRJob newJob = new AsyncMRJob(conf, jobName);
        newJob.setOutputKeyClass(Text.class);
        newJob.setOutputValueClass(Text.class);
        newJob.setMapperClass(this._mapperClass);
        int reduceTasks = 0;
        if (conf.get(SplunkMR.CONF_SEARCH_MODE, "").compareToIgnoreCase("report") == 0 && !conf.get(SplunkMR.CONF_SEARCH_REDUCE, "").isEmpty()) {
            reduceTasks = conf.getInt("mapred.reduce.tasks", 3);
        }
        newJob.setReducerClass(SearchReducer.class);
        newJob.setNumReduceTasks(reduceTasks);
        newJob.setInputFormatClass(JobSubmitterInputFormat.class);
        newJob.setOutputFormatClass(TextOutputFormat.class);
        FileOutputFormat.setOutputPath((Job)newJob, (Path)outputDir);
        newJob.setJarByClass(SplunkMR.class);
        gLogger.info((Object)("submitting new job, name=" + jobName));
        newJob.submit(false);
        this._job = newJob;
        this.hasWaitedForJob.put(this._job, false);
        if (this._job.getError() != null) {
            throw new RuntimeException("Failed to start MapReduce job, name=" + jobName);
        }
        this._metrics.addLink(this._job.getJobName(), this._job.getTrackingURL());
        this.updateMRMetrics(jobName, st);
        this.updateMRCountMetrics(jobName, 0.0f, 0, this._jobName2MapCount.get(jobName));
    }

    public void setMapperClass(Class<? extends Mapper> mapperClass) {
        this._mapperClass = mapperClass;
    }

    public void setSearchHandler(SplunkMR.SearchHandler sh) {
        this._searchHandler = sh;
    }

    private synchronized void setDoneForced(boolean stopAcceptor) {
        this._done = true;
        if (stopAcceptor) {
            this._resultAcceptor.accept(null);
        }
    }

    private synchronized void startJob() {
        try {
            if (this._writeToDM && !this._createdLockFile) {
                this._createdLockFile = DataModelCreator.createLockFile(this._baseConf);
                if (!this._createdLockFile) {
                    this.shutdown(true);
                    return;
                }
            }
            if (!this._done) {
                this.startJobImpl();
            }
        }
        catch (Exception e) {
            this.setDoneForced(true);
            String message = this.getCombinedAsyncJobExceptionMessage(e);
            throw new JobStartException(message, e);
        }
    }

    private String getCombinedAsyncJobExceptionMessage(Exception e) {
        if (this._job != null && this._job.getError() != null) {
            return String.format("[ %s ] and [ %s ]", e.getMessage(), this._job.getError().getMessage());
        }
        return e.getMessage();
    }

    @Override
    public void beginning() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gotSplit(VixInputSplit split) {
        if (this._done) {
            return;
        }
        if (!this._resultAcceptor.accept(split)) {
            this.setDoneForced(false);
            return;
        }
        boolean startNewJob = false;
        LinkedList<InputSplit> linkedList = this._splits;
        synchronized (linkedList) {
            this._splits.add(split);
            ++this._totalSplits;
            boolean bl = startNewJob = this._splits.size() > this._minSplitCount;
            if (startNewJob && this._minSplitCount < this._maxSplitCount) {
                this._minSplitCount = Math.min(this._maxSplitCount, (int)((float)this._minSplitCount * this._splitsMultiplier));
            }
        }
        if (startNewJob) {
            this.startJob();
        }
    }

    @Override
    public synchronized void finished() {
        gLogger.info((Object)("finished called: _splits.count=" + this._splits.size() + ", total.count=" + this._totalSplits));
        try {
            this.startJobForAvailableSplits();
            this.waitForCacheReadsToFinish();
            this.startJobForAvailableSplits();
        }
        finally {
            this.setDoneForced(false);
        }
    }

    private synchronized void startJobForAvailableSplits() {
        while (!this._done && !this._splits.isEmpty()) {
            this.startJob();
        }
    }

    private synchronized void waitForCacheReadsToFinish() {
        while (!this._done && !this._cachedSplits.isEmpty()) {
            try {
                this.wait(500L);
            }
            catch (InterruptedException e) {
                gLogger.info((Object)"Was interrupted in finished(). Exiting.");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ObjectAcceptor> JobSubmitter get(Configuration conf, T eventAcceptor, SearchMetricsReporter metrics, Class<? extends JobSubmitter> jsClazz) {
        String name = conf.get(SplunkMR.CONF_SEARCH_ID);
        Map<String, JobSubmitter> map = SUBMITTERS;
        synchronized (map) {
            JobSubmitter result = SUBMITTERS.get(name);
            if (result == null) {
                if (jsClazz == null) {
                    jsClazz = JobSubmitter.class;
                }
                try {
                    Constructor<? extends JobSubmitter> c = jsClazz.getDeclaredConstructor(Configuration.class, String.class, ObjectAcceptor.class, SearchMetricsReporter.class);
                    c.setAccessible(true);
                    result = c.newInstance(conf, name, eventAcceptor, metrics);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                SUBMITTERS.put(name, result);
            }
            return result;
        }
    }

    public void setCompactionListener(CompactionListener compactionListener) {
        this.compactionListener = compactionListener;
    }

    @Override
    public void gotCachedSplit(VixInputSplit split, CacheKey cacheKey) {
        this._cachedSplits.put(cacheKey.getSplitSearchId(), split);
    }

    @Override
    public void onCacheReadSuccess(CacheKey cacheKey) {
        this._cachedSplits.remove(cacheKey.getSplitSearchId());
    }

    @Override
    public void onCacheReadFailure(CacheKey cacheKey) {
        VixInputSplit inputSplit = this._cachedSplits.get(cacheKey.getSplitSearchId());
        try {
            this.gotSplit(inputSplit);
        }
        finally {
            this._cachedSplits.remove(cacheKey.getSplitSearchId());
        }
    }

    @Override
    public void doneCacheReading() {
        if (!this._cachedSplits.isEmpty()) {
            gLogger.warn((Object)("Cache reading was done, but not all cached splits were removed by failures or successfull reads. Remaining cached splits: " + this._cachedSplits.size()));
        }
        this._cachedSplits.clear();
    }

    public void setDataModelBuckets(DataModelBuckets dataModelBuckets) {
        this._dataModelBuckets = dataModelBuckets;
    }

    public void setWriteToDM(boolean writeToDM) {
        this._writeToDM = writeToDM;
    }

    public boolean isLockFileCreatedForDMSearch() {
        return this._createdLockFile;
    }

    public static class CompletionEvent {
        private final boolean isMapEvent;
        private final int taskId;
        private final TaskCompletionEvent.Status taskStatus;
        private final AsyncMRJob job;

        public CompletionEvent(AsyncMRJob job, boolean isMapEvent, int taskId, TaskCompletionEvent.Status taskStatus) {
            this.job = job;
            this.isMapEvent = isMapEvent;
            this.taskId = taskId;
            this.taskStatus = taskStatus;
        }

        public int getTaskId() {
            return this.taskId;
        }

        public String getFileType() {
            return this.isMapEvent ? "m" : "r";
        }

        public Configuration getConfiguration() {
            return this.job.getConfiguration();
        }

        public TaskCompletionEvent.Status getTaskStatus() {
            return this.taskStatus;
        }

        public String toString() {
            return "job_id=" + this.job.getJobID() + ", isMapEvent=" + this.isMapEvent + ", taskId=" + this.taskId + ", taskStatus=" + this.taskStatus;
        }

        public static CompletionEvent create(AsyncMRJob job, TaskCompletionEvent event, boolean isMapEvent) {
            return new CompletionEvent(job, isMapEvent, event.getTaskAttemptId().getTaskID().getId(), event.getTaskStatus());
        }
    }
}

