/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.journal.hadoop;

import com.splunk.journal.EventData;
import com.splunk.journal.RawdataJournalReader;
import com.splunk.journal.SimpleCsvWriter;
import com.splunk.journal.hadoop.KeyValueFormatter;
import com.splunk.util.StrUtil;
import com.splunk.util.TextUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class RecordReaderHelper {
    static Logger logger = Logger.getLogger(RecordReaderHelper.class);
    public static final String KEY_FORMAT_CONFIG = "com.splunk.journal.hadoop.key_format";
    public static final String VALUE_FORMAT_CONFIG = "com.splunk.journal.hadoop.value_format";
    public static final String ESCAPE_CHAR_CONFIG = "com.splunk.journal.hadoop.escape_char";
    public static final String SEPARATOR_CHAR_CONFIG = "com.splunk.journal.hadoop.separator_char";
    public static final String SUPPRESS_EXCEPTIONS_CONFIG = "com.splunk.journal.hadoop.suppress.exceptions";
    RawdataJournalReader reader;
    EventData currentEvent;
    KeyValueFormatter formatter;
    float fileLength;
    long mostRecentPos;
    boolean suppressExceptions;

    public void initialize(Path path, long start, long length, Configuration conf) throws IOException {
        this.suppressExceptions = RecordReaderHelper.shouldSuppressExcpetions(conf);
        logger.info((Object)("Suppressing exceptions? " + this.suppressExceptions));
        try {
            FileSystem fs = path.getFileSystem(conf);
            FileStatus status = fs.getFileStatus(path);
            if (start != 0L || length != status.getLen()) {
                throw new IllegalArgumentException("Received a file split representing a proper subset of a file. Splunk raw-data journal files are not splittable. path = " + path.toString() + ", start = " + start + ", length = " + length);
            }
            FSDataInputStream fileIn = fs.open(path);
            this.reader = RawdataJournalReader.getReaderForGzipCompressedStream((InputStream)fileIn);
            this.fileLength = fs.getFileStatus(path).getLen();
            String[] keyFields = RecordReaderHelper.getKeyFieldNames(conf);
            String[] valueFields = RecordReaderHelper.getValueFieldNames(conf);
            Character separatorChar = RecordReaderHelper.getSeparatorChar(conf);
            Character escapeChar = RecordReaderHelper.getEscapeChar(conf);
            this.formatter = new KeyValueFormatter(keyFields, valueFields, escapeChar, separatorChar);
        }
        catch (IOException ex) {
            this.handleException(ex);
        }
        catch (RuntimeException ex) {
            this.handleException(ex);
        }
    }

    public boolean nextKeyValue() throws IOException {
        boolean foundNext = false;
        try {
            this.currentEvent = this.reader.readEvent();
            if (null != this.currentEvent) {
                this.formatter.setEventData(this.currentEvent);
                this.mostRecentPos = this.currentEvent.getFileOffset();
                foundNext = true;
            }
        }
        catch (IOException ex) {
            this.handleException(ex);
        }
        catch (RuntimeException ex) {
            this.handleException(ex);
        }
        return foundNext;
    }

    public void getCurrentKey(Text key) throws IOException {
        byte[] keyBytes = this.formatter.readKey();
        TextUtil.setTextInternals(key, keyBytes);
    }

    public void getCurrentValue(Text value) throws IOException {
        byte[] valueBytes = this.formatter.readValue();
        TextUtil.setTextInternals(value, valueBytes);
    }

    public static String[] getKeyFieldNames(Configuration conf) {
        String keyFormat = conf.get(KEY_FORMAT_CONFIG, "eventOffsetInFile");
        return keyFormat.split(",");
    }

    public static String[] getValueFieldNames(Configuration conf) {
        String valueFormat = conf.get(VALUE_FORMAT_CONFIG);
        if (null != valueFormat) {
            return valueFormat.split(",");
        }
        return KeyValueFormatter.getBuiltinFieldNames();
    }

    public static Character getSeparatorChar(Configuration conf) {
        return RecordReaderHelper.getCharConfig(SEPARATOR_CHAR_CONFIG, conf, SimpleCsvWriter.DEFAULT_SEPARATOR_CHAR);
    }

    public static Character getEscapeChar(Configuration conf) {
        return RecordReaderHelper.getCharConfig(ESCAPE_CHAR_CONFIG, conf, SimpleCsvWriter.DEFAULT_ESCAPE_CHAR);
    }

    public static boolean shouldSuppressExcpetions(Configuration conf) {
        return StrUtil.parseBoolean(conf.get(SUPPRESS_EXCEPTIONS_CONFIG), false);
    }

    private static Character getCharConfig(String key, Configuration conf, char defaultValue) {
        String val = conf.get(key);
        if (null != val) {
            if (val.length() == 1) {
                return Character.valueOf(val.charAt(0));
            }
            logger.warn((Object)("Configuration value for '" + key + "' must be a single character. Value '" + val + "' will be ignored."));
        }
        return Character.valueOf(defaultValue);
    }

    public long getPosition() {
        return this.mostRecentPos;
    }

    public float getProgress() throws IOException {
        return this.fileLength / (float)this.mostRecentPos;
    }

    public void close() throws IOException {
        if (null != this.reader) {
            this.reader.close();
        }
    }

    private void handleException(IOException ex) throws IOException {
        if (!this.suppressExceptions) {
            throw ex;
        }
        logger.info((Object)("Suppressing " + ex.getClass().getCanonicalName() + " with message: " + ex.getMessage()));
    }

    private void handleException(RuntimeException ex) throws IOException {
        if (!this.suppressExceptions) {
            throw ex;
        }
        logger.info((Object)("Suppressing " + ex.getClass().getCanonicalName() + " with message: " + ex.getMessage()));
    }
}

