/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.search;

import com.splunk.search.SearchProcessor;
import com.splunk.search.SearchResults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SearchPipeline
extends SearchProcessor {
    protected static final SearchProcessor.Factory DEFAULT_FACTORY = new SearchProcessor.DefaultFactory();
    protected static LinkedList<SearchProcessor.Factory> FACTORIES = new LinkedList();
    protected ArrayList<SearchProcessor> _pipe = new ArrayList();
    boolean _calledAboutToExecute = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerFactory(SearchProcessor.Factory factory) {
        LinkedList<SearchProcessor.Factory> linkedList = FACTORIES;
        synchronized (linkedList) {
            FACTORIES.push(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchProcessor createProcessor(String name) {
        LinkedList<SearchProcessor.Factory> linkedList = FACTORIES;
        synchronized (linkedList) {
            for (SearchProcessor.Factory f : FACTORIES) {
                SearchProcessor sp = f.createProcessor(name);
                if (sp == null) continue;
                return sp;
            }
        }
        return DEFAULT_FACTORY.createProcessor(name);
    }

    public SearchPipeline(List<Map<String, Object>> data) {
        this._name = "PIPELINE";
        this._search_string = null;
        int index = 0;
        for (Map<String, Object> spData : data) {
            Object procName = spData.get("name");
            if (procName == null) {
                throw new IllegalArgumentException("No name field found: " + Arrays.toString(spData.entrySet().toArray()));
            }
            SearchProcessor sp = SearchPipeline.createProcessor(procName.toString());
            sp.initFrom(spData, index++);
            if (index == 1 && sp.isImplemented() && !sp.isGenerating()) {
                throw new IllegalArgumentException("The first search command of a search pipeline needs to be a generting command: " + sp.getName());
            }
            if (index != 1 && sp.isImplemented() && sp.isGenerating()) {
                throw new IllegalArgumentException("Generting search commands must be the first command in the search pipeline: " + sp.getName());
            }
            this._pipe.add(sp);
        }
    }

    @Override
    public boolean isPipeline() {
        return true;
    }

    @Override
    public boolean isImplemented() {
        return this._pipe.isEmpty() ? true : this._pipe.get(0).isImplemented();
    }

    @Override
    public String getUnimplmented() {
        StringBuilder sb = new StringBuilder();
        boolean seenUnimplemented = false;
        for (SearchProcessor sp : this._pipe) {
            if (!seenUnimplemented && sp.isImplemented()) continue;
            seenUnimplemented = true;
            if (sb.length() != 0) {
                sb.append(" | ");
            }
            sb.append(sp.toString());
        }
        return sb.toString();
    }

    @Override
    public void aboutToExecute() {
        this._calledAboutToExecute = true;
        for (SearchProcessor sp : this._pipe) {
            if (!sp.isImplemented()) break;
            sp.aboutToExecute();
        }
    }

    @Override
    public boolean execute(SearchResults results) {
        SearchProcessor sp;
        if (!this._calledAboutToExecute) {
            this.aboutToExecute();
        }
        SearchProcessor first = this.getFirstProcessor();
        results.clear();
        if (first == null || !first.isImplemented()) {
            return false;
        }
        boolean firstDone = first.execute(results);
        for (int i = 1; i < this._pipe.size() && (sp = this._pipe.get(i)).isImplemented(); ++i) {
            if (firstDone) {
                sp.lastExecute(results);
                continue;
            }
            sp.execute(results);
        }
        return firstDone;
    }

    @Override
    public void lastExecute(SearchResults results) {
        SearchProcessor sp;
        for (int i = 0; i < this._pipe.size() && (sp = this._pipe.get(i)).isImplemented(); ++i) {
            sp.lastExecute(results);
        }
    }

    public List<SearchProcessor> getPipeline() {
        return Collections.unmodifiableList(this._pipe);
    }

    public SearchProcessor getFirstProcessor() {
        return this._pipe.isEmpty() ? null : this._pipe.get(0);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (SearchProcessor sp : this._pipe) {
            if (!first) {
                sb.append(" | ");
            }
            sb.append(sp.toString());
            first = false;
        }
        return sb.toString();
    }
}

