/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import com.splunk.collect.IndexProcessor;
import com.splunk.datasource.parquet.JsonReadSupport;
import com.splunk.datasource.parquet.converter.Group;
import com.splunk.filter.schema.ParquetSchemaFilter;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.input.BaseSplunkRecordReader;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.util.TextUtil;
import com.splunk.util.WildcardList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;

public class ParquetRecordReader
extends BaseSplunkRecordReader {
    private static Logger gLogger = Logger.getLogger(ParquetRecordReader.class);
    private RecordReader<Void, Group> rr;
    private ObjectMapper mapper = new ObjectMapper();
    protected boolean simplifyResult = true;
    protected String dataFormat = "json";
    private boolean hunkEvent;
    private ByteArrayOutputStream _buf = new ByteArrayOutputStream(1024){

        @Override
        public synchronized byte[] toByteArray() {
            return this.buf;
        }
    };

    @Override
    public String getName() {
        return "parquet";
    }

    @Override
    public Pattern getFilePattern() {
        return SplunkMR.ACCEPT_ALL_PATTERN;
    }

    @Override
    public String getOutputDataFormat() {
        return this.dataFormat;
    }

    @Override
    public void vixInitialize(VixInputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        this.simplifyResult = Boolean.parseBoolean(split.getExtra("simplifyresult"));
        Configuration conf = context.getConfiguration();
        Path path = split.getPath();
        FileSystem fs = path.getFileSystem(conf);
        FileStatus fstat = fs.getFileStatus(path);
        if (IndexProcessor.isHunkEventFile(split.getPath())) {
            this.dataFormat = "json_events";
            this.hunkEvent = true;
        }
        ParquetMetadata parquetMetadata = ParquetFileReader.readFooter((Configuration)conf, (Path)path);
        FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
        MessageType fileSchema = fileMetaData.getSchema();
        String reqFields = split.getExtra(SplunkMR.CONF_REQUIRED_FIELDS);
        if (reqFields != null) {
            List rFields = (List)this.mapper.readValue(reqFields, List.class);
            this._requiredFields = new WildcardList(rFields);
        }
        MessageType requestedSchema = new ParquetSchemaFilter(this.simplifyResult).filter((Type)fileSchema, this._requiredFields, split.isDmaSplit());
        List blocks = parquetMetadata.getBlocks();
        List<BlockMetaData> blocksForCurrentSplit = null;
        long start = split.getStart();
        long length = split.getLength();
        long end = length + start;
        if (start == 0L && end == fstat.getLen()) {
            blocksForCurrentSplit = blocks;
        } else {
            blocksForCurrentSplit = new ArrayList();
            for (BlockMetaData block : blocks) {
                long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get(0)).getFirstDataPageOffset();
                if (firstDataPage < start || firstDataPage >= end) continue;
                blocksForCurrentSplit.add(block);
            }
        }
        ParquetInputSplit pis = new ParquetInputSplit(path, start, length, split.getLocations(), blocksForCurrentSplit, requestedSchema.toString(), fileSchema.toString(), fileMetaData.getKeyValueMetaData(), new HashMap());
        this.rr = new org.apache.parquet.hadoop.ParquetRecordReader((ReadSupport)new JsonReadSupport());
        this.rr.initialize((InputSplit)pis, context);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.rr.nextKeyValue();
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        this._buf.reset();
        this.serializeCurrentValueTo(this._buf);
        Text v = new Text();
        TextUtil.setTextInternals(v, this._buf.toByteArray(), this._buf.size());
        return v;
    }

    @Override
    public void serializeCurrentValueTo(OutputStream out) throws IOException, InterruptedException {
        Group po = (Group)this.rr.getCurrentValue();
        po.setHunkEvent(this.hunkEvent);
        JsonGenerator jg = this.mapper.getJsonFactory().createJsonGenerator(out, JsonEncoding.UTF8);
        po.serializeInto(jg, this.simplifyResult);
        jg.flush();
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly(this.rr);
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        if (this.rr != null) {
            return this.rr.getProgress();
        }
        return super.getProgress();
    }
}

