/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.journal;

import com.splunk.journal.EventData;
import com.splunk.journal.RawdataJournalReader;
import com.splunk.journal.SimpleCsvWriter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ExportTool
implements Closeable {
    static Logger logger = Logger.getLogger(ExportTool.class);
    private final RawdataJournalReader reader;
    private final SimpleCsvWriter writer;
    private final Pattern whiteSpace = Pattern.compile("\\s");

    public ExportTool(RawdataJournalReader reader, Writer wtr) throws IOException {
        this.reader = reader;
        this.writer = new SimpleCsvWriter(wtr);
        this.writer.setSeparatorChar(',');
        this.writer.writeRow("_time", "source", "host", "sourcetype", "_raw", "_meta");
    }

    public static ExportTool getExportTool(File journalPath, File outPath) throws IOException {
        logger.info((Object)("Using journal file: " + journalPath.getPath()));
        logger.info((Object)("File size: " + journalPath.length()));
        RawdataJournalReader reader = RawdataJournalReader.getReaderForFile(journalPath);
        BufferedWriter writer = new BufferedWriter(new FileWriter(outPath));
        return new ExportTool(reader, writer);
    }

    public void doExport() throws IOException {
        long startTime = System.currentTimeMillis();
        int eventCount = 0;
        for (EventData eventData : this.reader) {
            this.writeEvent(eventData);
            if (++eventCount % 10000 != 0) continue;
            logger.info((Object)("Number of events read: " + eventCount));
        }
        double elapsed = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        logger.info((Object)String.format("Export complete, running time of %.2f seconds", elapsed));
    }

    @Override
    public void close() throws IOException {
        if (null != this.writer) {
            this.writer.close();
        }
        if (null != this.reader) {
            this.reader.close();
        }
    }

    public void writeEvent(EventData eventData) {
        String eventAsString = new String(eventData.getRawContents(), RawdataJournalReader.UTF_8);
        String metadataAsString = this.formatMetaInfo(eventData);
        try {
            this.writer.writeRow(eventData.getFileOffset(), eventData.getEventTime(), eventData.getSource(), eventData.getHost(), eventData.getSourcetype(), eventAsString, metadataAsString);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String formatMetaInfo(EventData eventData) {
        Map<String, Object> fields = eventData.getFields();
        StringBuilder builder = new StringBuilder();
        builder.append("_indextime::").append(eventData.getIndexTime());
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            builder.append(" ");
            builder.append(this.quoteIfNeeded(entry.getKey()));
            builder.append("::");
            builder.append(this.quoteIfNeeded("" + entry.getValue()));
        }
        return builder.toString();
    }

    private String quoteIfNeeded(String str) {
        if (null == str) {
            return "\"\"";
        }
        if (this.whiteSpace.matcher(str).find()) {
            return "\"" + str + "\"";
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: ExportTool INPATH OUTPATH");
            System.out.println();
            System.out.println("INPATH:  Path to journal.gz file");
            System.out.println("OUTPATH: Path to file where the export should be written, in CSV form");
            System.exit(1);
        }
        String inPath = args[0];
        String outPath = args[1];
        ExportTool tool = null;
        try {
            tool = ExportTool.getExportTool(new File(inPath), new File(outPath));
            tool.doExport();
        }
        finally {
            if (null != tool) {
                tool.close();
            }
        }
    }
}

