require([
    'splunkjs/mvc/tableview',
    'splunkjs/mvc/chartview',
    'splunkjs/mvc/searchmanager',
    'splunkjs/mvc/postprocessmanager',
    'splunkjs/mvc',
    'underscore',
    'splunkjs/mvc/simplexml/ready!'],function(
    TableView,
    ChartView,
    SearchManager,
    PostProcessManager,
    mvc,
    _
    ){

    var EventSearchBasedRowExpansionRenderer = TableView.BaseRowExpansionRenderer.extend({
        initialize: function(args) {
            // initialize will run once, so we will set up a search and a chart to be reused.
            this._searchManager = new PostProcessManager({
                id: 'details-search-manager',
                managerid: 'journal_notes_base'
            });
            this._tableView = new TableView({
                id: 'drilldown_table_view',
                managerid: 'details-search-manager',
                'charting.legend.placement': 'none',
                'drilldown': 'none'
            });
        },

        canRender: function(rowData) {
            return true;
        },

        render: function($container, rowData) {
            var idCell = _(rowData.cells).find(function (cell) {
               return cell.field === 'id';
            });
            this._searchManager.set({ search: 'search id=' + idCell.value + ' | table id, link, search | transpose | table column, "row 1" | rename column AS "Additional Fields" "row 1" AS Value' });

            var p = $container.position();
            var pc = "top: " + p.top + "px; left: " + p.left+400 + "px; ";

            //debugger;
            $container.append(`<b>Actions:</b> <a href='#'>Edit</a> <a href='#'>Remove</a><br/><br/>
              <a class = "dropdown-toggle active" data-dialog-id="vjournal-menu"><span class="caret"  onclick="vdrop_me(7)"> </span></a><br/><br/>
              `);

            $container.append("<b>Description:</b><br/>");
            $container.append(this._tableView.render().el);
        }
    });

    var tableElement = mvc.Components.getInstance("journal_notes");
    tableElement.getVisualization(function(tableView) {
        tableView.addRowExpansionRenderer(new EventSearchBasedRowExpansionRenderer());
    });
});

function vdrop_me(i)
{
    //document.getElementById(i).style.visibility='visible';
    var pos = 0;
    var pc = "top: 100px; left: 100px;";
    //debugger;
    //$("#vjournal_menu_test").append('<div id="vjournal_menu_test"></div>')
    /*$(document.createElement("div")).id("vjournal_action")*/
    $('#vjournal_menu_test').html(`<div class="dropdown-menu dropdown-menu-selectable dropdown-menu-tall open" id="vjournal-menu" style="` + pc + `bottom: auto;">
        <div class="arrow" style="margin-left: -8px;"></div>
        <ul class="menu-list">

            <li>
                <a href="#">
                    <span class="menu-label">Edit</span>
                </a>
            </li>

            <li>
                <a href="#">
                    <span class="menu-label">Delete</span>
                </a>
            </li>
    </div>

    `);
}
