/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.s2s;

import com.splunk.s2s.ReadableV4;
import com.splunk.s2s.S2SUtil;
import com.splunk.s2s.StreamingS2S;
import com.splunk.s2s.WritableV4;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class TCPSignature
implements ReadableV4,
WritableV4 {
    String _signature;
    String _hostname;
    String _port;

    public TCPSignature() {
    }

    public TCPSignature(String sig, String host, String port) {
        this._signature = sig;
        this._hostname = host;
        this._port = port;
    }

    public String getSignature() {
        return this._signature;
    }

    public String getHostname() {
        return this._hostname;
    }

    public String getPort() {
        return this._port;
    }

    public String toString() {
        return "TCPSignature: {signature=\"" + this._signature + "\", host=\"" + this._hostname + "\", port=" + this._port + "}";
    }

    @Override
    public void readFromS2SV4(InputStream in, StreamingS2S parent) throws IOException {
        byte[] tmp = new byte[256];
        S2SUtil.readFully(in, tmp, 0, 128);
        this._signature = S2SUtil.getNullTerminatedString(tmp);
        if (!this._signature.startsWith("--splunk-") || !this._signature.endsWith("--")) {
            throw new IOException("Invalid signature=" + this._signature);
        }
        S2SUtil.readFully(in, tmp, 0, 256);
        this._hostname = S2SUtil.getNullTerminatedString(tmp);
        S2SUtil.readFully(in, tmp, 0, 16);
        this._port = S2SUtil.getNullTerminatedString(tmp);
        if (this._port.length() > 5) {
            throw new IOException("Invalid port=" + this._port);
        }
    }

    @Override
    public void writeToS2SV4(OutputStream out) throws IOException {
        byte[] tmp = new byte[256];
        byte[] bytes = this._signature.getBytes();
        System.arraycopy(bytes, 0, tmp, 0, bytes.length);
        out.write(tmp, 0, 128);
        bytes = this._hostname.getBytes();
        System.arraycopy(bytes, 0, tmp, 0, bytes.length);
        Arrays.fill(tmp, bytes.length, tmp.length, (byte)0);
        out.write(tmp, 0, 256);
        bytes = this._port.getBytes();
        System.arraycopy(bytes, 0, tmp, 0, bytes.length);
        Arrays.fill(tmp, bytes.length, tmp.length, (byte)0);
        out.write(tmp, 0, 16);
    }
}

