/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.packaging;

import com.splunk.mr.packaging.ManifestLine;
import com.splunk.mr.packaging.ManifestLineParser;
import com.splunk.mr.packaging.TgzCompressor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class LongFileModeSelector {
    private static final String LONG_TAR_LINE_1 = "f 444 splunk splunk splunk/share/splunk/search_mrsparkle/exposed/js/collections/services/admin/Alerts.js checksum";
    private static final String LONG_TAR_LINE_2 = "d 555 splunk splunk splunk/share/splunk/search_mrsparkle/exposed/js/collections/services/authentication checksum";
    private static final String LONG_TAR_LINE_3 = "f 444 splunk splunk splunk/share/splunk/search_mrsparkle/exposed/js/collections/services/authentication/CurrentContexts.js checksum";
    private static final Logger gLogger = Logger.getLogger(LongFileModeSelector.class);

    public static int selectTarLongFileMode(ManifestLineParser parser) {
        List<ManifestLine> lines = LongFileModeSelector.createLongManifestLines(parser);
        for (int longFileMode : LongFileModeSelector.getModes()) {
            if (!LongFileModeSelector.isLongFileModeSupported(lines, longFileMode)) continue;
            LongFileModeSelector.logLongFileModeChoice(longFileMode);
            return longFileMode;
        }
        gLogger.info((Object)"Could not tar with POSIX/PAX nor GNU extensions.");
        throw new RuntimeException("Operative system does not support neither POSIX/PAX nor GNU tar extensions. Please configure vix.splunk.setup.package to point to a splunk package.");
    }

    private static void logLongFileModeChoice(int longFileMode) {
        gLogger.info((Object)("Using tar long file mode: " + (longFileMode == 3 ? "POSIX/PAX" : "GNU")));
    }

    private static List<Integer> getModes() {
        return Arrays.asList(3, 2);
    }

    static List<ManifestLine> createLongManifestLines(ManifestLineParser parser) {
        return Arrays.asList(parser.parseLine(LONG_TAR_LINE_1), parser.parseLine(LONG_TAR_LINE_2), parser.parseLine(LONG_TAR_LINE_3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isLongFileModeSupported(List<ManifestLine> lines, int longFileMode) {
        TgzCompressor compressor = new TgzCompressor(longFileMode);
        try {
            compressor.init(new NoOpOutputStream());
            for (ManifestLine line : lines) {
                compressor.addManifestLine(line);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            compressor.close();
        }
    }

    private static class NoOpOutputStream
    extends OutputStream {
        private NoOpOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }
    }
}

