/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache.integration;

import com.splunk.mr.cache.integration.SplitMetadata;
import com.splunk.mr.input.VixInputSplit;
import org.apache.hadoop.conf.Configuration;

public class CacheKey {
    private final String index;
    private final String bucketId;
    private final String splitSearchId;
    private final String summaryId;
    private final SplitMetadata meta;

    public CacheKey(VixInputSplit split, String splitSearchId, String summaryId, Configuration conf) {
        this(split.getIndex(), split.getBucketId(), splitSearchId, summaryId, SplitMetadata.fromSplit(split, conf));
    }

    public CacheKey(String index, String bucketId, String splitSearchId, String summaryId, SplitMetadata meta) {
        this.index = index;
        this.bucketId = bucketId;
        this.splitSearchId = splitSearchId;
        this.summaryId = summaryId;
        this.meta = meta;
    }

    public String getSplitSearchId() {
        return this.splitSearchId;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getIndex() {
        return this.index;
    }

    public String getSummaryId() {
        return this.summaryId;
    }

    public SplitMetadata getSplitMetadata() {
        return this.meta;
    }

    public String toString() {
        return "CacheKey [index=" + this.index + ", bucketId=" + this.bucketId + ", splitSearchId=" + this.splitSearchId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bucketId == null ? 0 : this.bucketId.hashCode());
        result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
        result = 31 * result + (this.splitSearchId == null ? 0 : this.splitSearchId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheKey other = (CacheKey)obj;
        if (this.bucketId == null ? other.bucketId != null : !this.bucketId.equals(other.bucketId)) {
            return false;
        }
        if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
            return false;
        }
        return !(this.splitSearchId == null ? other.splitSearchId != null : !this.splitSearchId.equals(other.splitSearchId));
    }
}

