/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache;

import com.splunk.mr.cache.CompactionMetadata;
import com.splunk.mr.cache.MapCache;
import com.splunk.mr.cache.reporting.Report;
import com.splunk.util.HdfsUtil;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class CacheReport {
    public static final String SERVER_KEY = "resides-in-hadoop";
    public static final String INDEX = "index";
    public static final String SPLUNK_SERVER = "splunk_server";
    public static final String BUCKET_PATH = "bucket_path";
    public static final String BUCKET_ID = "bucket_id";
    public static final String BUCKET_SIZE = "bucket_size";
    public static final String BUCKET_LT = "bucket_lt";
    public static final String BUCKET_ET = "bucket_et";
    public static final String SUMMARY_MODTIME = "summary_modtime";
    public static final String SUMMARY_PATH = "summary_path";
    public static final String SUMMARY_CHUNKS = "summary_chunks";
    public static final String SUMMARY_RATIO = "summary_ratio";
    public static final String SUMMARY_SIZE = "summary_size";
    public static final String SUMMARY_COMPLETE = "summary_complete";

    public static void fillReport(MapCache mapCache, Report report) throws IOException {
        FileSystem fs = mapCache.getFileSystem();
        Path cachePath = mapCache.getCachePath();
        Path compactsDir = MapCache.getCompactsDir(cachePath);
        Path stablesDir = MapCache.getStablesDir(cachePath);
        CacheReport.reportCompactions(report, fs, compactsDir);
        CacheReport.reportCompactions(report, fs, stablesDir);
        report.set(SUMMARY_PATH, cachePath.toUri().getPath());
        report.increment(SUMMARY_SIZE, fs.getContentSummary(cachePath).getLength());
        report.setRatio(SUMMARY_RATIO, SUMMARY_SIZE, BUCKET_SIZE);
        report.allTrue(SUMMARY_COMPLETE, true);
    }

    private static void reportCompactions(Report report, FileSystem fs, Path compactionsDir) throws IOException {
        for (FileStatus compaction : HdfsUtil.ls(fs, compactionsDir)) {
            CompactionMetadata metadata = CompactionMetadata.getMetadata(fs, compaction.getPath());
            report.lateTime(BUCKET_LT, CacheReport.toSec(metadata.getLatestTime()));
            report.earlyTime(BUCKET_ET, CacheReport.toSec(metadata.getEarliestTime()));
            report.increment(BUCKET_SIZE, metadata.getTotalSplitSize());
            report.increment(SUMMARY_CHUNKS, metadata.getSplitCount());
            report.lateTime(SUMMARY_MODTIME, CacheReport.toSec(compaction.getModificationTime()));
        }
    }

    private static long toSec(Date d) {
        return CacheReport.toSec(d.getTime());
    }

    private static long toSec(long time) {
        return TimeUnit.SECONDS.convert(time, TimeUnit.MILLISECONDS);
    }
}

