/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.jobs;

import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.AccumulableInfo;
import org.apache.spark.status.api.v1.ApplicationAttemptInfo;
import org.apache.spark.status.api.v1.ExecutorStageSummary;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.status.api.v1.StageStatus;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.ui.ToolTips$;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.ui.jobs.JobPage$;
import org.apache.spark.ui.jobs.JobsTab;
import org.apache.spark.ui.jobs.StageTableBase;
import org.apache.spark.ui.scope.RDDOperationGraph;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;
import scala.xml.Utility$;

@ScalaSignature(bytes="\u0006\u0001u4Q!\u0001\u0002\u0001\t1\u0011qAS8c!\u0006<WM\u0003\u0002\u0004\t\u0005!!n\u001c2t\u0015\t)a!\u0001\u0002vS*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0005\u0002\u0001\u001bA\u0011abD\u0007\u0002\t%\u0011\u0001\u0003\u0002\u0002\n/\u0016\u0014W+\u0013)bO\u0016D\u0001B\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0007a\u0006\u0014XM\u001c;\u0004\u0001A\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\b\u0015>\u00147\u000fV1c\u0011!I\u0002A!A!\u0002\u0013Q\u0012!B:u_J,\u0007CA\u000e\u001f\u001b\u0005a\"BA\u000f\u0007\u0003\u0019\u0019H/\u0019;vg&\u0011q\u0004\b\u0002\u000f\u0003B\u00048\u000b^1ukN\u001cFo\u001c:f\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\u00191\u0005J\u0013\u0011\u0005U\u0001\u0001\"\u0002\n!\u0001\u0004!\u0002\"B\r!\u0001\u0004Q\u0002bB\u0014\u0001\u0005\u0004%I\u0001K\u0001\u000e'R\u000bu)R*`\u0019\u0016;UI\u0014#\u0016\u0003%\u0002\"A\u000b\u0019\u000f\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0002\rA\u0013X\rZ3g\u0013\t\t$G\u0001\u0004TiJLgn\u001a\u0006\u0003_1Ba\u0001\u000e\u0001!\u0002\u0013I\u0013AD*U\u0003\u001e+5k\u0018'F\u000f\u0016sE\t\t\u0005\bm\u0001\u0011\r\u0011\"\u0003)\u0003A)\u0005,R\"V)>\u00136k\u0018'F\u000f\u0016sE\t\u0003\u00049\u0001\u0001\u0006I!K\u0001\u0012\u000bb+5)\u0016+P%N{F*R$F\u001d\u0012\u0003\u0003\"\u0002\u001e\u0001\t\u0013Y\u0014AD7bW\u0016\u001cF/Y4f\u000bZ,g\u000e\u001e\u000b\u0003y!\u00032!P#*\u001d\tq4I\u0004\u0002@\u00056\t\u0001I\u0003\u0002B'\u00051AH]8pizJ\u0011!L\u0005\u0003\t2\nq\u0001]1dW\u0006<W-\u0003\u0002G\u000f\n\u00191+Z9\u000b\u0005\u0011c\u0003\"B%:\u0001\u0004Q\u0015AC:uC\u001e,\u0017J\u001c4pgB\u0019Q(R&\u0011\u00051\u000bV\"A'\u000b\u00059{\u0015A\u0001<2\u0015\t\u0001F$A\u0002ba&L!AU'\u0003\u0013M#\u0018mZ3ECR\f\u0007\"\u0002+\u0001\t\u0003)\u0016!E7bW\u0016,\u00050Z2vi>\u0014XI^3oiR\u0011AH\u0016\u0005\u0006/N\u0003\r\u0001W\u0001\nKb,7-\u001e;peN\u00042!P#Z!\ta%,\u0003\u0002\\\u001b\nyQ\t_3dkR|'oU;n[\u0006\u0014\u0018\u0010C\u0003^\u0001\u0011%a,\u0001\u0007nC.,G+[7fY&tW\r\u0006\u0003`M\"L\u0007cA\u001fFAB\u0011\u0011\rZ\u0007\u0002E*\u00111\rL\u0001\u0004q6d\u0017BA3c\u0005\u0011qu\u000eZ3\t\u000b\u001dd\u0006\u0019\u0001&\u0002\rM$\u0018mZ3t\u0011\u00159F\f1\u0001Y\u0011\u0015QG\f1\u0001l\u00031\t\u0007\u000f]*uCJ$H+[7f!\tYC.\u0003\u0002nY\t!Aj\u001c8h\u0011\u0015y\u0007\u0001\"\u0001q\u0003\u0019\u0011XM\u001c3feR\u0011q,\u001d\u0005\u0006e:\u0004\ra]\u0001\be\u0016\fX/Z:u!\t!80D\u0001v\u0015\t1x/\u0001\u0003iiR\u0004(B\u0001=z\u0003\u001d\u0019XM\u001d<mKRT\u0011A_\u0001\u0006U\u00064\u0018\r_\u0005\u0003yV\u0014!\u0003\u0013;uaN+'O\u001e7fiJ+\u0017/^3ti\u0002")
public class JobPage
extends WebUIPage {
    public final JobsTab org$apache$spark$ui$jobs$JobPage$$parent;
    public final AppStatusStore org$apache$spark$ui$jobs$JobPage$$store;
    private final String STAGES_LEGEND;
    private final String EXECUTORS_LEGEND;

    private String STAGES_LEGEND() {
        return this.STAGES_LEGEND;
    }

    private String EXECUTORS_LEGEND() {
        return this.EXECUTORS_LEGEND;
    }

    private Seq<String> makeStageEvent(Seq<StageData> stageInfos) {
        return (Seq)stageInfos.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(StageData stage) {
                int stageId = stage.stageId();
                int attemptId = stage.attemptId();
                String name2 = stage.name();
                String status = stage.status().toString();
                long submissionTime = ((Date)stage.submissionTime().get()).getTime();
                long completionTime2 = BoxesRunTime.unboxToLong((Object)stage.completionTime().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Date x$3) {
                        return x$3.getTime();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return System.currentTimeMillis();
                    }
                }));
                String escapedName = Utility$.MODULE$.escape(name2);
                String jsEscapedName = StringEscapeUtils.escapeEcmaScript((String)escapedName);
                Object[] objectArray = new Object[12];
                objectArray[0] = status;
                objectArray[1] = BoxesRunTime.boxToLong((long)submissionTime);
                objectArray[2] = BoxesRunTime.boxToLong((long)completionTime2);
                objectArray[3] = jsEscapedName;
                objectArray[4] = BoxesRunTime.boxToInteger((int)stageId);
                objectArray[5] = BoxesRunTime.boxToInteger((int)attemptId);
                objectArray[6] = status.toUpperCase(Locale.ROOT);
                objectArray[7] = UIUtils$.MODULE$.formatDate(submissionTime);
                String string = status;
                String string2 = "running";
                objectArray[8] = !(string != null ? !string.equals(string2) : string2 != null) ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<br>Completed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UIUtils$.MODULE$.formatDate(completionTime2)}));
                objectArray[9] = jsEscapedName;
                objectArray[10] = BoxesRunTime.boxToInteger((int)stageId);
                objectArray[11] = BoxesRunTime.boxToInteger((int)attemptId);
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |{\n         |  'className': 'stage job-timeline-object ", "',\n         |  'group': 'stages',\n         |  'start': new Date(", "),\n         |  'end': new Date(", "),\n         |  'content': '<div class=\"job-timeline-content\" data-toggle=\"tooltip\"' +\n         |   'data-placement=\"top\" data-html=\"true\"' +\n         |   'data-title=\"", " (Stage ", ".", ")<br>' +\n         |   'Status: ", "<br>' +\n         |   'Submitted: ", "' +\n         |   '", "\">' +\n         |    '", " (Stage ", ".", ")</div>',\n         |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)))).stripMargin();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> makeExecutorEvent(Seq<ExecutorSummary> executors) {
        ListBuffer events = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        executors.foreach((Function1)new Serializable(this, events){
            public static final long serialVersionUID = 0L;
            public final ListBuffer events$1;

            public final void apply(ExecutorSummary e) {
                String addedEvent = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |{\n           |  'className': 'executor added',\n           |  'group': 'executors',\n           |  'start': new Date(", "),\n           |  'content': '<div class=\"executor-event-content\"' +\n           |    'data-toggle=\"tooltip\" data-placement=\"bottom\"' +\n           |    'data-title=\"Executor ", "<br>' +\n           |    'Added at ", "\"' +\n           |    'data-html=\"true\">Executor ", " added</div>'\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)e.addTime().getTime()), e.id(), UIUtils$.MODULE$.formatDate(e.addTime()), e.id()})))).stripMargin();
                this.events$1.$plus$eq((Object)addedEvent);
                e.removeTime().foreach((Function1)new Serializable(this, e){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$makeExecutorEvent$1 $outer;
                    private final ExecutorSummary e$1;

                    public final ListBuffer<String> apply(Date removeTime) {
                        String removedEvent = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |{\n             |  'className': 'executor removed',\n             |  'group': 'executors',\n             |  'start': new Date(", "),\n             |  'content': '<div class=\"executor-event-content\"' +\n             |    'data-toggle=\"tooltip\" data-placement=\"bottom\"' +\n             |    'data-title=\"Executor ", "<br>' +\n             |    'Removed at ", "' +\n             |    '", "\"' +\n             |    'data-html=\"true\">Executor ", " removed</div>'\n             |}\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)removeTime.getTime()), this.e$1.id(), UIUtils$.MODULE$.formatDate(removeTime), this.e$1.removeReason().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String reason) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<br>Reason: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reason.replace("\n", " ")}));
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        }), this.e$1.id()})))).stripMargin();
                        return this.$outer.events$1.$plus$eq((Object)removedEvent);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.e$1 = e$1;
                    }
                });
            }
            {
                this.events$1 = events$1;
            }
        });
        return events.toSeq();
    }

    private Seq<Node> makeTimeline(Seq<StageData> stages, Seq<ExecutorSummary> executors, long appStartTime) {
        Seq<String> stageEventJsonAsStrSeq = this.makeStageEvent(stages);
        Seq<String> executorsJsonAsStrSeq = this.makeExecutorEvent(executors);
        String groupJsonArrayAsStr = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |[\n          |  {\n          |    'id': 'executors',\n          |    'content': '<div>Executors</div>", "',\n          |  },\n          |  {\n          |    'id': 'stages',\n          |    'content': '<div>Stages</div>", "',\n          |  }\n          |]\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.EXECUTORS_LEGEND(), this.STAGES_LEGEND()})))).stripMargin();
        String eventArrayAsStr = ((TraversableOnce)stageEventJsonAsStrSeq.$plus$plus(executorsJsonAsStrSeq, Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("expand-job-timeline"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("expand-job-timeline-arrow arrow-closed"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("data-placement", (Seq)new Text("right"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("title", ToolTips$.MODULE$.STAGE_TIMELINE(), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md3);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        Event Timeline\n      "));
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n    "));
        Elem elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("collapsed"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("id", (Seq)new Text("job-timeline"), (MetaData)$md4);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("control-panel"), (MetaData)$md5);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("id", (Seq)new Text("job-timeline-zoom-lock"), (MetaData)$md6);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md7);
        $buf5.$amp$plus((Object)new Elem(null, "input", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("Enable zooming"));
        $buf5.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n    "));
        TraversableLike traversableLike = (TraversableLike)elem.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3), NodeSeq$.MODULE$.canBuildFrom());
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md8);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n      "));
        $buf7.$amp$plus((Object)Unparsed$.MODULE$.apply(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drawJobTimeline(", ", ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{groupJsonArrayAsStr, eventArrayAsStr}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)appStartTime), BoxesRunTime.boxToInteger((int)UIUtils$.MODULE$.getTimeZoneOffset())}))).toString()));
        $buf7.$amp$plus((Object)new Text("\n    "));
        return (Seq)traversableLike.$plus$plus((GenTraversableOnce)new Elem(null, "script", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7), NodeSeq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<Node> render(HttpServletRequest request) {
        NonLocalReturnControl nonLocalReturnControl2;
        block23: {
            Seq<Node> seq;
            Object object = new Object();
            try {
                Elem elem;
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                BoxedUnit boxedUnit3;
                BoxedUnit boxedUnit4;
                BoxedUnit boxedUnit5;
                BoxedUnit boxedUnit6;
                String parameterId = UIUtils$.MODULE$.stripXSS(request.getParameter("id"));
                Predef$.MODULE$.require(parameterId != null && new StringOps(Predef$.MODULE$.augmentString(parameterId)).nonEmpty(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Missing id parameter";
                    }
                });
                int jobId = new StringOps(Predef$.MODULE$.augmentString(parameterId)).toInt();
                JobData jobData = (JobData)this.org$apache$spark$ui$jobs$JobPage$$store.asOption(new Serializable(this, jobId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ JobPage $outer;
                    private final int jobId$1;

                    public final JobData apply() {
                        return this.$outer.org$apache$spark$ui$jobs$JobPage$$store.job(this.jobId$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.jobId$1 = jobId$1;
                    }
                }).getOrElse((Function0)new Serializable(this, jobId, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ JobPage $outer;
                    private final int jobId$1;
                    private final Object nonLocalReturnKey1$1;

                    /*
                     * WARNING - void declaration
                     */
                    public final Nothing$ apply() {
                        void var3_2;
                        Null$ $md = Null$.MODULE$;
                        $md = new UnprefixedAttribute("id", (Seq)new Text("no-info"), (MetaData)$md);
                        NodeBuffer $buf = new NodeBuffer();
                        $buf.$amp$plus((Object)new Text("\n          "));
                        NodeBuffer $buf2 = new NodeBuffer();
                        $buf2.$amp$plus((Object)new Text("No information to display for job "));
                        $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)this.jobId$1));
                        $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                        $buf.$amp$plus((Object)new Text("\n        "));
                        Elem content = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_2);
                        throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, UIUtils$.MODULE$.headerSparkPage(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Details for Job ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.jobId$1)})), (Function0<Seq<Node>>)new Serializable(this, content){
                            public static final long serialVersionUID = 0L;
                            private final Elem content$2;

                            public final Elem apply() {
                                return this.content$2;
                            }
                            {
                                this.content$2 = content$2;
                            }
                        }, this.$outer.org$apache$spark$ui$jobs$JobPage$$parent, UIUtils$.MODULE$.headerSparkPage$default$4(), UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.jobId$1 = jobId$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                JobExecutionStatus jobExecutionStatus = jobData.status();
                JobExecutionStatus jobExecutionStatus2 = JobExecutionStatus.RUNNING;
                boolean isComplete = jobExecutionStatus != null ? !((Object)((Object)jobExecutionStatus)).equals((Object)jobExecutionStatus2) : jobExecutionStatus2 != null;
                Seq stages = (Seq)jobData.stageIds().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ JobPage $outer;

                    public final StageData apply(int stageId) {
                        return (StageData)this.$outer.org$apache$spark$ui$jobs$JobPage$$store.asOption(new Serializable(this, stageId){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$9 $outer;
                            private final int stageId$1;

                            public final StageData apply() {
                                return this.$outer.org$apache$spark$ui$jobs$JobPage$$anonfun$$$outer().org$apache$spark$ui$jobs$JobPage$$store.lastStageAttempt(this.stageId$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.stageId$1 = stageId$1;
                            }
                        }).getOrElse((Function0)new Serializable(this, stageId){
                            public static final long serialVersionUID = 0L;
                            private final int stageId$1;

                            public final StageData apply() {
                                return new StageData(StageStatus.PENDING, this.stageId$1, 0, 0, 0, 0, 0, 0, 0, 0L, 0L, (Option<Date>)None$.MODULE$, (Option<Date>)None$.MODULE$, (Option<Date>)None$.MODULE$, (Option<String>)None$.MODULE$, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, "Unknown", (Option<String>)None$.MODULE$, "Unknown", null, (Seq<Object>)Nil$.MODULE$, (Seq<AccumulableInfo>)Nil$.MODULE$, (Option<Map<Object, TaskData>>)None$.MODULE$, (Option<Map<String, ExecutorStageSummary>>)None$.MODULE$, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                            }
                            {
                                this.stageId$1 = stageId$1;
                            }
                        });
                    }

                    public /* synthetic */ JobPage org$apache$spark$ui$jobs$JobPage$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Buffer activeStages2 = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                Buffer completedStages = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                Buffer pendingOrSkippedStages = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                Buffer failedStages = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                stages.foreach((Function1)new Serializable(this, activeStages2, completedStages, pendingOrSkippedStages, failedStages){
                    public static final long serialVersionUID = 0L;
                    private final Buffer activeStages$1;
                    private final Buffer completedStages$1;
                    private final Buffer pendingOrSkippedStages$1;
                    private final Buffer failedStages$1;

                    public final Buffer<StageData> apply(StageData stage) {
                        Buffer buffer;
                        if (stage.submissionTime().isEmpty()) {
                            buffer = this.pendingOrSkippedStages$1.$plus$eq((Object)stage);
                        } else if (stage.completionTime().isDefined()) {
                            StageStatus stageStatus = stage.status();
                            StageStatus stageStatus2 = StageStatus.FAILED;
                            buffer = !(stageStatus != null ? !((Object)((Object)stageStatus)).equals((Object)((Object)stageStatus2)) : stageStatus2 != null) ? this.failedStages$1.$plus$eq((Object)stage) : this.completedStages$1.$plus$eq((Object)stage);
                        } else {
                            buffer = this.activeStages$1.$plus$eq((Object)stage);
                        }
                        return buffer;
                    }
                    {
                        this.activeStages$1 = activeStages$1;
                        this.completedStages$1 = completedStages$1;
                        this.pendingOrSkippedStages$1 = pendingOrSkippedStages$1;
                        this.failedStages$1 = failedStages$1;
                    }
                });
                String basePath = "jobs/job";
                String pendingOrSkippedTableId = isComplete ? "pending" : "skipped";
                StageTableBase activeStagesTable = new StageTableBase(this.org$apache$spark$ui$jobs$JobPage$$store, request, (Seq<StageData>)activeStages2, "active", "activeStage", this.org$apache$spark$ui$jobs$JobPage$$parent.basePath(), basePath, this.org$apache$spark$ui$jobs$JobPage$$parent.isFairScheduler(), this.org$apache$spark$ui$jobs$JobPage$$parent.killEnabled(), false);
                StageTableBase pendingOrSkippedStagesTable = new StageTableBase(this.org$apache$spark$ui$jobs$JobPage$$store, request, (Seq<StageData>)pendingOrSkippedStages, pendingOrSkippedTableId, "pendingStage", this.org$apache$spark$ui$jobs$JobPage$$parent.basePath(), basePath, this.org$apache$spark$ui$jobs$JobPage$$parent.isFairScheduler(), false, false);
                StageTableBase completedStagesTable = new StageTableBase(this.org$apache$spark$ui$jobs$JobPage$$store, request, (Seq<StageData>)completedStages, "completed", "completedStage", this.org$apache$spark$ui$jobs$JobPage$$parent.basePath(), basePath, this.org$apache$spark$ui$jobs$JobPage$$parent.isFairScheduler(), false, false);
                StageTableBase failedStagesTable = new StageTableBase(this.org$apache$spark$ui$jobs$JobPage$$store, request, (Seq<StageData>)failedStages, "failed", "failedStage", this.org$apache$spark$ui$jobs$JobPage$$parent.basePath(), basePath, this.org$apache$spark$ui$jobs$JobPage$$parent.isFairScheduler(), false, true);
                boolean shouldShowActiveStages = activeStages2.nonEmpty();
                boolean shouldShowPendingStages = !isComplete && pendingOrSkippedStages.nonEmpty();
                boolean shouldShowCompletedStages = completedStages.nonEmpty();
                boolean shouldShowSkippedStages = isComplete && pendingOrSkippedStages.nonEmpty();
                boolean shouldShowFailedStages = failedStages.nonEmpty();
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n        "));
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("unstyled"), (MetaData)$md);
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new Text("\n            "));
                NodeBuffer $buf4 = new NodeBuffer();
                $buf4.$amp$plus((Object)new Text("Status:"));
                $buf3.$amp$plus((Object)new Elem(null, "Strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
                $buf3.$amp$plus((Object)new Text("\n            "));
                $buf3.$amp$plus((Object)jobData.status());
                $buf3.$amp$plus((Object)new Text("\n          "));
                $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                $buf2.$amp$plus((Object)new Text("\n          "));
                if (jobData.jobGroup().isDefined()) {
                    NodeBuffer $buf5 = new NodeBuffer();
                    $buf5.$amp$plus((Object)new Text("\n                "));
                    NodeBuffer $buf6 = new NodeBuffer();
                    $buf6.$amp$plus((Object)new Text("Job Group:"));
                    $buf5.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
                    $buf5.$amp$plus((Object)new Text("\n                "));
                    $buf5.$amp$plus(jobData.jobGroup().get());
                    $buf5.$amp$plus((Object)new Text("\n              "));
                    Elem elem2 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5);
                    boxedUnit6 = elem2;
                } else {
                    boxedUnit6 = BoxedUnit.UNIT;
                }
                $buf2.$amp$plus((Object)boxedUnit6);
                $buf2.$amp$plus((Object)new Text("\n          "));
                if (shouldShowActiveStages) {
                    NodeBuffer $buf7 = new NodeBuffer();
                    $buf7.$amp$plus((Object)new Text("\n                "));
                    Null$ $md2 = Null$.MODULE$;
                    $md2 = new UnprefixedAttribute("href", (Seq)new Text("#active"), (MetaData)$md2);
                    NodeBuffer $buf8 = new NodeBuffer();
                    NodeBuffer $buf9 = new NodeBuffer();
                    $buf9.$amp$plus((Object)new Text("Active Stages:"));
                    $buf8.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
                    $buf7.$amp$plus((Object)new Elem(null, "a", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
                    $buf7.$amp$plus((Object)new Text("\n                "));
                    $buf7.$amp$plus((Object)BoxesRunTime.boxToInteger((int)activeStages2.size()));
                    $buf7.$amp$plus((Object)new Text("\n              "));
                    Elem elem3 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7);
                    boxedUnit5 = elem3;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                $buf2.$amp$plus((Object)boxedUnit5);
                $buf2.$amp$plus((Object)new Text("\n          "));
                if (shouldShowPendingStages) {
                    NodeBuffer $buf10 = new NodeBuffer();
                    $buf10.$amp$plus((Object)new Text("\n                "));
                    Null$ $md3 = Null$.MODULE$;
                    $md3 = new UnprefixedAttribute("href", (Seq)new Text("#pending"), (MetaData)$md3);
                    NodeBuffer $buf11 = new NodeBuffer();
                    $buf11.$amp$plus((Object)new Text("\n                  "));
                    NodeBuffer $buf12 = new NodeBuffer();
                    $buf12.$amp$plus((Object)new Text("Pending Stages:"));
                    $buf11.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
                    $buf11.$amp$plus((Object)new Text("\n                "));
                    $buf10.$amp$plus((Object)new Elem(null, "a", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
                    $buf10.$amp$plus((Object)BoxesRunTime.boxToInteger((int)pendingOrSkippedStages.size()));
                    $buf10.$amp$plus((Object)new Text("\n              "));
                    Elem elem4 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10);
                    boxedUnit4 = elem4;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                $buf2.$amp$plus((Object)boxedUnit4);
                $buf2.$amp$plus((Object)new Text("\n          "));
                if (shouldShowCompletedStages) {
                    NodeBuffer $buf13 = new NodeBuffer();
                    $buf13.$amp$plus((Object)new Text("\n                "));
                    Null$ $md4 = Null$.MODULE$;
                    $md4 = new UnprefixedAttribute("href", (Seq)new Text("#completed"), (MetaData)$md4);
                    NodeBuffer $buf14 = new NodeBuffer();
                    NodeBuffer $buf15 = new NodeBuffer();
                    $buf15.$amp$plus((Object)new Text("Completed Stages:"));
                    $buf14.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf15));
                    $buf13.$amp$plus((Object)new Elem(null, "a", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14));
                    $buf13.$amp$plus((Object)new Text("\n                "));
                    $buf13.$amp$plus((Object)BoxesRunTime.boxToInteger((int)completedStages.size()));
                    $buf13.$amp$plus((Object)new Text("\n              "));
                    Elem elem5 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13);
                    boxedUnit3 = elem5;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                $buf2.$amp$plus((Object)boxedUnit3);
                $buf2.$amp$plus((Object)new Text("\n          "));
                if (shouldShowSkippedStages) {
                    NodeBuffer $buf16 = new NodeBuffer();
                    $buf16.$amp$plus((Object)new Text("\n              "));
                    Null$ $md5 = Null$.MODULE$;
                    $md5 = new UnprefixedAttribute("href", (Seq)new Text("#skipped"), (MetaData)$md5);
                    NodeBuffer $buf17 = new NodeBuffer();
                    NodeBuffer $buf18 = new NodeBuffer();
                    $buf18.$amp$plus((Object)new Text("Skipped Stages:"));
                    $buf17.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf18));
                    $buf16.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf17));
                    $buf16.$amp$plus((Object)new Text("\n              "));
                    $buf16.$amp$plus((Object)BoxesRunTime.boxToInteger((int)pendingOrSkippedStages.size()));
                    $buf16.$amp$plus((Object)new Text("\n            "));
                    Elem elem6 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf16);
                    boxedUnit2 = elem6;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                $buf2.$amp$plus((Object)boxedUnit2);
                $buf2.$amp$plus((Object)new Text("\n          "));
                if (shouldShowFailedStages) {
                    NodeBuffer $buf19 = new NodeBuffer();
                    $buf19.$amp$plus((Object)new Text("\n                "));
                    Null$ $md6 = Null$.MODULE$;
                    $md6 = new UnprefixedAttribute("href", (Seq)new Text("#failed"), (MetaData)$md6);
                    NodeBuffer $buf20 = new NodeBuffer();
                    NodeBuffer $buf21 = new NodeBuffer();
                    $buf21.$amp$plus((Object)new Text("Failed Stages:"));
                    $buf20.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf21));
                    $buf19.$amp$plus((Object)new Elem(null, "a", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf20));
                    $buf19.$amp$plus((Object)new Text("\n                "));
                    $buf19.$amp$plus((Object)BoxesRunTime.boxToInteger((int)failedStages.size()));
                    $buf19.$amp$plus((Object)new Text("\n              "));
                    Elem elem7 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf19);
                    boxedUnit = elem7;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                $buf2.$amp$plus((Object)boxedUnit);
                $buf2.$amp$plus((Object)new Text("\n        "));
                $buf.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text("\n      "));
                Elem summary = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                ObjectRef content = ObjectRef.create((Object)summary);
                long appStartTime = ((ApplicationAttemptInfo)this.org$apache$spark$ui$jobs$JobPage$$store.applicationInfo().attempts().head()).startTime().getTime();
                content.elem = (NodeSeq)((NodeSeq)content.elem).$plus$plus(this.makeTimeline((Seq<StageData>)activeStages2.$plus$plus((GenTraversableOnce)completedStages).$plus$plus((GenTraversableOnce)failedStages), this.org$apache$spark$ui$jobs$JobPage$$store.executorList(false), appStartTime), NodeSeq$.MODULE$.canBuildFrom());
                Option option = this.org$apache$spark$ui$jobs$JobPage$$store.asOption(new Serializable(this, jobId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ JobPage $outer;
                    private final int jobId$1;

                    public final Seq<RDDOperationGraph> apply() {
                        return this.$outer.org$apache$spark$ui$jobs$JobPage$$store.operationGraphForJob(this.jobId$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.jobId$1 = jobId$1;
                    }
                });
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Seq operationGraph = (Seq)some.x();
                    elem = UIUtils$.MODULE$.showDagVizForJob(jobId, (Seq<RDDOperationGraph>)operationGraph);
                } else {
                    if (!None$.MODULE$.equals(option)) {
                        throw new MatchError(option);
                    }
                    Null$ $md7 = Null$.MODULE$;
                    $md7 = new UnprefixedAttribute("id", (Seq)new Text("no-info"), (MetaData)$md7);
                    NodeBuffer $buf22 = new NodeBuffer();
                    $buf22.$amp$plus((Object)new Text("\n          "));
                    NodeBuffer $buf23 = new NodeBuffer();
                    $buf23.$amp$plus((Object)new Text("No DAG visualization information to display for job "));
                    $buf23.$amp$plus((Object)BoxesRunTime.boxToInteger((int)jobId));
                    $buf22.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf23));
                    $buf22.$amp$plus((Object)new Text("\n        "));
                    elem = new Elem(null, "div", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf22);
                }
                Elem operationGraphContent = elem;
                content.elem = (NodeSeq)((NodeSeq)content.elem).$plus$plus(operationGraphContent, NodeSeq$.MODULE$.canBuildFrom());
                if (shouldShowActiveStages) {
                    NodeSeq nodeSeq = (NodeSeq)content.elem;
                    Null$ $md8 = Null$.MODULE$;
                    $md8 = new UnprefixedAttribute("id", (Seq)new Text("active"), (MetaData)$md8);
                    NodeBuffer $buf24 = new NodeBuffer();
                    $buf24.$amp$plus((Object)new Text("Active Stages ("));
                    $buf24.$amp$plus((Object)BoxesRunTime.boxToInteger((int)activeStages2.size()));
                    $buf24.$amp$plus((Object)new Text(")"));
                    content.elem = (NodeSeq)nodeSeq.$plus$plus((GenTraversableOnce)new Elem(null, "h4", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf24).$plus$plus(activeStagesTable.toNodeSeq(), NodeSeq$.MODULE$.canBuildFrom()), NodeSeq$.MODULE$.canBuildFrom());
                }
                if (shouldShowPendingStages) {
                    NodeSeq nodeSeq = (NodeSeq)content.elem;
                    Null$ $md9 = Null$.MODULE$;
                    $md9 = new UnprefixedAttribute("id", (Seq)new Text("pending"), (MetaData)$md9);
                    NodeBuffer $buf25 = new NodeBuffer();
                    $buf25.$amp$plus((Object)new Text("Pending Stages ("));
                    $buf25.$amp$plus((Object)BoxesRunTime.boxToInteger((int)pendingOrSkippedStages.size()));
                    $buf25.$amp$plus((Object)new Text(")"));
                    content.elem = (NodeSeq)nodeSeq.$plus$plus((GenTraversableOnce)new Elem(null, "h4", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf25).$plus$plus(pendingOrSkippedStagesTable.toNodeSeq(), NodeSeq$.MODULE$.canBuildFrom()), NodeSeq$.MODULE$.canBuildFrom());
                }
                if (shouldShowCompletedStages) {
                    NodeSeq nodeSeq = (NodeSeq)content.elem;
                    Null$ $md10 = Null$.MODULE$;
                    $md10 = new UnprefixedAttribute("id", (Seq)new Text("completed"), (MetaData)$md10);
                    NodeBuffer $buf26 = new NodeBuffer();
                    $buf26.$amp$plus((Object)new Text("Completed Stages ("));
                    $buf26.$amp$plus((Object)BoxesRunTime.boxToInteger((int)completedStages.size()));
                    $buf26.$amp$plus((Object)new Text(")"));
                    content.elem = (NodeSeq)nodeSeq.$plus$plus((GenTraversableOnce)new Elem(null, "h4", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf26).$plus$plus(completedStagesTable.toNodeSeq(), NodeSeq$.MODULE$.canBuildFrom()), NodeSeq$.MODULE$.canBuildFrom());
                }
                if (shouldShowSkippedStages) {
                    NodeSeq nodeSeq = (NodeSeq)content.elem;
                    Null$ $md11 = Null$.MODULE$;
                    $md11 = new UnprefixedAttribute("id", (Seq)new Text("skipped"), (MetaData)$md11);
                    NodeBuffer $buf27 = new NodeBuffer();
                    $buf27.$amp$plus((Object)new Text("Skipped Stages ("));
                    $buf27.$amp$plus((Object)BoxesRunTime.boxToInteger((int)pendingOrSkippedStages.size()));
                    $buf27.$amp$plus((Object)new Text(")"));
                    content.elem = (NodeSeq)nodeSeq.$plus$plus((GenTraversableOnce)new Elem(null, "h4", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf27).$plus$plus(pendingOrSkippedStagesTable.toNodeSeq(), NodeSeq$.MODULE$.canBuildFrom()), NodeSeq$.MODULE$.canBuildFrom());
                }
                if (shouldShowFailedStages) {
                    NodeSeq nodeSeq = (NodeSeq)content.elem;
                    Null$ $md12 = Null$.MODULE$;
                    $md12 = new UnprefixedAttribute("id", (Seq)new Text("failed"), (MetaData)$md12);
                    NodeBuffer $buf28 = new NodeBuffer();
                    $buf28.$amp$plus((Object)new Text("Failed Stages ("));
                    $buf28.$amp$plus((Object)BoxesRunTime.boxToInteger((int)failedStages.size()));
                    $buf28.$amp$plus((Object)new Text(")"));
                    content.elem = (NodeSeq)nodeSeq.$plus$plus((GenTraversableOnce)new Elem(null, "h4", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf28).$plus$plus(failedStagesTable.toNodeSeq(), NodeSeq$.MODULE$.canBuildFrom()), NodeSeq$.MODULE$.canBuildFrom());
                }
                String x$4 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Details for Job ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)jobId)}));
                Serializable x$5 = new Serializable(this, content){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef content$1;

                    public final NodeSeq apply() {
                        return (NodeSeq)this.content$1.elem;
                    }
                    {
                        this.content$1 = content$1;
                    }
                };
                JobsTab x$6 = this.org$apache$spark$ui$jobs$JobPage$$parent;
                boolean x$7 = true;
                Option<Object> x$8 = UIUtils$.MODULE$.headerSparkPage$default$4();
                Option<String> x$9 = UIUtils$.MODULE$.headerSparkPage$default$5();
                boolean x$10 = UIUtils$.MODULE$.headerSparkPage$default$7();
                seq = UIUtils$.MODULE$.headerSparkPage(x$4, (Function0<Seq<Node>>)x$5, x$6, x$8, x$9, x$7, x$10);
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block23;
                seq = (Seq<Node>)nonLocalReturnControl2.value();
            }
            return seq;
        }
        throw nonLocalReturnControl2;
    }

    public JobPage(JobsTab parent, AppStatusStore store) {
        this.org$apache$spark$ui$jobs$JobPage$$parent = parent;
        this.org$apache$spark$ui$jobs$JobPage$$store = store;
        super("job");
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("legend-area"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("height", (Seq)new Text("85px"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("width", (Seq)new Text("150px"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("y", (Seq)new Text("5px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("completed-stage-legend"), (MetaData)$md3);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("y", (Seq)new Text("17px"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md4);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Completed"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("y", (Seq)new Text("30px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("failed-stage-legend"), (MetaData)$md5);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("y", (Seq)new Text("42px"), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md6);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Failed"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("y", (Seq)new Text("55px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("active-stage-legend"), (MetaData)$md7);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("y", (Seq)new Text("67px"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md8);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Active"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "svg", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        this.STAGES_LEGEND = (String)new StringOps(Predef$.MODULE$.augmentString(new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf).toString())).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$1) {
                return x$1 != '\n';
            }
        });
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("class", (Seq)new Text("legend-area"), (MetaData)$md9);
        NodeBuffer $buf6 = new NodeBuffer();
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("height", (Seq)new Text("55px"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("width", (Seq)new Text("150px"), (MetaData)$md10);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("y", (Seq)new Text("5px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("class", (Seq)new Text("executor-added-legend"), (MetaData)$md11);
        $buf7.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("y", (Seq)new Text("17px"), (MetaData)$md12);
        $md12 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md12);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Added"));
        $buf7.$amp$plus((Object)new Elem(null, "text", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("y", (Seq)new Text("30px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("class", (Seq)new Text("executor-removed-legend"), (MetaData)$md13);
        $buf7.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md14 = Null$.MODULE$;
        $md14 = new UnprefixedAttribute("y", (Seq)new Text("42px"), (MetaData)$md14);
        $md14 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md14);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Removed"));
        $buf7.$amp$plus((Object)new Elem(null, "text", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf7.$amp$plus((Object)new Text("\n    "));
        $buf6.$amp$plus((Object)new Elem(null, "svg", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        this.EXECUTORS_LEGEND = (String)new StringOps(Predef$.MODULE$.augmentString(new Elem(null, "div", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6).toString())).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$2) {
                return x$2 != '\n';
            }
        });
    }
}

