/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll.util;

import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TimeRange {
    public static final TimeRange ALL_TIME = new TimeRange(Long.MAX_VALUE, 0L, TimeUnit.SECONDS);
    private final Date low;
    private final Date high;

    public TimeRange(long high, long low, TimeUnit unit) {
        this(TimeRange.getDate(high, unit), TimeRange.getDate(low, unit));
    }

    private static Date getDate(long time, TimeUnit unit) {
        return new Date(TimeUnit.MILLISECONDS.convert(time, unit));
    }

    public TimeRange(Date high, Date low) {
        if (high.before(low)) {
            throw new RuntimeException("TimeRange construct failure. High cannot be before low. High=" + high + " low=" + low);
        }
        this.high = high;
        this.low = low;
    }

    public Date getLow() {
        return this.low;
    }

    public Date getHigh() {
        return this.high;
    }

    public long getLow(TimeUnit unit) {
        return this.getTime(this.low.getTime(), unit);
    }

    private long getTime(long time, TimeUnit unit) {
        return unit.convert(time, TimeUnit.MILLISECONDS);
    }

    public long getHigh(TimeUnit unit) {
        return this.getTime(this.high.getTime(), unit);
    }

    public boolean overlaps(TimeRange other) {
        TimeUnit unit = TimeUnit.MILLISECONDS;
        boolean insideLeft = this.getLow(unit) <= other.getHigh(unit);
        boolean insideRight = this.getHigh(unit) >= other.getLow(unit);
        return insideLeft && insideRight;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.high == null ? 0 : this.high.hashCode());
        result = 31 * result + (this.low == null ? 0 : this.low.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeRange) {
            TimeRange other = (TimeRange)obj;
            TimeUnit unit = TimeUnit.MILLISECONDS;
            return this.getHigh(unit) == other.getHigh(unit) && this.getLow(unit) == other.getLow(unit);
        }
        return false;
    }

    public String toString() {
        TimeUnit unit = TimeUnit.MILLISECONDS;
        return "TimeRange [low=" + this.getLow(unit) + ", high=" + this.getHigh(unit) + "]";
    }
}

