/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import com.splunk.io.SearchOutputStream;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.cache.JobQueue;
import com.splunk.util.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class ResultFileReader
implements Runnable {
    private LinkedHashSet<String> _processedSplits;
    private static Logger gLogger = Logger.getLogger(ResultFileReader.class);
    final Source _source;
    SearchOutputStream _out = null;
    Set<String> _ignoreSplits = null;
    boolean _removeResultFile = false;
    int _maxSplitCount;

    public static ResultFileReader create(final FileSystem fs, final Path resultFile, SearchOutputStream out, Set<String> ignoreSplits, final String streamType) {
        int maxSplitCount = fs.getConf().getInt(SplunkMR.CONF_MAX_SPLITS, 10000);
        return new ResultFileReader(new Source(){
            private FileStatus fileStatus;

            @Override
            public void init() throws IOException {
                this.fileStatus = fs.getFileStatus(resultFile);
            }

            @Override
            public void deleteInput() throws IOException {
                fs.delete(resultFile, false);
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return fs.open(resultFile);
            }

            @Override
            public String getPath() {
                return resultFile.toString();
            }

            public String toString() {
                return "file: " + resultFile;
            }

            @Override
            public long getLength() {
                return this.fileStatus.getLen();
            }

            @Override
            public String getName() {
                return "report";
            }

            @Override
            public String getStreamType() {
                return streamType;
            }
        }, out, ignoreSplits, maxSplitCount);
    }

    public static ResultFileReader create(final JobQueue.CacheJob cacheResult, SearchOutputStream out, Set<String> ignoreSplits) {
        return new ResultFileReader(new Source(){

            @Override
            public InputStream getInputStream() throws IOException {
                return cacheResult.openResults();
            }

            @Override
            public String getPath() {
                return cacheResult.getPath().toString();
            }

            public String toString() {
                return "Cache queue job";
            }

            @Override
            public long getLength() {
                return cacheResult.length;
            }

            @Override
            public String getName() {
                return "cache";
            }

            @Override
            public String getStreamType() {
                return "report_cache";
            }
        }, out, ignoreSplits);
    }

    public ResultFileReader(Source source, SearchOutputStream out, Set<String> ignoreSplits, int maxSplitCount) {
        this._out = out;
        this._ignoreSplits = ignoreSplits;
        this._source = source;
        this._maxSplitCount = maxSplitCount;
    }

    public ResultFileReader(Source source, SearchOutputStream out, Set<String> ignoreSplits) {
        this(source, out, ignoreSplits, 10000);
    }

    public void setRemoveResultFile(boolean val) {
        this._removeResultFile = val;
    }

    public void setProcessedSplits(LinkedHashSet<String> processedSplits) {
        this._processedSplits = processedSplits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStream in = null;
        String splitId = null;
        try {
            Object object;
            this._source.init();
            long bufSize = Math.max(Math.min(0x100000L, this._source.getLength()), 4096L);
            in = new GZIPInputStream(this._source.getInputStream(), (int)bufSize);
            long wb = 0L;
            long st = System.currentTimeMillis();
            long start = System.currentTimeMillis();
            splitId = StrUtil.readline(in, SplunkMR.UTF8.name());
            gLogger.debug((Object)(Thread.currentThread().getName() + " got a split: " + splitId + ", source=" + this._source.getPath()));
            boolean processReportSplit = false;
            boolean reportType = "report".equals(this._source.getStreamType());
            if (reportType && this._processedSplits != null) {
                object = this._processedSplits;
                synchronized (object) {
                    if (this._processedSplits.size() > 5 * this._maxSplitCount) {
                        try {
                            Iterator iter = this._processedSplits.iterator();
                            for (int i = 0; i < this._maxSplitCount; ++i) {
                                iter.next();
                                iter.remove();
                            }
                            gLogger.debug((Object)("cleaned up the first " + this._maxSplitCount + " splitsIds from cache to free up memory."));
                        }
                        catch (Throwable e) {
                            gLogger.warn((Object)"Failed to clean up splitIds from cache to free up memory", e);
                        }
                    }
                    processReportSplit = this._processedSplits.add(splitId);
                }
            }
            if (this._ignoreSplits != null && this._ignoreSplits.contains(splitId)) {
                gLogger.debug((Object)(Thread.currentThread().getName() + " ignored " + this._source.getName() + " results for streamed split " + splitId));
            } else if (reportType && !processReportSplit) {
                gLogger.debug((Object)(Thread.currentThread().getName() + " ignored " + this._source.getName() + " results for processed split " + splitId));
            } else {
                object = this._out;
                synchronized (object) {
                    this._out.setStreamType(this._source.getStreamType());
                    gLogger.debug((Object)(Thread.currentThread().getName() + " streaming " + this._source.getName() + " results for " + splitId));
                    int outBufSize = (int)Math.min(0x100000L, Math.max(65536L, bufSize * 10L));
                    wb = this._out.copyAll(in, outBufSize);
                    String metric = this._source.getName() + ".bytes";
                    this._out.addMetric(metric, System.currentTimeMillis() - st, 1L);
                    this._out.addCountMetric(metric, this._source.getLength(), wb);
                    this._out.flush();
                }
            }
            if (this._removeResultFile) {
                this._source.deleteInput();
            }
            gLogger.debug((Object)String.format("streamed result for split %s: elapsed=%d, size=%d, payload=%d", splitId, System.currentTimeMillis() - start, this._source.getLength(), wb));
        }
        catch (Exception e) {
            gLogger.error((Object)("Error while reading the results for split " + splitId + ", Result file source: " + this._source.getPath()), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    public static abstract class Source {
        public abstract InputStream getInputStream() throws IOException;

        public void init() throws IOException {
        }

        public void deleteInput() throws IOException {
        }

        public abstract long getLength();

        public abstract String getPath();

        public abstract String getName();

        public abstract String getStreamType();
    }
}

