/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.packaging;

import com.splunk.mr.packaging.CountingTempFileProvider;
import com.splunk.mr.packaging.DeletesOldPackages;
import com.splunk.mr.packaging.GetsSplunkManifest;
import com.splunk.mr.packaging.IncrementFileCountWhenFileIsStale;
import com.splunk.mr.packaging.LongFileModeSelector;
import com.splunk.mr.packaging.ManifestLineParser;
import com.splunk.mr.packaging.ManifestPackager;
import com.splunk.mr.packaging.SynchronizedExecuter;
import com.splunk.mr.packaging.TgzCompressor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class SplunkManifestPackager {
    private static final int TEMP_FILE_COUNT_LIMIT = 5;
    private static final Logger gLogger = Logger.getLogger(SplunkManifestPackager.class);
    private static final List<String> ignoreList = Arrays.asList("share/splunk/search_mrsparkle/", "share/splunk/mbtiles/", "etc/apps/sample_app/", "etc/apps/gettingstarted/", "etc/apps/cupcake_demo/", "bin/jars/");
    private final GetsSplunkManifest getsSplunkManifest;
    private final ManifestPackager manifestPackager;
    private final DeletesOldPackages deletesOldPackages;
    static int LONG_TIME_AGO_IN_MILLIS = 1800000;

    public SplunkManifestPackager(GetsSplunkManifest getsSplunkManifest, ManifestPackager manifestPackager, DeletesOldPackages deletesOldPackages) {
        this.getsSplunkManifest = getsSplunkManifest;
        this.manifestPackager = manifestPackager;
        this.deletesOldPackages = deletesOldPackages;
    }

    public void ensurePackage(File packageFile) {
        SplunkManifestPackager.deleteOldReallyOldFailedFiles(CountingTempFileProvider.getProvidedFiles(packageFile, 5));
        CountingTempFileProvider tempFileProvider = new CountingTempFileProvider(packageFile, 5, new IncrementFileCountWhenFileIsStale());
        this.doEnsurePackage(packageFile, tempFileProvider);
        this.deletesOldPackages.delete();
    }

    private void doEnsurePackage(File packageFile, SynchronizedExecuter.TempProvider<File> tempFileProvider) {
        block2: {
            int retryMillisSleepPerTry = 100;
            try {
                SynchronizedExecuter.executeOnAcquired(tempFileProvider, this.handleAcquiredTempFile(packageFile), this.stopTryingToAcquireFileCondtion(packageFile), SynchronizedExecuter.createFileAtomically(), retryMillisSleepPerTry);
            }
            catch (RuntimeException e) {
                if (packageFile.exists()) break block2;
                throw e;
            }
        }
    }

    private SynchronizedExecuter.AcquiredHandler<File> handleAcquiredTempFile(final File outputFile) {
        return new SynchronizedExecuter.AcquiredHandler<File>(){

            @Override
            public void onAcquired(File acquired) {
                SplunkManifestPackager.this.tryCreatingSplunkManifestPackage(outputFile, acquired);
            }
        };
    }

    private SynchronizedExecuter.AbortCondition stopTryingToAcquireFileCondtion(final File outputFile) {
        return new SynchronizedExecuter.AbortCondition(){

            @Override
            public boolean shouldStopRetrying() {
                return outputFile.exists();
            }
        };
    }

    void tryCreatingSplunkManifestPackage(File outputFile, File acquired) {
        if (!outputFile.exists()) {
            this.createSplunkManifestPackage(outputFile, acquired);
        } else {
            gLogger.info((Object)("Package from manifest already existed. Using exiting package: " + outputFile.getAbsolutePath()));
        }
    }

    private void createSplunkManifestPackage(File outputFile, File tempFile) {
        gLogger.info((Object)("Creating package: " + outputFile.getAbsolutePath()));
        try {
            this.writeAtomically(outputFile, tempFile);
            gLogger.info((Object)("Successfully created package: " + outputFile.getAbsolutePath()));
        }
        catch (Exception e) {
            gLogger.warn((Object)("Got exception when writing Splunk package. Deleting . Exception: " + e));
            gLogger.info((Object)"Package creation failed.");
            FileUtils.deleteQuietly((File)tempFile);
            throw new SplunkPackageException(e);
        }
    }

    private void writeAtomically(File outputFile, File tempFile) throws IOException {
        this.write(tempFile);
        this.renameWithExceptions(tempFile, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(File tempWrite) throws IOException, FileNotFoundException {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = this.getsSplunkManifest.getSplunkManifestFileInputStream();
            out = SplunkManifestPackager.getOutputStream(tempWrite);
            this.manifestPackager.pack(this.getsSplunkManifest.getSplunkManifestFileInputStream(), SplunkManifestPackager.getOutputStream(tempWrite));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    private void renameWithExceptions(File src, File dst) throws IOException {
        if (!src.renameTo(dst)) {
            throw new IOException("Could not rename file:" + src + ", to: " + dst + ".");
        }
    }

    static void deleteOldReallyOldFailedFiles(List<File> files) {
        for (File f : files) {
            if (!SplunkManifestPackager.isFileStaleForALongTime(f)) continue;
            FileUtils.deleteQuietly((File)f);
        }
    }

    private static boolean isFileStaleForALongTime(File f) {
        long longTimeAgo = System.currentTimeMillis() - (long)LONG_TIME_AGO_IN_MILLIS;
        return f.lastModified() < longTimeAgo;
    }

    public static SplunkManifestPackager create(String splunkHomePath) {
        File splunkHome = new File(splunkHomePath);
        GetsSplunkManifest getsSplunkManifest = new GetsSplunkManifest(splunkHome);
        ManifestLineParser parser = new ManifestLineParser(splunkHome);
        return new SplunkManifestPackager(getsSplunkManifest, new ManifestPackager(new TgzCompressor(LongFileModeSelector.selectTarLongFileMode(parser)), parser, ignoreList), new DeletesOldPackages(getsSplunkManifest));
    }

    private static OutputStream getOutputStream(File file) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    public static File getPackageFile(String splunkHome) {
        File splunkManifestFile = new GetsSplunkManifest(new File(splunkHome)).getLastModifiedManifestFile();
        return new File(splunkHome, SplunkManifestPackager.manifestFileNameToPackageName(splunkManifestFile.getName()));
    }

    public static String manifestFileNameToPackageName(String manifestFileName) {
        return manifestFileName.replace("-manifest", ".tgz");
    }

    public static class SplunkPackageException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SplunkPackageException(Exception e) {
            super("Got exception while creating Splunk Package from manifest", e);
        }

        public SplunkPackageException(String message) {
            super(message);
        }
    }
}

