/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.packaging;

import com.splunk.mr.packaging.ManifestLine;
import com.splunk.mr.packaging.ManifestLineParser;
import com.splunk.mr.packaging.TgzCompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ManifestPackager {
    private final TgzCompressor compressor;
    private final ManifestLineParser parser;
    private final List<String> ignorePaths;

    public ManifestPackager(TgzCompressor compressor, ManifestLineParser parser) {
        this(compressor, parser, new ArrayList<String>());
    }

    public ManifestPackager(TgzCompressor compressor, ManifestLineParser parser, List<String> ignorePaths) {
        this.compressor = compressor;
        this.parser = parser;
        this.ignorePaths = ignorePaths;
    }

    public void pack(InputStream in, OutputStream out) throws IOException {
        try {
            this.doPack(in, out);
        }
        finally {
            this.compressor.close();
        }
    }

    private void doPack(InputStream in, OutputStream out) throws IOException {
        this.compressor.init(out);
        List<ManifestLine> lines = this.parser.parseLines(in);
        for (ManifestLine line : lines) {
            if (this.isIgnored(line)) continue;
            this.compressor.addManifestLine(line);
        }
    }

    private boolean isIgnored(ManifestLine line) {
        if (line.getType().equals((Object)ManifestLine.Type.COMMENT)) {
            return true;
        }
        String pathWithoutFirstDir = ManifestLineParser.getPathWithoutFirstDir(line.getPath());
        for (String s : this.ignorePaths) {
            if (!pathWithoutFirstDir.startsWith(s)) continue;
            return true;
        }
        return false;
    }
}

