/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache.compact;

import com.splunk.io.SearchMetricsReporter;
import com.splunk.mr.cache.MapCache;
import java.io.IOException;
import org.apache.log4j.Logger;

public class CacheCompaction {
    private static final Logger gLogger = Logger.getLogger(CacheCompaction.class);

    public static class Large
    extends Compaction {
        public Large(MapCache mapCache, SearchMetricsReporter metrics) {
            super(mapCache, metrics);
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            try {
                int mergeCount = this.mapCache.mergeCache();
                this.metrics.addMetric("cache.merge", System.currentTimeMillis() - now, 1L);
                this.metrics.addCountMetric("cache.merge", 0L, mergeCount);
            }
            catch (IOException e) {
                gLogger.debug((Object)("Got exception when doing large compaction: " + e));
            }
        }
    }

    public static class Small
    extends Compaction {
        private final int limit;

        public Small(MapCache mapCache, SearchMetricsReporter metrics, int limit) {
            super(mapCache, metrics);
            this.limit = limit;
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            try {
                int processed = this.mapCache.processJobQueue(this.limit, this.metrics);
                this.metrics.addMetric("cache.compact", System.currentTimeMillis() - now, 1L);
                this.metrics.addCountMetric("cache.compact", 0L, processed);
            }
            catch (IOException e) {
                gLogger.debug((Object)("Got exception when doing small compaction: " + e));
            }
        }
    }

    private static abstract class Compaction
    implements Runnable {
        protected final MapCache mapCache;
        protected final SearchMetricsReporter metrics;

        public Compaction(MapCache mapCache, SearchMetricsReporter metrics) {
            this.mapCache = mapCache;
            this.metrics = metrics;
        }
    }
}

