/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.search.processors;

import com.splunk.mr.AsyncMRJob;
import com.splunk.mr.CleanupMapper;
import com.splunk.mr.JobInfo;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.input.CleanupInputFormat;
import com.splunk.mr.input.RegexPathFilter;
import com.splunk.search.SearchProcessor;
import com.splunk.search.SearchResults;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.log4j.Logger;

public class ERPAdminProcessor
extends SearchProcessor {
    private static Logger gLogger = Logger.getLogger(ERPAdminProcessor.class);
    private static final Pattern LOCATION_PATTERN = Pattern.compile("^(hdfs|tasktrackers|all)$", 2);
    protected Configuration _conf;
    protected boolean _done = false;

    public ERPAdminProcessor(Configuration conf) {
        this._conf = conf;
    }

    @Override
    public boolean isGenerating() {
        return true;
    }

    @Override
    public void aboutToExecute() {
        super.aboutToExecute();
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("Conf passed to ERPAdmin:" + this._conf.toString()));
        }
    }

    @Override
    public boolean execute(SearchResults results) {
        if (this._done) {
            return this._done;
        }
        this._done = true;
        String action = this.getOption("action");
        if ("cleanup".equalsIgnoreCase(action)) {
            String location = this.getOption("location");
            if (location == null || !LOCATION_PATTERN.matcher(location).matches()) {
                throw new RuntimeException("erpadmin action=cleanup must specify location option (tasktrackers, hdfs, or all)");
            }
            if (location.equalsIgnoreCase("hdfs") || location.equalsIgnoreCase("all")) {
                this.cleanupHdfs(results);
            }
            if (!SplunkMR.useProxy(this._conf) && (location.equalsIgnoreCase("tasktrackers") || location.equalsIgnoreCase("all"))) {
                this.cleanTaskTrackers(results);
            }
        } else {
            throw new RuntimeException("erpadmin must specify action option (cleanup)");
        }
        return this._done;
    }

    private SearchResults.Result addResult(SearchResults results, String subaction, String dir, String location, String status) {
        SearchResults.Result r = results.addNewResult();
        r.set("action", (Object)subaction);
        r.set("directory", (Object)dir);
        r.set("location", (Object)location);
        r.set("status", (Object)status);
        r.set("provider", (Object)this._conf.get(SplunkMR.CONF_PROVIDER));
        return r;
    }

    private void addExceptionResult(SearchResults results, String subaction, String dir, String location, Exception ex) {
        SearchResults.Result r = this.addResult(results, subaction, dir, location, "ERROR");
        r.set("error", (Object)ex.getMessage());
        gLogger.error((Object)("Error while running action=" + subaction + " on dir=" + dir + " on location=" + location), (Throwable)ex);
    }

    protected FileSystem getAdminFileSystem(URI dirUri, Configuration conf) throws IOException, InterruptedException {
        if (SplunkMR.useProxy(conf)) {
            return SplunkMR.getProxyUserFileSystem(dirUri, conf);
        }
        return FileSystem.get((URI)dirUri, (Configuration)conf);
    }

    protected void cleanupHdfs(SearchResults results) {
        String dir = "unknown";
        try {
            Path cacheDirPath = SplunkMR.getTopLevelCacheDir(this._conf);
            FileSystem fs = this.getAdminFileSystem(cacheDirPath.toUri(), this._conf);
            dir = cacheDirPath.toString();
            if (fs.exists(cacheDirPath) && !fs.delete(cacheDirPath, true)) {
                this.addResult(results, "delete_cache", dir, "hdfs", "FAILED");
            } else {
                this.addResult(results, "delete_cache", dir, "hdfs", "SUCCEEDED");
            }
            Path workingDirPath = new Path(this._conf.get(SplunkMR.CONF_HDFS_HOME));
            fs = this.getAdminFileSystem(workingDirPath.toUri(), this._conf);
            dir = workingDirPath.toString();
            if (this.deleteAllButCurrentHdfsDispatchDir(fs, workingDirPath)) {
                this.addResult(results, "delete_working_dir", dir, "hdfs", "SUCCEEDED");
            } else {
                this.addResult(results, "delete_working_dir", dir, "hdfs", "FAILED");
            }
        }
        catch (IOException e) {
            this.addExceptionResult(results, "delete", dir, "hdfs", e);
        }
        catch (InterruptedException e) {
            this.addExceptionResult(results, "delete", dir, "hdfs", e);
        }
    }

    private boolean deleteAllButCurrentHdfsDispatchDir(FileSystem fs, Path dir) throws IOException {
        if (!fs.exists(dir)) {
            return true;
        }
        String currentSidPattern = this._conf.get(SplunkMR.CONF_SEARCH_ID);
        RegexPathFilter pf = new RegexPathFilter(currentSidPattern){

            @Override
            public boolean accept(Path path) {
                return !this._p.matcher(path.toString()).find();
            }
        };
        boolean deleted = true;
        for (FileStatus fstat : fs.listStatus(dir)) {
            if (fstat.getPath().getName().equals("dispatch")) {
                for (FileStatus fst : fs.listStatus(fstat.getPath(), (PathFilter)pf)) {
                    deleted = fs.delete(fst.getPath(), true) && deleted;
                }
                continue;
            }
            deleted = fs.delete(fstat.getPath(), true) && deleted;
        }
        return deleted;
    }

    protected void cleanTaskTrackers(SearchResults results) {
        String dnHome = this._conf.get(SplunkMR.CONF_DN_HOME);
        String jobName = "SPLK_Clean_" + SplunkMR.HOSTNAME + "_" + this._conf.get(SplunkMR.CONF_SEARCH_ID);
        try {
            AsyncMRJob cleanJob = this.submitAndWaitForCleanupJob(jobName);
            JobInfo ji = JobInfo.getInstance(cleanJob);
            int startId = 0;
            TaskCompletionEvent[] events = ji.getTaskCompletionEvents(startId);
            while (events.length > 0) {
                startId += events.length;
                for (TaskCompletionEvent tce : events) {
                    if (!tce.isMapTask()) continue;
                    URL ttUrl = new URL(tce.getTaskTrackerHttp());
                    SearchResults.Result r = this.addResult(results, "delete", dnHome, ttUrl.getHost(), tce.getTaskStatus().toString());
                    r.set("taskId", (Object)tce.getTaskAttemptId().getTaskID().toString());
                }
                events = ji.getTaskCompletionEvents(startId);
            }
        }
        catch (IOException e) {
            this.addExceptionResult(results, "delete", dnHome, "tasktrackers", e);
        }
        catch (InterruptedException e) {
        }
        catch (ClassNotFoundException e) {
            this.addExceptionResult(results, "delete", dnHome, "tasktrackers", e);
        }
        catch (InstantiationException e) {
            this.addExceptionResult(results, "delete", dnHome, "tasktrackers", e);
        }
    }

    private AsyncMRJob submitAndWaitForCleanupJob(String jobName) throws IOException, InterruptedException, ClassNotFoundException {
        this._conf.set("mapred.map.max.attempts", "1");
        this._conf.set("mapred.map.tasks.speculative.execution", "false");
        AsyncMRJob cleanJob = new AsyncMRJob(this._conf, jobName);
        cleanJob.setOutputKeyClass(Text.class);
        cleanJob.setOutputValueClass(Text.class);
        cleanJob.setMapperClass(CleanupMapper.class);
        cleanJob.setNumReduceTasks(0);
        cleanJob.setInputFormatClass(CleanupInputFormat.class);
        cleanJob.setOutputFormatClass(TextOutputFormat.class);
        FileOutputFormat.setOutputPath((Job)cleanJob, (Path)SplunkMR.getHDFSDispatchHome(this._conf));
        cleanJob.setJarByClass(SplunkMR.class);
        gLogger.info((Object)("submitting new job, name=" + jobName));
        cleanJob.submit(false);
        cleanJob.waitForCompletion(true);
        return cleanJob;
    }
}

