/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import com.splunk.mr.input.VirtualIndex;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class TimeRange {
    public final long et;
    public final long lt;

    public TimeRange(long et, long lt) {
        this.et = et;
        this.lt = lt;
    }

    public static TimeRange createSearchTimeRange(Configuration conf) {
        Map<String, Object> search_info = VirtualIndex.getSearchInfo(conf);
        long et = TimeRange.getTimeByKey(search_info, "_search_et", 0L);
        long lt = TimeRange.getTimeByKey(search_info, "_search_lt", Long.MAX_VALUE);
        if (lt == 0L) {
            lt = Long.MAX_VALUE;
        }
        return new TimeRange(et, lt);
    }

    private static long getTimeByKey(Map<String, Object> search_info, String key, long default_) {
        try {
            return (long)Double.parseDouble(search_info.get(key).toString());
        }
        catch (Exception ignore) {
            return default_;
        }
    }

    public String toString() {
        return "TimeRange [et=" + this.et + ", lt=" + this.lt + "]";
    }
}

