/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import com.splunk.mr.ClusterInfo;
import com.splunk.mr.SearchController;
import com.splunk.mr.SplunkMR;
import com.splunk.util.SSLUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class ClusterInfoLogger
extends Thread {
    private static Logger gLogger = Logger.getLogger(ClusterInfoLogger.class);
    protected Configuration _conf = null;
    protected String _splunkd_uri = null;

    public ClusterInfoLogger(Configuration conf, Map<String, Object> searchInfo, boolean autoStart) {
        this._conf = new Configuration(conf);
        this.setName("ClusterInfoLogger");
        this._splunkd_uri = String.valueOf(searchInfo.get("_splunkd_uri"));
        this.setDaemon(true);
        if (autoStart) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void auditToSplunkd(ClusterInfo cs) {
        InputStream httpIn = null;
        try {
            if (this._splunkd_uri != null && this._splunkd_uri.startsWith("http")) {
                String url = String.format("%s/services/audit/hunk?search_id=%s&provider=%s&tasktrackers=%d&map_inuse=%d&map_slots=%d&reduce_inuse=%d&reduce_slots=%d", this._splunkd_uri, this._conf.get(SplunkMR.CONF_SEARCH_ID, "NULL"), this._conf.get(SplunkMR.CONF_PROVIDER), cs.getTaskTrackers(), cs.getMapTasks(), cs.getMaxMapTasks(), cs.getReduceTasks(), cs.getMaxReduceTasks());
                if (url.startsWith("https://")) {
                    SSLUtil.trustEveryone();
                }
                URLConnection con = new URL(url).openConnection();
                con.connect();
                httpIn = con.getInputStream();
                IOUtils.copy((InputStream)httpIn, (OutputStream)new NullOutputStream());
            }
        }
        catch (Exception exception) {
        }
        finally {
            IOUtils.closeQuietly(httpIn);
        }
    }

    @Override
    public void run() {
        ClusterInfoLogger.yield();
        try {
            ClusterInfo cs = ClusterInfo.getInstance(this._conf);
            gLogger.info((Object)String.format("Hadoop cluster spec: provider=%s, tasktrackers=%d, map_inuse=%d, map_slots=%d, reduce_inuse=%d, reduce_slots=%d\n", this._conf.get(SplunkMR.CONF_PROVIDER), cs.getTaskTrackers(), cs.getMapTasks(), cs.getMaxMapTasks(), cs.getReduceTasks(), cs.getMaxReduceTasks()));
            SearchController.instance().setHadoopNodeCount(cs.getTaskTrackers());
            this.auditToSplunkd(cs);
        }
        catch (Exception e) {
            gLogger.warn((Object)"Exception thrown while logging cluster info", (Throwable)e);
        }
    }
}

