/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.datasource;

import com.splunk.datasource.Field;
import com.splunk.datasource.Writer;
import com.splunk.datasource.hive.OrcWriter;
import com.splunk.datasource.parquet.ParquetWriter;
import com.splunk.mr.SplunkMR;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.log4j.Logger;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class WriterFactory {
    private static final Logger logger = Logger.getLogger(WriterFactory.class);

    public static Writer getInstance(Configuration conf, Path file, List<Field> fields) throws IOException {
        String fileFormat = conf.get(SplunkMR.CONF_DATASOURCE_FORMAT, "orc");
        Format format = Format.valueOf(fileFormat);
        String blockSize = conf.get("dfs.block.size");
        String codec = conf.get(SplunkMR.CONF_DATAMODEL_COMPRESSION_CODEC, "snappy");
        String bfColumns = conf.get(SplunkMR.CONF_DATAMODEL_BLOOMFILTER_COLUMNS);
        switch (format) {
            case parquet: {
                ParquetWriter.WriterOptions options = new ParquetWriter.WriterOptions(conf);
                if (blockSize != null) {
                    options.blockSize = Integer.parseInt(blockSize);
                }
                options.codecName = codec.equals("uncompressed") ? CompressionCodecName.UNCOMPRESSED : CompressionCodecName.valueOf((String)codec.toUpperCase());
                return new ParquetWriter(file, fields, options);
            }
        }
        OrcFile.WriterOptions wo = OrcFile.writerOptions((Configuration)conf);
        if (blockSize != null) {
            wo.stripeSize((long)Integer.parseInt(blockSize));
        }
        if (codec.equals("uncompressed")) {
            wo.compress(CompressionKind.NONE);
        } else {
            wo.compress(CompressionKind.valueOf((String)codec.toUpperCase()));
        }
        if (bfColumns != null) {
            try {
                Method m = wo.getClass().getMethod("bloomFilterColumns", String.class);
                if (m != null) {
                    m.invoke((Object)wo, bfColumns);
                    logger.info((Object)("set orc.bloom.filter.columns=" + bfColumns));
                }
            }
            catch (Exception e) {
                logger.error((Object)"Unable to set bloom filter columns", (Throwable)e);
            }
        }
        return new OrcWriter(file, fields, wo);
    }

    public static enum Format {
        orc,
        parquet;

    }
}

