/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.collect;

import com.splunk.collect.AbstractEventWriter;
import com.splunk.s2s.Event;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.log4j.Logger;

public class KafkaEventWriter
extends AbstractEventWriter {
    private ArrayList<String> topicList = new ArrayList();
    private String partitioningKey = null;
    private Producer<String, String> _producer = null;
    private static final Logger gLogger = Logger.getLogger(KafkaEventWriter.class);
    private static final String KAFKA_KEY_SERIALIZER = "key.serializer";
    private static final String KAFKA_VALUE_SERIALIZER = "value.serializer";
    private static final String KAFKA_TOPIC = "splunk.topic";
    private static final String DEFAULT_TOPIC = "default";

    public KafkaEventWriter(boolean trackEventIds) {
        super(trackEventIds);
    }

    public KafkaEventWriter(Configuration conf, Properties kafkaProperties, String partitioningKey) {
        super(false);
        if (!kafkaProperties.containsKey(KAFKA_KEY_SERIALIZER)) {
            kafkaProperties.put(KAFKA_KEY_SERIALIZER, "org.apache.kafka.common.serialization.StringSerializer");
        }
        if (!kafkaProperties.containsKey(KAFKA_VALUE_SERIALIZER)) {
            kafkaProperties.put(KAFKA_VALUE_SERIALIZER, "org.apache.kafka.common.serialization.StringSerializer");
        }
        if (kafkaProperties.containsKey(KAFKA_TOPIC)) {
            String[] topics = kafkaProperties.get(KAFKA_TOPIC).toString().trim().split(",");
            for (int i = 0; i < topics.length; ++i) {
                String str = topics[i].trim();
                if (str.isEmpty()) continue;
                this.topicList.add(str);
            }
            gLogger.info((Object)("Events will be directed to kafka topic(s) :" + this.topicList));
        } else {
            this.topicList.add(DEFAULT_TOPIC);
            gLogger.info((Object)"Events will be directed to kafka topic :default");
        }
        this.partitioningKey = partitioningKey;
        this._producer = new KafkaProducer(kafkaProperties);
    }

    @Override
    public String getName() {
        return "kafka";
    }

    @Override
    public void close() throws IOException {
        this._producer.close();
    }

    @Override
    protected void commitImpl() {
    }

    @Override
    protected void addEventImpl(final Event e) throws IOException {
        for (String topic : this.topicList) {
            ProducerRecord record = new ProducerRecord(topic, (Object)this.partitioningKey, (Object)e.getRaw().toString());
            this._producer.send(record, new Callback(){

                public void onCompletion(RecordMetadata metaData, Exception exception) {
                    if (exception != null) {
                        gLogger.error((Object)("Failure in sending following event" + e.getRaw().toString()), (Throwable)exception);
                        gLogger.debug((Object)("Event intended for topic:" + metaData.topic() + ",partition:" + metaData.partition()));
                    }
                }
            });
        }
    }
}

