/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient;
import com.amazonaws.services.elasticmapreduce.model.Application;
import com.amazonaws.services.elasticmapreduce.model.Cluster;
import com.amazonaws.services.elasticmapreduce.model.ClusterState;
import com.amazonaws.services.elasticmapreduce.model.ClusterSummary;
import com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest;
import com.amazonaws.services.elasticmapreduce.model.Instance;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroup;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupType;
import com.amazonaws.services.elasticmapreduce.model.ListClustersRequest;
import com.amazonaws.services.elasticmapreduce.model.ListClustersResult;
import com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsResult;
import com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest;
import com.amazonaws.services.elasticmapreduce.model.ListInstancesResult;
import com.splunk.aws.AWS;
import com.splunk.util.FileBasedCache;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class EMR {
    private static Logger gLogger = Logger.getLogger(EMR.class);
    private static final File CACHE_PATH = new File(System.getenv("SPLUNK_HOME") + "/var/run/splunk/hunk/aws/emr/");
    private FileBasedCache _fileCache = new FileBasedCache(CACHE_PATH, ".emr-cache", 60000L);
    private final AmazonElasticMapReduceClient _emrClient;
    private final AWSCredentials _awsCreds;

    public EMR(AWSCredentials awsCreds, ClientConfiguration cc) {
        this._awsCreds = awsCreds;
        this._emrClient = new AmazonElasticMapReduceClient(awsCreds, cc);
        if (AWS.isAws()) {
            this._emrClient.setRegion(AWS.getRegion());
        }
    }

    public EMR(ClientConfiguration cc) {
        InstanceProfileCredentialsProvider i = new InstanceProfileCredentialsProvider();
        this._awsCreds = i.getCredentials();
        this._emrClient = new AmazonElasticMapReduceClient((AWSCredentialsProvider)i, cc);
        if (AWS.isAws()) {
            this._emrClient.setRegion(AWS.getRegion());
        }
    }

    public AWSCredentials getAWSCredentials() {
        return this._awsCreds;
    }

    public AmazonElasticMapReduceClient getEMRClient() {
        return this._emrClient;
    }

    public void setRegion(String regionName) {
        this._emrClient.setRegion(Region.getRegion((Regions)Regions.fromName((String)regionName)));
    }

    public boolean isHunkable(String clusterId) {
        return this.isHunkable(clusterId, AWS.getRegion(), ClusterState.WAITING);
    }

    public boolean isHunkable(String clusterId, Region region, ClusterState state) {
        this._emrClient.setRegion(region);
        EMRClusterDescription ecd = this.getClusterDetails(clusterId);
        if (ecd == null || !ecd.hunkable) {
            return false;
        }
        if (!ecd.cluster.getStatus().getState().equals(state.name())) {
            return false;
        }
        return ecd.hunkable;
    }

    private static void p(String s) {
        gLogger.info((Object)s);
    }

    private void printConfigStanza(String providerName, String masterHost, String version) {
        EMR.p("[provider:EMR-" + providerName + "]");
        EMR.p("vix.family = hadoop");
        EMR.p("vix.env.HADOOP_HOME = /opt/hadoop/apache/hadoop-" + version);
        EMR.p("vix.env.JAVA_HOME = /opt/java/latest/");
        EMR.p("vix.mapred.job.tracker = " + masterHost + ":9001");
        if (version.startsWith("2.")) {
            EMR.p("vix.command.arg.3 = $SPLUNK_HOME/bin/jars/SplunkMR-hy2.jar");
            EMR.p("vix.mapreduce.framework.name = yarn");
            EMR.p("vix.yarn.resourcemanager.address = " + masterHost + ":9022");
            EMR.p("vix.yarn.resourcemanager.scheduler.address = " + masterHost + ":9024");
        } else if (version.startsWith("3.")) {
            EMR.p("vix.command.arg.3 = $SPLUNK_HOME/bin/jars/SplunkMR-hy3.jar");
            EMR.p("vix.mapreduce.framework.name = yarn");
            EMR.p("vix.yarn.resourcemanager.address = " + masterHost + ":9022");
            EMR.p("vix.yarn.resourcemanager.scheduler.address = " + masterHost + ":9024");
        }
        EMR.p("vix.splunk.home.hdfs = /user/hunk/working-dir/");
        EMR.p("vix.fs.default.name = hdfs://" + masterHost + ":9000");
    }

    public List<EMRClusterDescription> getClusters(Region region, boolean hunkableOnly, ClusterState ... states) {
        LinkedList<EMRClusterDescription> result = new LinkedList<EMRClusterDescription>();
        if (!region.isServiceSupported("elasticmapreduce")) {
            gLogger.info((Object)("Region does not support EMR, region=" + region));
            return result;
        }
        this._emrClient.setRegion(region);
        ListClustersRequest req = new ListClustersRequest();
        req.withClusterStates(states);
        ListClustersResult cRes = this._emrClient.listClusters(req);
        if (cRes.getClusters().isEmpty()) {
            gLogger.debug((Object)("No EMR clusters in states=" + Arrays.toString(states)));
            return result;
        }
        gLogger.debug((Object)("Found EMR clusters in states=" + Arrays.toString(states) + ", count=" + cRes.getClusters().size()));
        for (ClusterSummary c : cRes.getClusters()) {
            EMRClusterDescription r = this.getClusterDetails(c.getId());
            if (r == null || hunkableOnly && !r.hunkable) continue;
            result.add(r);
        }
        return result;
    }

    private EMRClusterDescription checkCache(String clusterId) {
        EMRClusterDescription r = null;
        try {
            r = (EMRClusterDescription)this._fileCache.get(clusterId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return r;
    }

    public EMRClusterDescription getClusterDetails(String clusterId) {
        EMRClusterDescription r = this.checkCache(clusterId);
        if (r != null) {
            gLogger.debug((Object)("cache hit for cluster_id=" + clusterId));
            return r;
        }
        DescribeClusterRequest cReq = new DescribeClusterRequest();
        cReq.withClusterId(clusterId);
        gLogger.debug((Object)("getting cluster details for cluster_id=" + clusterId));
        Cluster cluster = this._emrClient.describeCluster(cReq).getCluster();
        boolean isHunkable = false;
        String hadoopVersion = null;
        for (Application app : cluster.getApplications()) {
            if (hadoopVersion == null && "hadoop".equalsIgnoreCase(app.getName())) {
                hadoopVersion = app.getVersion();
                continue;
            }
            if (!"hunk".equalsIgnoreCase(app.getName())) continue;
            isHunkable = true;
        }
        if (hadoopVersion == null) {
            return null;
        }
        ListInstancesRequest iReq = new ListInstancesRequest();
        iReq.withClusterId(clusterId).withInstanceGroupTypes(new InstanceGroupType[]{InstanceGroupType.MASTER});
        ListInstancesResult instanceResult = this._emrClient.listInstances(iReq);
        ListInstanceGroupsRequest igReq = new ListInstanceGroupsRequest();
        ListInstanceGroupsResult instanceGroups = this._emrClient.listInstanceGroups(igReq.withClusterId(clusterId));
        r = new EMRClusterDescription();
        r.cluster = cluster;
        r.masters = instanceResult.getInstances();
        r.hadoopVersion = hadoopVersion;
        r.hunkable = isHunkable;
        r.instanceGroups = instanceGroups.getInstanceGroups();
        this._fileCache.put(clusterId, r);
        return r;
    }

    private void waitForEMRCluster() {
        this._emrClient.setRegion(Region.getRegion((Regions)Regions.US_WEST_1));
        ListClustersRequest req = new ListClustersRequest();
        req.withClusterStates(new ClusterState[]{ClusterState.WAITING});
        ListClustersResult result = this._emrClient.listClusters(req);
        try {
            while (result.getClusters().isEmpty()) {
                EMR.p("Waiting for EMR cluster to start ...");
                Thread.sleep(5000L);
                result = this._emrClient.listClusters(req);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String clusterId = ((ClusterSummary)result.getClusters().get(0)).getId();
        DescribeClusterRequest cReq = new DescribeClusterRequest();
        cReq.withClusterId(clusterId);
        Cluster cluster = this._emrClient.describeCluster(cReq).getCluster();
        String hadoopVersion = null;
        for (Application app : cluster.getApplications()) {
            if (!"hadoop".equals(app.getName())) continue;
            hadoopVersion = app.getVersion();
            break;
        }
        ListInstanceGroupsRequest igReq = new ListInstanceGroupsRequest();
        igReq.withClusterId(clusterId);
        ListInstancesRequest iReq = new ListInstancesRequest();
        iReq.withClusterId(clusterId).withInstanceGroupTypes(new InstanceGroupType[]{InstanceGroupType.MASTER});
        ListInstancesResult instanceResult = this._emrClient.listInstances(iReq);
        Instance instance = (Instance)instanceResult.getInstances().get(0);
        this.printConfigStanza("foobar", instance.getPublicDnsName(), hadoopVersion);
    }

    public static class EMRClusterDescription
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Cluster cluster;
        public List<Instance> masters;
        public String hadoopVersion;
        public boolean hunkable;
        public List<InstanceGroup> instanceGroups;
    }
}

