/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.io.IntWritable;

public abstract class GenericUDFLeadLag
extends GenericUDF {
    transient ExprNodeEvaluator exprEvaluator;
    transient PTFPartition.PTFPartitionIterator<Object> pItr;
    transient ObjectInspector firstArgOI;
    transient ObjectInspectorConverters.Converter defaultValueConverter;
    int amt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object defaultVal = null;
        if (arguments.length == 3) {
            defaultVal = ObjectInspectorUtils.copyToStandardObject(this.defaultValueConverter.convert(arguments[2].get()), this.firstArgOI);
        }
        int idx = this.pItr.getIndex() - 1;
        int start = 0;
        int end = this.pItr.getPartition().size();
        try {
            Object ret = null;
            int newIdx = this.getIndex(this.amt);
            if (newIdx >= end || newIdx < start) {
                ret = defaultVal;
            } else {
                Object row = this.getRow(this.amt);
                ret = this.exprEvaluator.evaluate(row);
                ret = ObjectInspectorUtils.copyToStandardObject(ret, this.firstArgOI, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            }
            Object object = ret;
            return object;
        }
        finally {
            Object currRow = this.pItr.resetToIndex(idx);
            this.exprEvaluator.evaluate(currRow);
        }
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 1 || arguments.length > 3) {
            throw new UDFArgumentTypeException(arguments.length - 1, "Incorrect invocation of " + this._getFnName() + ": _FUNC_(expr, amt, default)");
        }
        this.amt = 1;
        if (arguments.length > 1) {
            ObjectInspector amtOI = arguments[1];
            if (!ObjectInspectorUtils.isConstantObjectInspector(amtOI) || amtOI.getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveObjectInspector)amtOI).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.INT) {
                throw new UDFArgumentTypeException(1, this._getFnName() + " amount must be a integer value " + amtOI.getTypeName() + " was passed as parameter 1.");
            }
            Object o = ((ConstantObjectInspector)amtOI).getWritableConstantValue();
            this.amt = ((IntWritable)o).get();
            if (this.amt < 0) {
                throw new UDFArgumentTypeException(1, " amount can not be nagative. Specified: " + this.amt);
            }
        }
        if (arguments.length == 3) {
            this.defaultValueConverter = ObjectInspectorConverters.getConverter(arguments[2], arguments[0]);
        }
        this.firstArgOI = arguments[0];
        return ObjectInspectorUtils.getStandardObjectInspector(this.firstArgOI, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
    }

    public ExprNodeEvaluator getExprEvaluator() {
        return this.exprEvaluator;
    }

    public void setExprEvaluator(ExprNodeEvaluator exprEvaluator) {
        this.exprEvaluator = exprEvaluator;
    }

    public PTFPartition.PTFPartitionIterator<Object> getpItr() {
        return this.pItr;
    }

    public void setpItr(PTFPartition.PTFPartitionIterator<Object> pItr) {
        this.pItr = pItr;
    }

    public ObjectInspector getFirstArgOI() {
        return this.firstArgOI;
    }

    public void setFirstArgOI(ObjectInspector firstArgOI) {
        this.firstArgOI = firstArgOI;
    }

    public ObjectInspectorConverters.Converter getDefaultValueConverter() {
        return this.defaultValueConverter;
    }

    public void setDefaultValueConverter(ObjectInspectorConverters.Converter defaultValueConverter) {
        this.defaultValueConverter = defaultValueConverter;
    }

    public int getAmt() {
        return this.amt;
    }

    public void setAmt(int amt) {
        this.amt = amt;
    }

    @Override
    public String getDisplayString(String[] children) {
        if (children.length != 2) {
            return this._getFnName() + "(...)";
        }
        return this.getStandardDisplayString(this._getFnName(), children);
    }

    protected abstract String _getFnName();

    protected abstract Object getRow(int var1) throws HiveException;

    protected abstract int getIndex(int var1);
}

