/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;

public final class VectorSerializeRow<T extends SerializeWrite> {
    private T serializeWrite;
    private Field root;
    private VectorExtractRow vectorExtractRow;
    private boolean hasAnyNulls;
    private boolean isAllNulls;

    public VectorSerializeRow(T serializeWrite) {
        this();
        this.serializeWrite = serializeWrite;
        this.vectorExtractRow = new VectorExtractRow();
    }

    private VectorSerializeRow() {
    }

    private Field[] createFields(TypeInfo[] typeInfos) {
        Field[] children = new Field[typeInfos.length];
        for (int i = 0; i < typeInfos.length; ++i) {
            children[i] = this.createField(typeInfos[i]);
        }
        return children;
    }

    private Field createField(TypeInfo typeInfo) {
        ObjectInspector.Category category;
        Field field = new Field();
        field.category = category = typeInfo.getCategory();
        field.typeInfo = typeInfo;
        if (category == ObjectInspector.Category.PRIMITIVE) {
            field.isPrimitive = true;
            field.primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
        } else {
            field.isPrimitive = false;
            field.objectInspector = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(typeInfo);
            switch (category) {
                case LIST: {
                    field.children = new Field[1];
                    field.children[0] = this.createField(((ListTypeInfo)typeInfo).getListElementTypeInfo());
                    break;
                }
                case MAP: {
                    field.children = new Field[2];
                    field.children[0] = this.createField(((MapTypeInfo)typeInfo).getMapKeyTypeInfo());
                    field.children[1] = this.createField(((MapTypeInfo)typeInfo).getMapValueTypeInfo());
                    break;
                }
                case STRUCT: {
                    StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                    ArrayList<TypeInfo> fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                    field.children = this.createFields(fieldTypeInfos.toArray(new TypeInfo[fieldTypeInfos.size()]));
                    break;
                }
                case UNION: {
                    UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                    List<TypeInfo> objectTypeInfos = unionTypeInfo.getAllUnionObjectTypeInfos();
                    field.children = this.createFields(objectTypeInfos.toArray(new TypeInfo[objectTypeInfos.size()]));
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            field.count = field.children.length;
        }
        return field;
    }

    public void init(List<String> typeNames, int[] columnMap) throws HiveException {
        TypeInfo[] typeInfos = TypeInfoUtils.typeInfosFromTypeNames(typeNames).toArray(new TypeInfo[typeNames.size()]);
        int count = typeInfos.length;
        this.root = new Field();
        this.root.isPrimitive = false;
        this.root.category = ObjectInspector.Category.STRUCT;
        this.root.children = this.createFields(typeInfos);
        this.root.count = count;
        this.root.objectInspector = null;
        int[] outputColumnNums = new int[count];
        for (int i = 0; i < count; ++i) {
            int outputColumnNum;
            outputColumnNums[i] = outputColumnNum = columnMap[i];
            this.root.children[i].outputColumnNum = outputColumnNum;
        }
        this.vectorExtractRow.init(typeInfos, outputColumnNums);
    }

    public void init(List<String> typeNames) throws HiveException {
        TypeInfo[] typeInfos = TypeInfoUtils.typeInfosFromTypeNames(typeNames).toArray(new TypeInfo[typeNames.size()]);
        int count = typeInfos.length;
        this.root = new Field();
        this.root.isPrimitive = false;
        this.root.category = ObjectInspector.Category.STRUCT;
        this.root.children = this.createFields(typeInfos);
        this.root.count = count;
        this.root.objectInspector = null;
        for (int i = 0; i < count; ++i) {
            this.root.children[i].outputColumnNum = i;
        }
        this.vectorExtractRow.init(typeInfos);
    }

    public void init(TypeInfo[] typeInfos) throws HiveException {
        int count = typeInfos.length;
        this.root = new Field();
        this.root.isPrimitive = false;
        this.root.category = ObjectInspector.Category.STRUCT;
        this.root.children = this.createFields(typeInfos);
        this.root.count = count;
        this.root.objectInspector = null;
        for (int i = 0; i < count; ++i) {
            this.root.children[i].outputColumnNum = i;
        }
        this.vectorExtractRow.init(typeInfos);
    }

    public void init(TypeInfo[] typeInfos, int[] columnMap) throws HiveException {
        int count = typeInfos.length;
        this.root = new Field();
        this.root.isPrimitive = false;
        this.root.category = ObjectInspector.Category.STRUCT;
        this.root.children = this.createFields(typeInfos);
        this.root.count = count;
        this.root.objectInspector = null;
        int[] outputColumnNums = new int[count];
        for (int i = 0; i < count; ++i) {
            int outputColumnNum;
            outputColumnNums[i] = outputColumnNum = columnMap[i];
            this.root.children[i].outputColumnNum = outputColumnNum;
        }
        this.vectorExtractRow.init(typeInfos, outputColumnNums);
    }

    public int getCount() {
        return this.root.count;
    }

    public void setOutput(ByteStream.Output output) {
        this.serializeWrite.set(output);
    }

    public void setOutputAppend(ByteStream.Output output) {
        this.serializeWrite.setAppend(output);
    }

    public void serializeWrite(VectorizedRowBatch batch, int batchIndex) throws IOException {
        this.hasAnyNulls = false;
        this.isAllNulls = true;
        Field[] children = this.root.children;
        int size = this.root.count;
        for (int i = 0; i < size; ++i) {
            Field field = children[i];
            ColumnVector colVector = batch.cols[field.outputColumnNum];
            this.serializeWrite(colVector, field, batchIndex);
        }
    }

    private void serializeWrite(ColumnVector colVector, Field field, int batchIndex) throws IOException {
        int adjustedBatchIndex = colVector.isRepeating ? 0 : batchIndex;
        if (!colVector.noNulls && colVector.isNull[adjustedBatchIndex]) {
            this.serializeWrite.writeNull();
            this.hasAnyNulls = true;
            return;
        }
        this.isAllNulls = false;
        if (field.isPrimitive) {
            this.serializePrimitiveWrite(colVector, field, adjustedBatchIndex);
            return;
        }
        ObjectInspector.Category category = field.category;
        switch (category) {
            case LIST: {
                this.serializeListWrite((ListColumnVector)colVector, field, adjustedBatchIndex);
                break;
            }
            case MAP: {
                this.serializeMapWrite((MapColumnVector)colVector, field, adjustedBatchIndex);
                break;
            }
            case STRUCT: {
                this.serializeStructWrite((StructColumnVector)colVector, field, adjustedBatchIndex);
                break;
            }
            case UNION: {
                this.serializeUnionWrite((UnionColumnVector)colVector, field, adjustedBatchIndex);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected category " + (Object)((Object)category));
            }
        }
    }

    private void serializeUnionWrite(UnionColumnVector colVector, Field field, int adjustedBatchIndex) throws IOException {
        UnionTypeInfo typeInfo = (UnionTypeInfo)field.typeInfo;
        UnionObjectInspector objectInspector = (UnionObjectInspector)field.objectInspector;
        byte tag = (byte)colVector.tags[adjustedBatchIndex];
        ColumnVector fieldColumnVector = colVector.fields[tag];
        Field childField = field.children[tag];
        this.serializeWrite.beginUnion(tag);
        this.serializeWrite(fieldColumnVector, childField, adjustedBatchIndex);
        this.serializeWrite.finishUnion();
    }

    private void serializeStructWrite(StructColumnVector colVector, Field field, int adjustedBatchIndex) throws IOException {
        StructTypeInfo typeInfo = (StructTypeInfo)field.typeInfo;
        StructObjectInspector objectInspector = (StructObjectInspector)field.objectInspector;
        ColumnVector[] fieldColumnVectors = colVector.fields;
        Field[] children = field.children;
        List<? extends StructField> structFields = objectInspector.getAllStructFieldRefs();
        int size = field.count;
        List list = (List)this.vectorExtractRow.extractRowColumn(colVector, typeInfo, objectInspector, adjustedBatchIndex);
        this.serializeWrite.beginStruct(list);
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                this.serializeWrite.separateStruct();
            }
            this.serializeWrite(fieldColumnVectors[i], children[i], adjustedBatchIndex);
        }
        this.serializeWrite.finishStruct();
    }

    private void serializeMapWrite(MapColumnVector colVector, Field field, int adjustedBatchIndex) throws IOException {
        MapTypeInfo typeInfo = (MapTypeInfo)field.typeInfo;
        MapObjectInspector objectInspector = (MapObjectInspector)field.objectInspector;
        ColumnVector keyColumnVector = colVector.keys;
        ColumnVector valueColumnVector = colVector.values;
        Field keyField = field.children[0];
        Field valueField = field.children[1];
        int offset = (int)colVector.offsets[adjustedBatchIndex];
        int size = (int)colVector.lengths[adjustedBatchIndex];
        Map map = (Map)this.vectorExtractRow.extractRowColumn(colVector, typeInfo, objectInspector, adjustedBatchIndex);
        this.serializeWrite.beginMap(map);
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                this.serializeWrite.separateKeyValuePair();
            }
            this.serializeWrite(keyColumnVector, keyField, offset + i);
            this.serializeWrite.separateKey();
            this.serializeWrite(valueColumnVector, valueField, offset + i);
        }
        this.serializeWrite.finishMap();
    }

    private void serializeListWrite(ListColumnVector colVector, Field field, int adjustedBatchIndex) throws IOException {
        ListTypeInfo typeInfo = (ListTypeInfo)field.typeInfo;
        ListObjectInspector objectInspector = (ListObjectInspector)field.objectInspector;
        ColumnVector childColumnVector = colVector.child;
        Field elementField = field.children[0];
        int offset = (int)colVector.offsets[adjustedBatchIndex];
        int size = (int)colVector.lengths[adjustedBatchIndex];
        ObjectInspector elementObjectInspector = objectInspector.getListElementObjectInspector();
        List list = (List)this.vectorExtractRow.extractRowColumn(colVector, typeInfo, objectInspector, adjustedBatchIndex);
        this.serializeWrite.beginList(list);
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                this.serializeWrite.separateList();
            }
            this.serializeWrite(childColumnVector, elementField, offset + i);
        }
        this.serializeWrite.finishList();
    }

    private void serializePrimitiveWrite(ColumnVector colVector, Field field, int adjustedBatchIndex) throws IOException {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = field.primitiveCategory;
        switch (primitiveCategory) {
            case BOOLEAN: {
                this.serializeWrite.writeBoolean(((LongColumnVector)colVector).vector[adjustedBatchIndex] != 0L);
                break;
            }
            case BYTE: {
                this.serializeWrite.writeByte((byte)((LongColumnVector)colVector).vector[adjustedBatchIndex]);
                break;
            }
            case SHORT: {
                this.serializeWrite.writeShort((short)((LongColumnVector)colVector).vector[adjustedBatchIndex]);
                break;
            }
            case INT: {
                this.serializeWrite.writeInt((int)((LongColumnVector)colVector).vector[adjustedBatchIndex]);
                break;
            }
            case LONG: {
                this.serializeWrite.writeLong(((LongColumnVector)colVector).vector[adjustedBatchIndex]);
                break;
            }
            case DATE: {
                this.serializeWrite.writeDate((int)((LongColumnVector)colVector).vector[adjustedBatchIndex]);
                break;
            }
            case TIMESTAMP: {
                Timestamp ts = ((TimestampColumnVector)colVector).asScratchTimestamp(adjustedBatchIndex);
                org.apache.hadoop.hive.common.type.Timestamp serializableTS = org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli(ts.getTime(), ts.getNanos());
                this.serializeWrite.writeTimestamp(serializableTS);
                break;
            }
            case FLOAT: {
                this.serializeWrite.writeFloat((float)((DoubleColumnVector)colVector).vector[adjustedBatchIndex]);
                break;
            }
            case DOUBLE: {
                this.serializeWrite.writeDouble(((DoubleColumnVector)colVector).vector[adjustedBatchIndex]);
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                BytesColumnVector bytesColVector = (BytesColumnVector)colVector;
                this.serializeWrite.writeString(bytesColVector.vector[adjustedBatchIndex], bytesColVector.start[adjustedBatchIndex], bytesColVector.length[adjustedBatchIndex]);
                break;
            }
            case BINARY: {
                BytesColumnVector bytesColVector = (BytesColumnVector)colVector;
                this.serializeWrite.writeBinary(bytesColVector.vector[adjustedBatchIndex], bytesColVector.start[adjustedBatchIndex], bytesColVector.length[adjustedBatchIndex]);
                break;
            }
            case DECIMAL: {
                if (colVector instanceof Decimal64ColumnVector) {
                    Decimal64ColumnVector decimal64ColVector = (Decimal64ColumnVector)colVector;
                    this.serializeWrite.writeDecimal64(decimal64ColVector.vector[adjustedBatchIndex], decimal64ColVector.scale);
                    break;
                }
                DecimalColumnVector decimalColVector = (DecimalColumnVector)colVector;
                this.serializeWrite.writeHiveDecimal(decimalColVector.vector[adjustedBatchIndex], (int)decimalColVector.scale);
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                this.serializeWrite.writeHiveIntervalYearMonth((int)((LongColumnVector)colVector).vector[adjustedBatchIndex]);
                break;
            }
            case INTERVAL_DAY_TIME: {
                this.serializeWrite.writeHiveIntervalDayTime(((IntervalDayTimeColumnVector)colVector).asScratchIntervalDayTime(adjustedBatchIndex));
                break;
            }
            default: {
                throw new RuntimeException("Unexpected primitive category " + (Object)((Object)primitiveCategory));
            }
        }
    }

    public boolean getHasAnyNulls() {
        return this.hasAnyNulls;
    }

    public boolean getIsAllNulls() {
        return this.isAllNulls;
    }

    private static class Field {
        Field[] children = null;
        boolean isPrimitive = false;
        ObjectInspector.Category category = null;
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = null;
        TypeInfo typeInfo = null;
        int count = 0;
        ObjectInspector objectInspector = null;
        int outputColumnNum = -1;

        Field() {
        }
    }
}

