/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache;

import com.splunk.io.SearchMetricsReporter;
import com.splunk.mr.cache.integration.SplitMetadata;
import com.splunk.util.Lazy;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.MD5Hash;
import org.apache.log4j.Logger;

public class JobQueue {
    public static final String JOB_SUFFIX = ".job";
    private static final String DATA_DELIMITER = "-";
    private static final int PATH_ENCODING_VERSION = 1;
    private static final Logger gLogger = Logger.getLogger(JobQueue.class);
    private final FileSystem fileSystem;
    private final Path queueDir;
    private final SearchMetricsReporter metrics;
    private final PathEncoding pathEncoding;
    private Map<MD5Hash, FileStatus> listedJobsCache;

    public JobQueue(FileSystem fileSystem, Path queueDir) {
        this(fileSystem, queueDir, null);
    }

    public JobQueue(FileSystem fileSystem, Path queueDir, SearchMetricsReporter metrics) {
        this.fileSystem = fileSystem;
        this.queueDir = queueDir;
        this.metrics = metrics;
        this.pathEncoding = PathEncoding.getInstance(fileSystem, queueDir);
    }

    PathEncoding getPathEncoding() {
        return this.pathEncoding;
    }

    public boolean hasResult(MD5Hash hash, boolean useCache) throws IOException {
        Map<MD5Hash, FileStatus> listedJobs = this.getListedJobs(useCache);
        return listedJobs.containsKey(hash);
    }

    public void put(MD5Hash hash, Path resultFile, SplitMetadata splitMetadata) throws IOException {
        Path jobPath = this.pathEncoding.getRealJobPath(hash, splitMetadata);
        if (this.fileSystem.exists(jobPath) && !this.fileSystem.delete(jobPath, false)) {
            throw new IOException("Could not remove existing result file, path=" + jobPath);
        }
        boolean renamed = this.fileSystem.rename(resultFile, jobPath);
        if (!renamed) {
            throw new IOException("Could not put result file in cache queue. File: " + resultFile + ", cache path: " + jobPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(MD5Hash hash, InputStream results, SplitMetadata meta) throws IOException {
        Path uniqueTempPath = this.pathEncoding.getUniqueTempJobPath(hash);
        try {
            this.writeToPath(uniqueTempPath, results);
            this.fileSystem.rename(uniqueTempPath, this.pathEncoding.getRealJobPath(hash, meta));
        }
        finally {
            this.fileSystem.delete(uniqueTempPath, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeToPath(Path path, InputStream results) throws IOException {
        long l;
        FSDataOutputStream out = null;
        try {
            out = this.fileSystem.create(path, true);
            l = IOUtils.copyLarge((InputStream)results, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
        return l;
    }

    public CacheJob getQueuedResult(MD5Hash hash) throws IOException {
        CacheJob job = this.getJob(hash, true);
        if (job != null) {
            return job;
        }
        return null;
    }

    public CacheJob getJob(MD5Hash hash) throws IOException {
        return this.getJob(hash, false);
    }

    public CacheJob getJob(MD5Hash hash, boolean useCache) throws IOException {
        Map<MD5Hash, FileStatus> listedJobs = this.getListedJobs(useCache);
        if (listedJobs.containsKey(hash)) {
            return this.createCacheJob(listedJobs.get(hash));
        }
        return null;
    }

    private Map<MD5Hash, FileStatus> getListedJobs(boolean cached) throws IOException {
        if (cached && this.listedJobsCache != null) {
            return this.listedJobsCache;
        }
        HashMap<MD5Hash, FileStatus> listedJobs = new HashMap<MD5Hash, FileStatus>();
        for (FileStatus fs : this.listFileSystemJobs()) {
            listedJobs.put(this.pathEncoding.getHash(fs), fs);
        }
        if (cached) {
            this.listedJobsCache = listedJobs;
        }
        return listedJobs;
    }

    private CacheJob createCacheJob(FileStatus jobFileStatus) throws IOException {
        return this.pathEncoding.createCacheJob(jobFileStatus);
    }

    public List<CacheJob> listJobs() throws IOException {
        FileStatus[] listStatus = this.listFileSystemJobs();
        ArrayList<CacheJob> jobs = new ArrayList<CacheJob>();
        for (FileStatus fs : listStatus) {
            try {
                jobs.add(this.createCacheJob(fs));
            }
            catch (Exception e) {
                gLogger.debug((Object)("Could not parse cache job. Possibly an old temp cache file from a different hunk version. Deleting the temp file. path=" + fs.getPath()));
                this.fileSystem.delete(fs.getPath(), true);
            }
        }
        return jobs;
    }

    private FileStatus[] listFileSystemJobs() throws IOException {
        long now = System.currentTimeMillis();
        FileStatus[] listed = this.doListFileSystemJobs();
        if (this.metrics != null) {
            String metricName = "cache.list.queue";
            this.metrics.addMetric(metricName, System.currentTimeMillis() - now, 1L);
            this.metrics.addCountMetric(metricName, 0L, listed.length);
        }
        return listed;
    }

    private FileStatus[] doListFileSystemJobs() throws IOException {
        return this.fileSystem.listStatus(this.queueDir, new PathFilter(){

            public boolean accept(Path p) {
                return p.toUri().getPath().endsWith(JobQueue.JOB_SUFFIX);
            }
        });
    }

    public void clearCache() {
        this.listedJobsCache = null;
    }

    public static abstract class PathEncoding {
        private static final String VERSION_DELIMITER = "_";
        protected final int version;
        protected final Path root;

        protected PathEncoding(int version, Path root) {
            this.version = version;
            this.root = root;
        }

        public Path getRealJobPath(MD5Hash hash, SplitMetadata meta) {
            return new Path(this.root, this.version + VERSION_DELIMITER + this.getRealJobFilename(hash, meta));
        }

        public Path getUniqueTempJobPath(MD5Hash hash) {
            return new Path(this.root, this.version + VERSION_DELIMITER + this.getUniqueTempJobFilename(hash));
        }

        @Deprecated
        public MD5Hash getHash(FileStatus fs) {
            return this.getHash(this.getFilenameWithoutVersion(fs));
        }

        public CacheJob createCacheJob(FileStatus jobFileStatus) {
            return this.createCacheJob(jobFileStatus, this.getFilenameWithoutVersion(jobFileStatus));
        }

        private String getFilenameWithoutVersion(FileStatus jobFileStatus) {
            return StringUtils.substringAfter((String)jobFileStatus.getPath().getName(), (String)VERSION_DELIMITER);
        }

        @Deprecated
        protected abstract MD5Hash getHash(String var1);

        protected abstract String getRealJobFilename(MD5Hash var1, SplitMetadata var2);

        protected abstract String getUniqueTempJobFilename(MD5Hash var1);

        protected abstract CacheJob createCacheJob(FileStatus var1, String var2);

        private static PathEncoding getInstance(FileSystem fs, Path root) {
            switch (1) {
                case 1: {
                    return new PathEncodingV1(fs, root);
                }
            }
            throw new RuntimeException("No PathEncoding instance for version: 1");
        }

        public static Lazy<InputStream> createLazyInputStream(final FileSystem fs, final Path realJobPath) {
            return new Lazy<InputStream>(){

                @Override
                public InputStream get() throws IOException {
                    return fs.open(realJobPath);
                }
            };
        }

        private static class PathEncodingV1
        extends PathEncoding {
            private static final String KEY_VALUE_SEPARATOR = ".";
            private static final int VERSION = 1;
            private final FileSystem fs;

            public PathEncodingV1(FileSystem fs, Path root) {
                super(1, root);
                this.fs = fs;
            }

            @Override
            protected CacheJob createCacheJob(FileStatus jobFileStatus, String filename) {
                Path path = jobFileStatus.getPath();
                String[] split = filename.split(JobQueue.DATA_DELIMITER);
                if (split.length > 3) {
                    HashMap<String, Object> meta = new HashMap<String, Object>();
                    meta.put("lt", new Date(Long.parseLong(this.detach(split[1]))));
                    meta.put("et", new Date(Long.parseLong(this.detach(split[2]))));
                    meta.put("size", Long.parseLong(this.detach(split[3])));
                    return new CacheJob(new MD5Hash(this.detach(split[0])), PathEncodingV1.createLazyInputStream(this.fs, path), path, jobFileStatus.getLen(), meta);
                }
                throw new RuntimeException("Found cache temp job with invalid filename for encoding version: " + this.version + ". Ignoring cache filename=" + filename);
            }

            private String detach(String s) {
                return StringUtils.substringAfter((String)s, (String)KEY_VALUE_SEPARATOR);
            }

            @Override
            protected String getRealJobFilename(MD5Hash hash, SplitMetadata meta) {
                return this.getJobPath(JobQueue.DATA_DELIMITER, JobQueue.JOB_SUFFIX, "hash." + hash.toString(), "lt." + String.valueOf(meta.getLatestTime().getTime()), "et." + String.valueOf(meta.getEarliestTime().getTime()), "size." + String.valueOf(meta.getSplitSize()));
            }

            @Override
            public String getUniqueTempJobFilename(MD5Hash hash) {
                return this.getJobPath(JobQueue.DATA_DELIMITER, ".tmp", hash.toString(), UUID.randomUUID().toString());
            }

            private String getJobPath(String delim, String suffix, String ... values) {
                return StringUtils.join((Object[])values, (String)delim) + delim + suffix;
            }

            @Override
            protected MD5Hash getHash(String filename) {
                String[] split = filename.split(JobQueue.DATA_DELIMITER);
                return new MD5Hash(this.detach(split[0]));
            }
        }
    }

    public static class CacheJob
    implements Closeable {
        public final MD5Hash hash;
        private final String path;
        public final Lazy<InputStream> lazyResults;
        private InputStream results;
        public final long length;
        private Map<String, Object> meta;

        public CacheJob(MD5Hash hash, Lazy<InputStream> lazyResults, Path path, long length, Map<String, Object> meta) {
            this.hash = hash;
            this.lazyResults = lazyResults;
            this.path = path != null ? path.toUri().getPath() : null;
            this.length = length;
            this.meta = meta;
        }

        public InputStream openResults() throws IOException {
            this.results = this.lazyResults.get();
            return this.results;
        }

        @Override
        public void close() {
            IOUtils.closeQuietly((InputStream)this.results);
        }

        public Path getPath() {
            return new Path(this.path);
        }

        public Date getSplitLatestTime() {
            return (Date)this.meta.get("lt");
        }

        public Date getSplitEarliestTime() {
            return (Date)this.meta.get("et");
        }

        public long getSplitSize() {
            return (Long)this.meta.get("size");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.hash == null ? 0 : this.hash.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheJob other = (CacheJob)obj;
            return !(this.hash == null ? other.hash != null : !this.hash.equals((Object)other.hash));
        }
    }
}

