/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.splunk.aws.AWSChecker;
import com.splunk.aws.EMR;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.input.VirtualIndex;
import com.splunk.sdk.SplunkMiniSDK;
import com.splunk.util.FileBasedCache;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.MD5Hash;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.MissingNode;

public class SearchController
extends Thread {
    private static Logger gLogger = Logger.getLogger(SearchController.class);
    private static final long CACHE_TTL = 600000L;
    private static final String EMROEM_MSG_PREFIX = "EMR OEM License: ";
    private String _stopMessage = null;
    private Configuration _conf = null;
    private File _searchDispatchDir = null;
    private FileBasedCache _cache;
    private SplunkMiniSDK _sdk;
    private volatile int _hadoopNodes = -1;
    private boolean _checkedHadoopNodes = false;
    private JsonNode _hadoopLic = null;
    private Object hadoopLicLock = new Object();
    private static volatile SearchController _instance = null;

    private SearchController(Configuration conf) {
        this._conf = new Configuration(conf);
        this._searchDispatchDir = SplunkMR.getSearchDispatchDir(this._conf);
        this._cache = new FileBasedCache(new File(SplunkMR.getSHSplunkHome(this._conf), "/var/run/splunk/hunk/aws/emr/"), ".sc-cache", 600000L);
        Map<String, Object> info = VirtualIndex.getSearchInfo(this._conf);
        try {
            this._sdk = new SplunkMiniSDK(new URI(String.valueOf(info.get("_splunkd_uri"))), String.valueOf(info.get("_auth_token")));
        }
        catch (URISyntaxException e) {
            gLogger.warn((Object)e.getMessage());
        }
        this.setName("SearchController");
        this.setDaemon(true);
        this.start();
    }

    public void setHadoopNodeCount(int count) {
        this._hadoopNodes = count;
    }

    public boolean shouldStop() {
        return this.getStopReason() != null;
    }

    public synchronized String getStopReason() {
        return this._stopMessage;
    }

    private synchronized void setStopReasonAndThrow(String msg) {
        this.setStopReason(msg);
        throw new RuntimeException(this._stopMessage);
    }

    private synchronized void setStopReason(String msg) {
        this._stopMessage = msg;
    }

    public static File getAliveTokenFile(File searchDispatchDir) {
        return new File(searchDispatchDir, "alive.token");
    }

    public boolean allowHunkSearching() {
        return !this.getHadoopERPLicense().isMissingNode();
    }

    private boolean stopOnDispatchFileExistance(String fname) {
        File f = new File(this._searchDispatchDir, fname);
        if (f.exists() && fname == "finalize") {
            gLogger.info((Object)("Parent search is done. Found file: " + f));
            this.setStopReason("search_finalized");
            return true;
        }
        if (f.exists()) {
            this.setStopReasonAndThrow("Parent search is done. Found file: " + f);
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        try {
            this.runImpl();
        }
        catch (Throwable ex) {
            this.setStopReason(ex.getMessage());
            gLogger.error((Object)ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runImpl() {
        this.checkEMROEMLicense();
        this.checkEMRClusterState();
        while (this._stopMessage == null) {
            this.stopOnMaxHadoopNodesExceedingLicense();
            this.stopOnDispatchFileExistance("cancel");
            this.stopOnDispatchFileExistance("finalize");
            this.stopOnDispatchFileExistance("audited");
            if (!SearchController.getAliveTokenFile(this._searchDispatchDir).exists()) {
                this.setStopReasonAndThrow("Parent search is done. Alive token file does not exist: " + new File(this._searchDispatchDir, "alive.token"));
            }
            if (!this._searchDispatchDir.exists()) {
                this.setStopReasonAndThrow("Parent search is done. Dispatch dir does not exist: " + this._searchDispatchDir);
            }
            try {
                SearchController searchController = this;
                synchronized (searchController) {
                    this.wait(10000L);
                }
            }
            catch (InterruptedException e) {
                gLogger.info((Object)"thread interrupted, SearchController will stop", (Throwable)e);
                break;
            }
        }
    }

    private String getJTOrRM(Configuration conf) {
        if ("yarn".equals(conf.get("mapreduce.framework.name"))) {
            return conf.get("yarn.resourcemanager.address", "");
        }
        return conf.get("mapred.job.tracker", "");
    }

    private void stopOnMaxHadoopNodesExceedingLicense() {
        gLogger.debug((Object)"stopOnMaxHadoopNodesExceedingLicense ...");
        if (this._hadoopNodes < 0 || this._checkedHadoopNodes) {
            return;
        }
        this._checkedHadoopNodes = true;
        JsonNode enforceMaxNodes = this.getHadoopERPLicense().path("parameters").path("enforce_max_nodes");
        if (enforceMaxNodes.isMissingNode()) {
            try {
                int maxNodes = Integer.parseInt(enforceMaxNodes.getTextValue());
                if (maxNodes < this._hadoopNodes) {
                    this.setStopReasonAndThrow(String.format("Number of nodes=%d for provider=%s, exceeds the maximum number of nodes allowed by the license, max_nodes=%d. Please contact your sales representative.", this._hadoopNodes, this._conf.get(SplunkMR.CONF_PROVIDER), maxNodes));
                } else {
                    gLogger.debug((Object)("Number of nodes=" + this._hadoopNodes + " is less than max=" + maxNodes));
                }
            }
            catch (NumberFormatException e) {
                gLogger.warn((Object)("Could not parse enforce_max_nodes=" + enforceMaxNodes.getTextValue()));
            }
        }
    }

    private void setEMROEMStopReasonAndCache(String key, String msg) {
        this.setStopReasonAndThrow(EMROEM_MSG_PREFIX + msg);
        this._cache.put(key, (Serializable)((Object)msg));
    }

    private void checkEMRClusterState() {
        if ("down".equalsIgnoreCase(this._conf.get("splunk.emr.cluster.state"))) {
            String provider = this._conf.get(SplunkMR.CONF_PROVIDER);
            String clusterId = this._conf.get("splunk.emr.cluster.id", null);
            this.setStopReasonAndThrow("EMR cluster for provider=" + provider + " is not currently running (cluster.id=" + clusterId + ", state=down). Please restart the cluster, or wait a few moments for Hunk to recognize it's new state, then try the search again.");
        }
    }

    private boolean isEMROEMLicense() {
        String key = "e1m9r-2o8e3m-7l5i6c-9c0h3e2c1k";
        Object val = this._cache.get(key);
        if (val == null) {
            val = "false";
            try {
                JsonNode hadoop = this.getHadoopERPLicense();
                if (!hadoop.path("parameters").path("emr_oem").isMissingNode()) {
                    gLogger.debug((Object)"found emr_oem license flag");
                    val = "true";
                }
                this._cache.put(key, (Serializable)val);
            }
            catch (Exception e) {
                gLogger.warn((Object)"Error while inspecting license", (Throwable)e);
            }
        }
        return "true".equals(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode getHadoopERPLicense() {
        Object object = this.hadoopLicLock;
        synchronized (object) {
            if (this._hadoopLic == null) {
                try {
                    JsonNode licEntry = this._sdk.get("/services/server/info", new String[0]).firstEntry();
                    this._hadoopLic = licEntry.path("content").path("addOns").path("hadoop");
                }
                catch (Exception e) {
                    gLogger.warn((Object)("Failed to get license:" + e.getMessage()));
                    this._hadoopLic = MissingNode.getInstance();
                }
            }
            return this._hadoopLic;
        }
    }

    private void checkEMROEMLicense() {
        String key = this.getJTOrRM(this._conf);
        long digest = MD5Hash.digest((String)key).halfDigest();
        Object msg = this._cache.get(key);
        if (msg != null) {
            if (String.valueOf(digest).equals(msg)) {
                return;
            }
            this.setStopReasonAndThrow(String.valueOf(msg));
            return;
        }
        if (!this.isEMROEMLicense()) {
            return;
        }
        if (!AWSChecker.isAws()) {
            this.setEMROEMStopReasonAndCache(key, "execution environment is not AWS");
            return;
        }
        if (!"report".equals(this._conf.get("splunk.provider.mode"))) {
            return;
        }
        String provider = this._conf.get(SplunkMR.CONF_PROVIDER);
        String clusterId = this._conf.get("splunk.emr.cluster.id", null);
        String regionName = this._conf.get("splunk.emr.cluster.region", null);
        if (clusterId == null || clusterId.trim().isEmpty()) {
            this.setEMROEMStopReasonAndCache(key, "missing vix.splunk.emr.cluster.id in virtual index provider name=" + provider);
            return;
        }
        if (regionName == null || regionName.trim().isEmpty()) {
            this.setEMROEMStopReasonAndCache(key, "missing vix.splunk.emr.cluster.region in virtual index provider, name=" + provider);
            return;
        }
        ClientConfiguration cc = new ClientConfiguration();
        cc.setRetryPolicy(PredefinedRetryPolicies.getDefaultRetryPolicyWithCustomMaxRetries((int)10));
        EMR emr = new EMR(cc);
        emr.setRegion(regionName);
        EMR.EMRClusterDescription ecd = null;
        try {
            ecd = emr.getClusterDetails(clusterId);
        }
        catch (Exception e) {
            this.setEMROEMStopReasonAndCache(key, "failed to get EMR cluster details. Virtual index provider details: name=" + provider + ", cluster_id=" + clusterId + ", region=" + regionName + ", error=" + e.getMessage());
            return;
        }
        if (ecd == null) {
            this.setEMROEMStopReasonAndCache(key, "cannot find EMR cluster. Virtual index provider details: name=" + provider + ", cluster_id=" + clusterId + ", region=" + regionName);
            return;
        }
        if (!ecd.hunkable) {
            this.setEMROEMStopReasonAndCache(key, "cluster is not configured to run Hunk. Virtual index provider details: name=" + provider + ", cluster_id=" + clusterId + ", region=" + regionName);
            return;
        }
        this._cache.put(key, (Serializable)((Object)String.valueOf(digest)));
    }

    public static synchronized SearchController init(Configuration conf) {
        if (_instance == null) {
            _instance = new SearchController(conf);
        }
        return _instance;
    }

    public static synchronized SearchController instance() {
        if (_instance == null) {
            gLogger.warn((Object)"SearchController.init() needs to be called before SearchController.instance()");
        }
        return _instance;
    }

    public static synchronized void clear() {
        if (_instance != null) {
            _instance.setStopReason("cleaning up");
            _instance = null;
        }
    }
}

