/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.collect;

import com.splunk.collect.EventWriter;
import com.splunk.collect.IndexProcessor;
import com.splunk.s2s.Channel;
import com.splunk.s2s.Event;
import com.splunk.s2s.S2SListener;
import com.splunk.s2s.S2SString;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class IndexS2SListener
implements S2SListener {
    private static Logger gLogger = Logger.getLogger(IndexS2SListener.class);
    private static int nextId = 0;
    private int id = nextId++;
    protected ConcurrentHashMap<S2SString, IndexProcessor> _indexToWriter = new ConcurrentHashMap();
    protected IndexProcessor _catchAllProcessor = null;

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("IndexS2SListener{id=").append(this.id);
        buff.append(", indexes=");
        boolean first = true;
        for (S2SString idxName : this._indexToWriter.keySet()) {
            if (first) {
                first = false;
            } else {
                buff.append(", ");
            }
            buff.append(idxName);
        }
        buff.append("}");
        return buff.toString();
    }

    public void addCatchAllProcessor(IndexProcessor processor) {
        this._catchAllProcessor = processor;
    }

    public void addIndex(IndexProcessor ip) {
        S2SString idx = new S2SString(ip.getName());
        if (this._indexToWriter.putIfAbsent(idx, ip) != null) {
            throw new IllegalStateException("An EventWriter is already registered for index=" + ip.getName());
        }
    }

    public List<S2SString> getIndexes() {
        ArrayList<S2SString> indexes = new ArrayList<S2SString>();
        for (S2SString ip : this._indexToWriter.keySet()) {
            indexes.add(ip);
        }
        return indexes;
    }

    @Override
    public void begin() {
    }

    @Override
    public void finish() {
        for (IndexProcessor ip : this._indexToWriter.values()) {
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("Closing IndexProcessor for " + ip.getName()));
            }
            IOUtils.closeQuietly((Closeable)ip);
        }
        for (IndexProcessor ip : this._indexToWriter.values()) {
            try {
                if (gLogger.isDebugEnabled()) {
                    gLogger.debug((Object)("Joining thread for " + ip.getName()));
                }
                ip.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (null != this._catchAllProcessor) {
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("Closing 'catch-all' IndexProcessor, name=" + this._catchAllProcessor.getName()));
            }
            IOUtils.closeQuietly((Closeable)this._catchAllProcessor);
            try {
                if (gLogger.isDebugEnabled()) {
                    gLogger.debug((Object)("Joining thread for 'catch-all' IndexProcessor, name=" + this._catchAllProcessor.getName()));
                }
                this._catchAllProcessor.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void gotDropChannel(Channel c) {
        for (EventWriter eventWriter : this._indexToWriter.values()) {
            eventWriter.gotDropChannel(c);
        }
        if (null != this._catchAllProcessor) {
            this._catchAllProcessor.gotDropChannel(c);
        }
    }

    @Override
    public void gotEvent(Event e) {
        S2SString index = e.getIndex();
        EventWriter ew = this._indexToWriter.get(index);
        if (ew != null) {
            try {
                ew.addEvent(e);
            }
            catch (IOException ex) {
                gLogger.error((Object)("Error while writing event to index=" + index), (Throwable)ex);
            }
        } else {
            try {
                if (null != this._catchAllProcessor) {
                    this._catchAllProcessor.addEvent(e);
                }
            }
            catch (IOException ex) {
                gLogger.error((Object)"Error while writing event to catch-all processor", (Throwable)ex);
            }
        }
    }

    @Override
    public void gotAck(long start, long end) {
    }

    @Override
    public void gotChannel(Channel c) {
    }

    @Override
    public void gotTimezone(byte[] tzinfo) {
    }

    @Override
    public void gotControlEvent(Event e) {
    }
}

