/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codepipeline.model.ActionConfiguration;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class ActionConfigurationJsonMarshaller {
    private static ActionConfigurationJsonMarshaller instance;

    public void marshall(ActionConfiguration actionConfiguration, JSONWriter jsonWriter) {
        if (actionConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            Map<String, String> configurationMap = actionConfiguration.getConfiguration();
            if (configurationMap != null) {
                jsonWriter.key("configuration");
                jsonWriter.object();
                for (Map.Entry<String, String> configurationMapValue : configurationMap.entrySet()) {
                    if (configurationMapValue.getValue() == null) continue;
                    jsonWriter.key(configurationMapValue.getKey());
                    jsonWriter.value(configurationMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ActionConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ActionConfigurationJsonMarshaller();
        }
        return instance;
    }
}

