/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.Text;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;

@Description(name="get_json_object", value="_FUNC_(json_txt, path) - Extract a json object from path ", extended="Extract json object from a json string based on json path specified, and return json string of the extracted json object. It will return null if the input json string is invalid.\nA limited version of JSONPath supported:\n  $   : Root object\n  .   : Child operator\n  []  : Subscript operator for array\n  *   : Wildcard for []\nSyntax not supported that's worth noticing:\n  ''  : Zero length string as key\n  ..  : Recursive descent\n  &amp;#064;   : Current object/element\n  ()  : Script expression\n  ?() : Filter (script) expression.\n  [,] : Union operator\n  [start:end:step] : array slice operator\n")
public class UDFJson
extends UDF {
    private final Pattern patternKey = Pattern.compile("^([a-zA-Z0-9_\\-\\:\\s]+).*");
    private final Pattern patternIndex = Pattern.compile("\\[([0-9]+|\\*)\\]");
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final ObjectMapper MAPPER;
    private static final JavaType MAP_TYPE;
    static Map<String, Object> extractObjectCache;
    static Map<String, String[]> pathExprCache;
    static Map<String, ArrayList<String>> indexListCache;
    static Map<String, String> mKeyGroup1Cache;
    static Map<String, Boolean> mKeyMatchesCache;
    Text result = new Text();
    List<Object> jsonList = new ArrayList<Object>();

    public Text evaluate(String jsonString, String pathString) {
        if (jsonString == null || jsonString == "" || pathString == null || pathString == "") {
            return null;
        }
        String[] pathExpr = pathExprCache.get(pathString);
        if (pathExpr == null) {
            pathExpr = pathString.split("\\.", -1);
            pathExprCache.put(pathString, pathExpr);
        }
        if (!pathExpr[0].equalsIgnoreCase("$")) {
            return null;
        }
        Object extractObject = extractObjectCache.get(jsonString);
        if (extractObject == null) {
            try {
                extractObject = MAPPER.readValue(jsonString, MAP_TYPE);
            }
            catch (Exception e) {
                return null;
            }
            extractObjectCache.put(jsonString, extractObject);
        }
        for (int i = 1; i < pathExpr.length; ++i) {
            if (extractObject == null) {
                return null;
            }
            extractObject = this.extract(extractObject, pathExpr[i]);
        }
        if (extractObject instanceof Map || extractObject instanceof List) {
            try {
                this.result.set(MAPPER.writeValueAsString(extractObject));
            }
            catch (Exception e) {
                return null;
            }
        } else if (extractObject != null) {
            this.result.set(extractObject.toString());
        } else {
            return null;
        }
        return this.result;
    }

    private Object extract(Object json, String path) {
        Matcher mKey = null;
        Boolean mKeyMatches = mKeyMatchesCache.get(path);
        if (mKeyMatches == null) {
            mKey = this.patternKey.matcher(path);
            mKeyMatches = mKey.matches() ? Boolean.TRUE : Boolean.FALSE;
            mKeyMatchesCache.put(path, mKeyMatches);
        }
        if (!mKeyMatches.booleanValue()) {
            return null;
        }
        String mKeyGroup1 = mKeyGroup1Cache.get(path);
        if (mKeyGroup1 == null) {
            if (mKey == null) {
                mKey = this.patternKey.matcher(path);
            }
            mKeyGroup1 = mKey.group(1);
            mKeyGroup1Cache.put(path, mKeyGroup1);
        }
        json = this.extract_json_withkey(json, mKeyGroup1);
        ArrayList<String> indexList = indexListCache.get(path);
        if (indexList == null) {
            Matcher mIndex = this.patternIndex.matcher(path);
            indexList = new ArrayList();
            while (mIndex.find()) {
                indexList.add(mIndex.group(1));
            }
            indexListCache.put(path, indexList);
        }
        if (indexList.size() > 0) {
            json = this.extract_json_withindex(json, indexList);
        }
        return json;
    }

    private Object extract_json_withindex(Object json, ArrayList<String> indexList) {
        this.jsonList.clear();
        this.jsonList.add(json);
        for (String index : indexList) {
            Object array;
            int i;
            ArrayList<Object> tmp_jsonList = new ArrayList<Object>();
            if (index.equalsIgnoreCase("*")) {
                for (i = 0; i < this.jsonList.size(); ++i) {
                    array = this.jsonList.get(i);
                    if (!(array instanceof List)) continue;
                    for (int j = 0; j < ((List)array).size(); ++j) {
                        tmp_jsonList.add(((List)array).get(j));
                    }
                }
                this.jsonList = tmp_jsonList;
                continue;
            }
            for (i = 0; i < this.jsonList.size(); ++i) {
                array = this.jsonList.get(i);
                int indexValue = Integer.parseInt(index);
                if (!(array instanceof List)) continue;
                if (indexValue >= ((List)array).size()) {
                    return null;
                }
                tmp_jsonList.add(((List)array).get(indexValue));
                this.jsonList = tmp_jsonList;
            }
        }
        if (this.jsonList.isEmpty()) {
            return null;
        }
        return this.jsonList.size() > 1 ? new ArrayList<Object>(this.jsonList) : this.jsonList.get(0);
    }

    private Object extract_json_withkey(Object json, String path) {
        if (json instanceof List) {
            ArrayList jsonArray = new ArrayList();
            for (int i = 0; i < ((List)json).size(); ++i) {
                Object json_elem = ((List)json).get(i);
                Object json_obj = null;
                if (!(json_elem instanceof Map)) continue;
                json_obj = ((Map)json_elem).get(path);
                if (json_obj instanceof List) {
                    for (int j = 0; j < ((List)json_obj).size(); ++j) {
                        jsonArray.add(((List)json_obj).get(j));
                    }
                    continue;
                }
                if (json_obj == null) continue;
                jsonArray.add(json_obj);
            }
            return jsonArray.size() == 0 ? null : jsonArray;
        }
        if (json instanceof Map) {
            return ((Map)json).get(path);
        }
        return null;
    }

    static {
        JSON_FACTORY.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
        MAPPER = new ObjectMapper(JSON_FACTORY);
        MAP_TYPE = TypeFactory.fromClass(Map.class);
        extractObjectCache = new HashCache<String, Object>();
        pathExprCache = new HashCache<String, String[]>();
        indexListCache = new HashCache<String, ArrayList<String>>();
        mKeyGroup1Cache = new HashCache<String, String>();
        mKeyMatchesCache = new HashCache<String, Boolean>();
    }

    static class HashCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final int CACHE_SIZE = 16;
        private static final int INIT_SIZE = 32;
        private static final float LOAD_FACTOR = 0.6f;
        private static final long serialVersionUID = 1L;

        HashCache() {
            super(32, 0.6f);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 16;
        }
    }
}

