/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.datasource.parquet;

import com.splunk.datasource.parquet.converter.Group;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.Type;

public class JsonWriteSupport
extends WriteSupport<Group> {
    private static Logger gLogger = Logger.getLogger(JsonWriteSupport.class);
    public static final String PARQUET_WRITE_SCHEMA = "splunk.parquet.write.schema";
    private MessageType schema;
    private RecordConsumer recordConsumer;

    public static void setSchema(MessageType schema, Configuration conf) {
        conf.set(PARQUET_WRITE_SCHEMA, schema.toString());
    }

    public static MessageType getSchema(Configuration conf) {
        return MessageTypeParser.parseMessageType((String)conf.get(PARQUET_WRITE_SCHEMA));
    }

    public JsonWriteSupport() {
    }

    public JsonWriteSupport(MessageType schema) {
        this.schema = schema;
    }

    public WriteSupport.WriteContext init(Configuration conf) {
        if (this.schema == null) {
            this.schema = JsonWriteSupport.getSchema(conf);
        }
        gLogger.info((Object)("schema=" + this.schema));
        return new WriteSupport.WriteContext(this.schema, new HashMap());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer = recordConsumer;
    }

    public void write(Group group) {
        this.recordConsumer.startMessage();
        this.writeGroup(group);
        this.recordConsumer.endMessage();
    }

    private void writeGroup(Group group) {
        GroupType type = group.getType();
        int fieldCount = type.getFieldCount();
        for (int fieldIndex = 0; fieldIndex < fieldCount; ++fieldIndex) {
            int valueCount = group.getFieldRepetitionCount(fieldIndex);
            if (valueCount <= 0) continue;
            Type fieldType = type.getType(fieldIndex);
            String fieldName = fieldType.getName();
            this.recordConsumer.startField(fieldName, fieldIndex);
            for (int elementIndex = 0; elementIndex < valueCount; ++elementIndex) {
                if (fieldType.isPrimitive()) {
                    group.writeValue(fieldIndex, elementIndex, this.recordConsumer);
                    continue;
                }
                this.recordConsumer.startGroup();
                this.writeGroup(group.getGroup(fieldIndex, elementIndex));
                this.recordConsumer.endGroup();
            }
            this.recordConsumer.endField(fieldName, fieldIndex);
        }
    }
}

