/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.aws;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class AWSChecker {
    private static Logger gLogger = Logger.getLogger(AWSChecker.class);
    private static AWSSTATE STATE = AWSSTATE.UNKOWN;
    private static String ZONE = null;

    public static String getZone() {
        return ZONE;
    }

    public static boolean isAws() {
        return STATE == AWSSTATE.UNKOWN ? AWSChecker.checkAndSetState() : STATE == AWSSTATE.YES;
    }

    private static boolean checkAndSetState() {
        if (STATE == AWSSTATE.UNKOWN) {
            InputStream in = null;
            try {
                URL metadataUrl = new URL("http://169.254.169.254/latest/meta-data/placement/availability-zone");
                URLConnection con = metadataUrl.openConnection();
                con.setConnectTimeout(200);
                con.setReadTimeout(200);
                in = con.getInputStream();
                ZONE = new BufferedReader(new InputStreamReader(in)).readLine();
                STATE = AWSSTATE.YES;
                IOUtils.closeQuietly((InputStream)in);
            }
            catch (Exception ignore) {
                STATE = AWSSTATE.NO;
            }
            finally {
                IOUtils.closeQuietly(in);
            }
            gLogger.debug((Object)("isAws=" + (Object)((Object)STATE) + ", zone=" + (ZONE == null ? "" : ZONE)));
        }
        return STATE == AWSSTATE.YES;
    }

    private static enum AWSSTATE {
        UNKOWN,
        YES,
        NO;

    }
}

