/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.commands.EvalCommand;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.commons.ast.nodes.commands.RenameCommand;
import com.splunk.commons.ast.nodes.commands.SortCommand;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.commons.visitors.CommandRebuilder;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.df.search.compute.spark.SparkDistributedDataset;
import com.splunk.df.util.DFSException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class SortFieldsValidationVisitor
extends CommandRebuilder {
    static final Logger logger = Logger.getLogger(SortFieldsValidationVisitor.class);
    public static final String NO_SORTABLE_FIELD = "Sort by field(s) do not exist!";
    private LinkedHashSet<String> knownSortableFields = new LinkedHashSet();

    private void reset() {
        this.knownSortableFields.clear();
    }

    public CommandNode visit(JoinCommand node) {
        String lhsAliasPrefix = SparkDistributedDataset.getAliasPrefix(node.getLhsAlias());
        String rhsAliasPrefix = SparkDistributedDataset.getAliasPrefix(node.getRhsAlias());
        boolean unknownSortablesInBranch = false;
        LinkedHashSet<String> sortableFields = new LinkedHashSet<String>();
        CommandNode[] visitedSources = new CommandNode[node.getSources().length];
        for (int i = 0; i < visitedSources.length; ++i) {
            this.knownSortableFields = new LinkedHashSet();
            visitedSources[i] = (CommandNode)node.getSources()[i].accept((NodeVisitor)this);
            if (this.knownSortableFields.size() == 0) {
                unknownSortablesInBranch = true;
            }
            if (unknownSortablesInBranch) continue;
            for (String fieldName : this.knownSortableFields) {
                sortableFields.add((i == 0 ? lhsAliasPrefix : rhsAliasPrefix) + fieldName);
            }
        }
        if (!unknownSortablesInBranch) {
            this.knownSortableFields = sortableFields;
        } else {
            this.reset();
        }
        if (visitedSources.length == 0) {
            return node;
        }
        return visitedSources.length == 1 ? node.setSource(visitedSources[0]) : node.setSources(visitedSources);
    }

    public CommandNode visit(UnionCommand node) {
        boolean unknownSortablesInBranch = false;
        LinkedHashSet<String> sortableFields = new LinkedHashSet<String>();
        CommandNode[] visitedSources = new CommandNode[node.getSources().length];
        for (int i = 0; i < visitedSources.length; ++i) {
            this.knownSortableFields = new LinkedHashSet();
            visitedSources[i] = (CommandNode)node.getSources()[i].accept((NodeVisitor)this);
            if (this.knownSortableFields.size() == 0) {
                unknownSortablesInBranch = true;
            }
            if (unknownSortablesInBranch) continue;
            for (String fieldName : this.knownSortableFields) {
                sortableFields.add(fieldName);
            }
        }
        if (!unknownSortablesInBranch) {
            this.knownSortableFields = sortableFields;
        } else {
            this.reset();
        }
        if (visitedSources.length == 0) {
            return node;
        }
        return visitedSources.length == 1 ? node.setSource(visitedSources[0]) : node.setSources(visitedSources);
    }

    public CommandNode visit(StatsCommand node) {
        this.reset();
        ArrayList fields = new ArrayList();
        node.setColumnOrder(fields);
        for (String field : fields) {
            if (field == null || field.indexOf(42) < 0) continue;
            return node;
        }
        this.knownSortableFields.addAll(fields);
        return node;
    }

    public CommandNode visit(SortCommand node) {
        CommandNode resultNode = super.visit((CommandNode)node);
        logger.debug((Object)("Sortable fields are: " + this.knownSortableFields.toString()));
        if (this.knownSortableFields.size() == 0) {
            return resultNode;
        }
        node = (SortCommand)resultNode;
        IOrdering[] byFields = node.getBy();
        if (byFields == null || byFields.length == 0) {
            throw new DFSException(logger, NO_SORTABLE_FIELD);
        }
        ArrayList<IOrdering> validBytFields = new ArrayList<IOrdering>();
        for (IOrdering byField : byFields) {
            if (!byField.getField().getFieldName().startsWith("_") && !this.knownSortableFields.contains(byField.getField().getFieldName())) continue;
            validBytFields.add(byField);
        }
        if (validBytFields.size() == 0) {
            throw new DFSException(logger, NO_SORTABLE_FIELD);
        }
        IOrdering[] optByFields = new IOrdering[validBytFields.size()];
        validBytFields.toArray(optByFields);
        return new SortCommand(node.getSource(), optByFields, node.getCount());
    }

    public CommandNode visit(RenameCommand node) {
        return this.passThrough((CommandNode)node);
    }

    public CommandNode visit(EvalCommand node) {
        return this.passThrough((CommandNode)node);
    }

    public CommandNode visit(FieldsCommand node) {
        return this.passThrough((CommandNode)node);
    }

    private CommandNode passThrough(CommandNode node) {
        CommandNode resultNode = super.visit(node);
        this.reset();
        return resultNode;
    }
}

