/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.commons.ast.nodes.commands.RdInCommand;
import com.splunk.commons.ast.nodes.commands.RenameCommand;
import com.splunk.commons.ast.nodes.commands.RenameNode;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.visitors.CommandRebuilder;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class ColumnOrderVisitor
extends CommandRebuilder {
    static final Logger logger = Logger.getLogger(ColumnOrderVisitor.class);
    private ArrayList<String> columnOrder = new ArrayList();
    HashMap<String, ArrayList<String>> fshRemoteSidToColumnOrderMap;

    public ColumnOrderVisitor() {
    }

    public ColumnOrderVisitor(HashMap<String, ArrayList<String>> fshRemoteSidToSplMap) {
        this.fshRemoteSidToColumnOrderMap = fshRemoteSidToSplMap;
    }

    public ArrayList<String> getColumnOrder() {
        return this.columnOrder;
    }

    private void reset() {
        this.columnOrder.clear();
    }

    public CommandNode visit(RdInCommand node) {
        if (this.fshRemoteSidToColumnOrderMap == null) {
            return node;
        }
        ArrayList<String> remoteColumnOrder = this.fshRemoteSidToColumnOrderMap.get(node.getRemoteSid());
        if (remoteColumnOrder == null) {
            return node;
        }
        this.columnOrder = remoteColumnOrder;
        return node;
    }

    public CommandNode visit(CommandNode node) {
        node.setColumnOrder(this.columnOrder);
        super.visit(node);
        return node;
    }

    public CommandNode visit(StatsCommand node) {
        super.visit((CommandNode)node);
        this.reset();
        node.setColumnOrder(this.columnOrder);
        return node;
    }

    public CommandNode visit(RenameCommand node) {
        super.visit((CommandNode)node);
        RenameNode[] renames = node.getRenames();
        for (int i = 0; i < renames.length; ++i) {
            if (!this.columnOrder.contains(renames[i].getFieldName())) continue;
            String fromName = renames[i].getField().getFieldName();
            String toName = renames[i].getNewFieldName();
            this.columnOrder.set(this.columnOrder.indexOf(fromName), toName);
        }
        return node;
    }

    public CommandNode visit(FieldsCommand node) {
        super.visit((CommandNode)node);
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        FieldNode[] fieldNode = node.getFields();
        for (int i = 0; i < fieldNode.length; ++i) {
            fields.add(fieldNode[i].getFieldName());
        }
        if (!node.isKeepColumnOrder() && !node.isRemoveFields()) {
            this.reset();
            this.columnOrder.addAll(fields);
        } else if (node.isRemoveFields() && !this.columnOrder.isEmpty()) {
            LinkedHashSet<String> newColumnOrder = new LinkedHashSet<String>();
            for (int i = 0; i < this.columnOrder.size(); ++i) {
                if (fields.contains(this.columnOrder.get(i))) continue;
                newColumnOrder.add(this.columnOrder.get(i));
            }
            this.reset();
            this.columnOrder.addAll(newColumnOrder);
        }
        return node;
    }

    public CommandNode visit(JoinCommand node) {
        LinkedHashSet<String> combinedColumnOrder = new LinkedHashSet<String>(this.columnOrder);
        CommandNode[] visitedSources = new CommandNode[node.getSources().length];
        for (int i = 0; i < visitedSources.length; ++i) {
            String alias;
            ColumnOrderVisitor columnOrderVisitor = new ColumnOrderVisitor(this.fshRemoteSidToColumnOrderMap);
            visitedSources[i] = (CommandNode)node.getSources()[i].accept((NodeVisitor)columnOrderVisitor);
            ArrayList<String> colOrder = columnOrderVisitor.getColumnOrder();
            String string = alias = i == 0 ? node.getLhsAlias() : node.getRhsAlias();
            if (!alias.isEmpty()) {
                alias = alias + ".";
                ListIterator<String> colItr = colOrder.listIterator();
                while (colItr.hasNext()) {
                    String col = colItr.next();
                    String newCol = alias;
                    newCol = newCol + col;
                    colItr.set(newCol);
                }
            }
            combinedColumnOrder.addAll(columnOrderVisitor.getColumnOrder());
        }
        this.columnOrder.clear();
        this.columnOrder.addAll(combinedColumnOrder);
        return node;
    }

    public CommandNode visit(UnionCommand node) {
        LinkedHashSet<String> combinedColumnOrder = new LinkedHashSet<String>(this.columnOrder);
        CommandNode[] visitedSources = new CommandNode[node.getSources().length];
        for (int i = 0; i < visitedSources.length; ++i) {
            ColumnOrderVisitor columnOrderVisitor = new ColumnOrderVisitor(this.fshRemoteSidToColumnOrderMap);
            visitedSources[i] = (CommandNode)node.getSources()[i].accept((NodeVisitor)columnOrderVisitor);
            ArrayList<String> colOrder = columnOrderVisitor.getColumnOrder();
            combinedColumnOrder.addAll(columnOrderVisitor.getColumnOrder());
        }
        this.columnOrder.clear();
        this.columnOrder.addAll(combinedColumnOrder);
        return node;
    }
}

