/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.serdes.fieldCompressed.util;

import com.splunk.df.serdes.fieldCompressed.util.DataUtil;
import com.splunk.df.serdes.fieldCompressed.util.DecodingStringCache;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReadableThresholdStringCache
implements DecodingStringCache {
    static final Logger logger = Logger.getLogger(ReadableThresholdStringCache.class);
    Map<Integer, String> idToText = new HashMap<Integer, String>();

    @Override
    public void readFrom(InputStream in) throws IOException {
        int id;
        int numEntries = (int)DataUtil.readBase128(in);
        for (int i = 0; i < numEntries; ++i) {
            String txt = DataUtil.readString(in);
            id = (int)DataUtil.readBase128(in);
            this.idToText.put(id, txt);
        }
        int numDropped = (int)DataUtil.readBase128(in);
        for (int i = 0; i < numDropped; ++i) {
            id = (int)DataUtil.readBase128(in);
            if (null != this.idToText.remove(id)) continue;
            logger.warn((Object)("Possible inconsistent state: was told to drop '" + id + "' from ID cache, but it is not there"));
        }
    }

    @Override
    public String getText(int id) {
        return this.idToText.get(id);
    }

    public int size() {
        return this.idToText.size();
    }
}

