/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.serdes;

import com.splunk.df.search.SplunkEvent;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WireFormatRecord {
    public final int numFields;
    private final List<String> fields;

    public WireFormatRecord(List<String> fields) {
        this.fields = fields;
        this.numFields = fields.size();
    }

    public WireFormatRecord(SplunkEvent event, boolean fromHeader) {
        this.fields = new ArrayList<String>();
        Collection<Object> input = fromHeader ? event.keySet() : event.values();
        this.fields.addAll(input);
        this.numFields = this.fields.size();
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void writeBytes(BufferedOutputStream bos) throws IOException {
        for (String field : this.fields) {
            byte[] strBytes = field.getBytes();
            byte[] lenBytes = ByteBuffer.allocate(4).putInt(strBytes.length).array();
            bos.write(lenBytes);
            bos.write(strBytes);
        }
        bos.write(ByteBuffer.allocate(4).putInt(-1).array());
    }

    public String toString() {
        return this.fields.toString();
    }
}

