/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers.aggregatevalues;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.splunk.df.search.compute.transformers.aggregatevalues.AggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.BaseAggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.ThresholdAggregateValue;
import com.splunk.df.util.HyperLogLogUtils;
import org.apache.log4j.Logger;

public class HyperLogLogAggregateValue
extends BaseAggregateValue {
    static final Logger logger = Logger.getLogger(ThresholdAggregateValue.class);
    private byte[] hllBytes;

    @Override
    public Object getValue() {
        return this.hllBytes;
    }

    public HyperLogLogAggregateValue() {
        try {
            this.hllBytes = new HyperLogLog(16).getBytes();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AggregateValue accumulate(Object value) {
        assert (value instanceof byte[]);
        this.hllBytes = HyperLogLogUtils.accumulateHLL(this.hllBytes, (byte[])value);
        return this;
    }

    @Override
    public AggregateValue accumulate(AggregateValue aggregateValue) {
        assert (aggregateValue instanceof HyperLogLogAggregateValue);
        this.hllBytes = HyperLogLogUtils.accumulateHLL(this.hllBytes, (byte[])aggregateValue.getValue());
        return this;
    }
}

