/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.RdInCommand;
import com.splunk.df.search.compute.BaseTransformer;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Filter;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class RdInTransformer
extends BaseTransformer {
    static final Logger logger = Logger.getLogger(RdInTransformer.class);

    RdInTransformer() {
    }

    @Override
    public List<SearchResult> getMetaInfo(DistributedDataset dd, CommandNode qcmd, ComputeEngineContext ctx) {
        assert (false);
        return null;
    }

    @Override
    public DistributedDataset explode(DistributedDataset dd, CommandNode cmd, ComputeEngineContext ctx, List<SearchResult> metadata) {
        assert (false);
        return null;
    }

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode qcmd, boolean streaming, ComputeEngineContext ctx) {
        return RdInTransformer._transform(ctx, dd, qcmd);
    }

    private static DistributedDataset _transform(ComputeEngineContext ctx, DistributedDataset dd, CommandNode qcmd) {
        int numRemoteSearches;
        RdInCommand rdInCommand = RdInTransformer.getRdInCommand(qcmd);
        String tempSid = rdInCommand.getRemoteSid();
        boolean fshRdin = false;
        if (tempSid.startsWith("fsh")) {
            String updatedSid;
            HashMap logicalToFieldNum = (HashMap)ctx.get("fshRemoteFieldNumMap");
            int numFields = 6;
            if (logicalToFieldNum != null) {
                numFields = logicalToFieldNum.getOrDefault(tempSid, numFields);
            }
            ctx.addContext("numfields", numFields);
            HashMap logicalToPhysicalSid = (HashMap)ctx.get("fshRemoteSidMap");
            tempSid = updatedSid = (String)logicalToPhysicalSid.get(tempSid);
            fshRdin = true;
        }
        final String sid = tempSid;
        Pair baseDDInfo = (Pair)ctx.get("baseInputDD");
        DistributedDataset baseDD = (DistributedDataset)baseDDInfo.first();
        if (fshRdin) {
            baseDD = baseDD.setExtractionHint(FieldExtractor.ExtractionHint.NOT_PRECOMPUTED);
            logger.debug((Object)String.format("changing the extraction hint to pre-computed but not pre-staged since fsh execution: %s", tempSid));
        }
        if ((numRemoteSearches = ((Integer)ctx.get("numRemoteSearches")).intValue()) < 2) {
            baseDD.setContext(ctx);
            logger.debug((Object)String.format("using based dd since this is a single sourced search: %s", sid));
            return baseDD;
        }
        final int sidHC = sid.hashCode();
        logger.debug((Object)String.format("sid to be used to filter out the rdin records: %s, by fields: %s", sid, rdInCommand.getAvailableFields().toString()));
        DistributedDataset srDD = baseDD.transform(new Filter(){
            private static final long serialVersionUID = 1L;

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.UNKNOWN;
            }

            @Override
            public boolean accept(SearchResult sr) {
                String lsid = sr.sid();
                if (lsid == null) {
                    throw new RuntimeException(String.format("sid has to be set on all search results", new Object[0]));
                }
                int lhc = lsid.hashCode();
                if (sidHC != lhc) {
                    return false;
                }
                return lsid.equals(sid);
            }
        });
        srDD.setContext(ctx);
        logger.info((Object)String.format("number of partitions of rdin dataset: %d", srDD.partitions()));
        return srDD;
    }

    @Override
    public String name() {
        return "RdinTransformer";
    }

    private static RdInCommand getRdInCommand(CommandNode cmd) {
        if (cmd == null) {
            throw new IllegalArgumentException("Command is null");
        }
        if (cmd instanceof RdInCommand) {
            return (RdInCommand)cmd;
        }
        CommandNode parent = cmd.getSources()[0];
        if (parent == null) {
            throw new IllegalStateException("Search command not found for " + cmd);
        }
        return RdInTransformer.getRdInCommand(parent);
    }
}

