/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.IPredicate;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchNode;
import com.splunk.df.search.compute.BaseTransformer;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Exploder;
import com.splunk.df.search.compute.Mapper;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.transformers.BaseTransformerFactory;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.util.Utils;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class NativeSearchParallelizer
extends BaseTransformer {
    static final Logger logger = Logger.getLogger(NativeSearchParallelizer.class);

    private static List<SearchResult> _getMetaInfo(DistributedDataset dd, final CommandNode cmd, ComputeEngineContext ctx) {
        final SearchCommand searchCmd = NativeSearchParallelizer.getSearchCommand(cmd);
        logger.debug((Object)("Search=" + searchCmd.toString()));
        final String spl = BaseTransformerFactory.getActualSpl(cmd);
        final String index = NativeSearchParallelizer.getIndexName(searchCmd);
        logger.debug((Object)("Found index name in query=" + index));
        DistributedDataset indexNameDD = dd.transform(new Mapper(){
            private static final long serialVersionUID = 1L;

            @Override
            public SearchResult map(SearchResult sr) {
                return SearchResultFactory.getInstance().createSearchResult(ComputeEngineConstants.INDEX_FIELD_NAME, index);
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
            }

            @Override
            public boolean repartition() {
                return false;
            }
        });
        final int numBuckets = (Integer)ctx.get("maxNumberOfBuckets");
        final int bucketRepeats = (Integer)ctx.get("numBucketRepeats");
        final boolean useSplits = (Boolean)ctx.get("useSplitIndexes");
        logger.debug((Object)("Number of buckets to be searched: " + numBuckets + ", number of repeats: " + bucketRepeats + ", use split indexes: " + useSplits));
        DistributedDataset bucketNamesDD = indexNameDD.transform(new Exploder(){
            private static final long serialVersionUID = 1L;

            @Override
            public Iterator<SearchResult> explode(SearchResult event) {
                ArrayList<SearchResult> buckets = new ArrayList<SearchResult>();
                String splunkDb = System.getenv("SPLUNK_DB");
                String splunkHome = System.getenv("SPLUNK_HOME");
                if (splunkHome == null || splunkHome.trim().isEmpty()) {
                    throw new IllegalArgumentException("SPLUNK_HOME env var not set!");
                }
                if (splunkDb == null || splunkDb.isEmpty()) {
                    splunkDb = splunkHome + "/var/lib/splunk";
                }
                File indexesDir = new File(splunkDb);
                logger.debug((Object)("Will read index buckets from: " + indexesDir));
                if (!indexesDir.exists() || !indexesDir.isDirectory()) {
                    throw new RuntimeException("index directory not found: " + indexesDir.getAbsolutePath());
                }
                SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[]{ComputeEngineConstants.BUCKET_NAME, ComputeEngineConstants.SPL};
                if (useSplits) {
                    File[] indexes = indexesDir.listFiles();
                    Arrays.sort(indexes, new Comparator<File>(){

                        @Override
                        public int compare(File lhs, File rhs) {
                            return lhs.getName().compareTo(rhs.getName());
                        }
                    });
                    String splitIndexPrefix = index + "__";
                    int numBuckets_ = numBuckets;
                    if (numBuckets_ < 0) {
                        numBuckets_ = Integer.MAX_VALUE;
                    }
                    for (int i = 0; i < indexes.length && buckets.size() < numBuckets_ * bucketRepeats; ++i) {
                        String indexName;
                        File index2 = indexes[i];
                        if (!index2.isDirectory() || !(indexName = index2.getName()).startsWith(splitIndexPrefix)) continue;
                        NativeSearchParallelizer.setIndexName(searchCmd, indexName);
                        String newspl = BaseTransformerFactory.getActualSpl(cmd);
                        logger.debug((Object)("Split index spl=" + newspl));
                        for (int j = 0; j < bucketRepeats; ++j) {
                            Object[] vals = new Object[]{indexName, newspl};
                            buckets.add(SearchResultFactory.getInstance().createSearchResult(fields, vals));
                        }
                    }
                } else {
                    for (int i = 0; i < bucketRepeats; ++i) {
                        Object[] vals = new Object[]{index, spl};
                        buckets.add(SearchResultFactory.getInstance().createSearchResult(fields, vals));
                    }
                }
                logger.debug((Object)("Buckets to be searched are: " + buckets));
                return buckets.iterator();
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
            }
        });
        int numCores = (Integer)ctx.get("numCores");
        Iterator<SearchResult> buckets = bucketNamesDD.retrieve();
        ArrayList<SearchResult> bucketsList = new ArrayList<SearchResult>();
        SearchResult empty = SearchResultFactory.getInstance().emptyResult();
        while (buckets.hasNext()) {
            SearchResult bucket = buckets.next();
            MapUtils.debugPrint((PrintStream)System.out, (Object)"bucket: ", bucket.getDataMap());
            bucketsList.add(bucket);
            for (int i = 0; i < numCores; ++i) {
                bucketsList.add(empty);
            }
        }
        logger.debug((Object)("Count of bucket names after seeding: " + bucketsList.size()));
        return bucketsList;
    }

    @Override
    public List<SearchResult> getMetaInfo(DistributedDataset dd, CommandNode cmd, ComputeEngineContext ctx) {
        return NativeSearchParallelizer._getMetaInfo(dd, cmd, ctx);
    }

    private static DistributedDataset _explode(DistributedDataset dd, CommandNode cmd, ComputeEngineContext ctx, List<SearchResult> bucketsList) {
        logger.debug((Object)("Explode invoked on buckets size " + bucketsList.size()));
        DistributedDataset parallelizedBucketNamesDD = dd.resetSearchResults(bucketsList, bucketsList.size());
        DistributedDataset srdd = NativeSearchParallelizer.getSearchResultsDD(parallelizedBucketNamesDD, cmd, true);
        return srdd;
    }

    @Override
    public DistributedDataset explode(DistributedDataset dd, CommandNode cmd, ComputeEngineContext ctx, List<SearchResult> bucketsList) {
        return NativeSearchParallelizer._explode(dd, cmd, ctx, bucketsList);
    }

    private static String getIndexName(SearchCommand searchCmd) {
        IPredicate pred = searchCmd.getPredicate();
        Node predNode = pred.getNode();
        if (predNode instanceof SearchAndNode) {
            SearchAndNode san = (SearchAndNode)predNode;
            List sns = san.getArguments();
            for (SearchNode sn : sns) {
                FieldNode lhsFn;
                String fldName;
                SearchComparisonNode scn;
                FieldNode lhsTn;
                if (!(sn instanceof SearchComparisonNode) || !((lhsTn = (scn = (SearchComparisonNode)sn).getLhs()) instanceof FieldNode) || !(fldName = (lhsFn = lhsTn).getFieldName()).equals(INDEX_FIELD_NAME)) continue;
                StringNode rhsSn = (StringNode)scn.getRhs();
                String index = rhsSn.getValue();
                return index;
            }
        }
        throw new RuntimeException("could not find index for command: " + searchCmd);
    }

    private static void setIndexName(SearchCommand searchCmd, String indexName) {
        IPredicate pred = searchCmd.getPredicate();
        Node predNode = pred.getNode();
        if (predNode instanceof SearchAndNode) {
            SearchAndNode san = (SearchAndNode)predNode;
            List sns = san.getArguments();
            for (SearchNode sn : sns) {
                FieldNode lhsFn;
                String fldName;
                SearchComparisonNode scn;
                FieldNode lhsTn;
                if (!(sn instanceof SearchComparisonNode) || !((lhsTn = (scn = (SearchComparisonNode)sn).getLhs()) instanceof FieldNode) || !(fldName = (lhsFn = lhsTn).getFieldName()).equals(INDEX_FIELD_NAME)) continue;
                StringNode rhsSn = (StringNode)scn.getRhs();
                rhsSn.putValue(indexName);
                logger.debug((Object)("Updated index name for search command: '" + searchCmd.toString() + "', to index: " + indexName));
                return;
            }
        }
        throw new RuntimeException("Could not set index for command: " + searchCmd);
    }

    private static SearchCommand getSearchCommand(CommandNode cmd) {
        if (cmd == null) {
            throw new IllegalArgumentException("Command is null");
        }
        if (cmd instanceof SearchCommand) {
            return (SearchCommand)cmd;
        }
        CommandNode parent = cmd.getSources()[0];
        if (parent == null) {
            throw new IllegalStateException("Search command not found for " + cmd);
        }
        return NativeSearchParallelizer.getSearchCommand(parent);
    }

    private static SearchResultsIterator getSearchResultsIterator(SearchResult metaInfo, CommandNode cmd, String hostName, boolean deleteDispatch) throws IOException {
        String dispatchFolder;
        File dispatchFolderF;
        ArrayList<String> searchProcArgs = new ArrayList<String>();
        searchProcArgs.add("splunk");
        searchProcArgs.add("cmd");
        searchProcArgs.add("splunkd");
        searchProcArgs.add("search");
        searchProcArgs.add("--streaming");
        searchProcArgs.add("--annotateMessages=true");
        searchProcArgs.add("--outCsv");
        searchProcArgs.add("--pro");
        searchProcArgs.add("--user=admin");
        searchProcArgs.add("--app=search");
        searchProcArgs.add("--roles=admin");
        searchProcArgs.add("--maxout=0");
        searchProcArgs.add("--maxbuckets=0");
        long currTime = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        String pid = ManagementFactory.getRuntimeMXBean().getName();
        String id = "dfs__" + currTime + "__" + threadId + "__" + pid;
        String splunkHome = System.getenv("SPLUNK_HOME");
        if (splunkHome == null || splunkHome.trim().isEmpty()) {
            throw new IllegalArgumentException("SPLUNK_HOME env var not set");
        }
        String splunkDb = System.getenv("SPLUNK_DB");
        if (splunkDb == null || splunkDb.isEmpty()) {
            splunkDb = splunkHome + "/var/lib/splunk";
        }
        if ((dispatchFolderF = new File(dispatchFolder = splunkHome + "/var/run/splunk/dispatch/" + id)).exists()) {
            try {
                if (!Utils.runCommand("rm -rf " + dispatchFolderF.getAbsolutePath())) {
                    throw new RuntimeException("could not remove dispatch folder: " + dispatchFolderF.getAbsolutePath());
                }
                logger.error((Object)("dispatch folder: " + dispatchFolderF.getAbsolutePath() + " deleted"));
            }
            catch (Throwable t) {
                throw new RuntimeException("error while deleting pre-exisitng dispatch folder: " + dispatchFolderF.getAbsolutePath(), t);
            }
        }
        if (!dispatchFolderF.mkdir()) {
            logger.error((Object)("!!!!!!!!!!!!!!!could not create dispatch directory: " + dispatchFolderF.getAbsolutePath()));
            throw new RuntimeException("could not create dispatch directory: " + dispatchFolderF.getAbsolutePath());
        }
        try {
            if (!Utils.runCommand("touch " + dispatchFolderF.getAbsolutePath() + "/info.csv")) {
                logger.error((Object)("failed to touch the info csv file to the dispatch folder: " + dispatchFolderF.getAbsolutePath()));
                throw new RuntimeException("failed to create empty info csv file to dispatch folder: " + dispatchFolderF.getAbsolutePath());
            }
        }
        catch (Throwable t) {
            logger.error((Object)("error creating info csv inside the search dipstach folder: " + dispatchFolderF.getAbsolutePath()));
            throw new RuntimeException("could not create info csv file inside dispatch folder", t);
        }
        logger.debug((Object)("Metadata=" + metaInfo));
        String spl = metaInfo.getFieldValue(SPL).toString();
        searchProcArgs.add("--id=" + id);
        searchProcArgs.add("--search=" + spl);
        Process searchProcess = new ProcessBuilder(searchProcArgs).start();
        String searchChildCmd = StringUtils.join(searchProcArgs, (String)" ");
        System.out.println(String.format("NativeSearchParallelizer - running search with cmd line: %s", searchChildCmd));
        BufferedReader ebr = new BufferedReader(new InputStreamReader(searchProcess.getErrorStream()));
        BufferedReader br = new BufferedReader(new InputStreamReader(searchProcess.getInputStream()));
        StringBuffer errorMsg = new StringBuffer();
        long totalWait = 0L;
        while (true) {
            if (!br.ready() && !ebr.ready()) {
                long start = System.currentTimeMillis();
                try {
                    Thread.sleep(1L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!(NativeSearchParallelizer.isAlive(searchProcess) || br.ready() || ebr.ready())) {
                    System.out.println("search child process has ended: " + id);
                    String err = errorMsg.toString().trim();
                    if (!err.isEmpty()) {
                        logger.debug((Object)("Error received from search child process: " + err + ", sid: " + id));
                    }
                    throw new RuntimeException(String.format("search child process has ended even before returning any results: %s, \"%s\"", id, searchChildCmd));
                }
                if ((totalWait += System.currentTimeMillis() - start) <= 600000L) continue;
                logger.debug((Object)("splunkd search child buffer read timeout reached: " + id));
                throw new RuntimeException(String.format("splunkd search child buffer read timeout reached: %s, \"%s\"", id, searchChildCmd));
            }
            totalWait = 0L;
            if (ebr.ready()) {
                String line = ebr.readLine();
                logger.debug((Object)String.format("error in splunk search child:%s, \"%s\" ", searchChildCmd, line));
                errorMsg.append(line);
                continue;
            }
            if (br.ready()) break;
        }
        String err = errorMsg.toString().trim();
        if (!err.isEmpty()) {
            logger.debug((Object)String.format("non error output follows error output from search child process: %s, \"%s\", %s", id, searchChildCmd, err));
        }
        return new SearchResultsIterator(searchProcess, id, searchChildCmd, br, hostName, metaInfo, dispatchFolderF.getAbsolutePath(), deleteDispatch);
    }

    public static boolean isAlive(Process p) {
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    private static int read(Process p, BufferedReader br, char[] buff) throws IOException {
        int totalRead = 0;
        int max = buff.length;
        long totalWait = 0L;
        while (totalRead < max) {
            if (!br.ready()) {
                long start = System.currentTimeMillis();
                try {
                    Thread.sleep(1L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if ((totalWait += System.currentTimeMillis() - start) <= 120000L || NativeSearchParallelizer.isAlive(p) || br.ready()) continue;
                logger.error((Object)String.format("search proces exited without returning the entire chunk of records", new Object[0]));
                throw new RuntimeException("search process ended with partial results");
            }
            totalWait = 0L;
            int read = br.read(buff, totalRead, max - totalRead);
            if (read < 0) {
                throw new RuntimeException("EOF reached while reading buffer, total read: " + totalRead + ", expected size: " + buff.length);
            }
            totalRead += read;
        }
        return totalRead;
    }

    private static void deleteDispatch(boolean deleteDispatch, String dispatchDir) {
        if (!deleteDispatch) {
            return;
        }
        try {
            if (!Utils.runCommand("rm -rf " + dispatchDir)) {
                logger.info((Object)("could not delete dispatch dir: " + dispatchDir));
            }
        }
        catch (Throwable t) {
            logger.info((Object)("error deleting dispatch directory: " + dispatchDir));
        }
    }

    private static void cleanup(Process searchProc, String dispatchDir, boolean deleteDispatch) {
        if (NativeSearchParallelizer.isAlive(searchProc)) {
            searchProc.destroy();
        }
        NativeSearchParallelizer.deleteDispatch(deleteDispatch, dispatchDir);
    }

    public static DistributedDataset getSearchResultsDD(DistributedDataset bucketsdd, final CommandNode cmd, final boolean deleteDispatch) {
        DistributedDataset srsdd = bucketsdd.transform(new Exploder(){
            private static final long serialVersionUID = 1L;

            @Override
            public Iterator<SearchResult> explode(SearchResult sr) {
                if (sr.getDataMap().isEmpty() || sr.getFieldValue(ComputeEngineConstants.BUCKET_NAME) == null) {
                    return new ArrayList().iterator();
                }
                String hostName = Utils.getLocalHostAddress();
                Iterator<SearchResult> srs = null;
                try {
                    NativeSearchParallelizer.getSearchResultsIterator(sr, cmd, hostName, deleteDispatch);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
                return srs;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED;
            }
        });
        return srsdd;
    }

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode qcmd, boolean streaming, ComputeEngineContext ctx) {
        List<SearchResult> sr = this.getMetaInfo(dd, qcmd, ctx);
        return this.explode(dd, qcmd, ctx, sr);
    }

    @Override
    public String name() {
        return "NSPTransformer";
    }

    private static class SearchResultsIterator
    implements Iterator<SearchResult> {
        private BufferedReader br;
        private String host;
        private SearchChunkIterator chunkIter;
        private String bucket;
        private long totalTime = 0L;
        private String dispatchDir;
        private boolean deleteDispatch;
        private String sid;
        private int chunkId = 0;
        private Process searchProc;
        private long recs = 0L;
        private String searchChildCmd;
        private SearchResult metaInfo;

        SearchResultsIterator(Process searchProc, String sid, String searchChildCmd, BufferedReader br, String host, SearchResult metaInfo, String dispatchDir, boolean deleteDispatch) {
            this.searchProc = searchProc;
            this.searchChildCmd = searchChildCmd;
            this.sid = sid;
            this.br = br;
            this.host = host;
            this.bucket = metaInfo.getFieldValue(ComputeEngineConstants.BUCKET_NAME).toString();
            this.dispatchDir = dispatchDir;
            this.deleteDispatch = deleteDispatch;
            this.metaInfo = metaInfo;
        }

        @Override
        public boolean hasNext() {
            long start = System.currentTimeMillis();
            if (this.chunkIter != null) {
                if (this.chunkIter.hasNext()) {
                    this.totalTime += System.currentTimeMillis() - start;
                    return true;
                }
                this.chunkIter = null;
            }
            long totalWait = 0L;
            try {
                char[] chunkChars;
                CSVParser parser;
                while (true) {
                    if (!this.br.ready()) {
                        long start1 = System.currentTimeMillis();
                        if (!NativeSearchParallelizer.isAlive(this.searchProc)) {
                            this.totalTime += System.currentTimeMillis() - start;
                            logger.info((Object)String.format("search process ended: %s, cmd: \"%s\", read: %d records, in %d millis", this.sid, this.searchChildCmd, this.recs, this.totalTime));
                            NativeSearchParallelizer.cleanup(this.searchProc, this.dispatchDir, this.deleteDispatch);
                            return false;
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if ((totalWait += System.currentTimeMillis() - start1) <= 120000L) continue;
                        logger.info((Object)("splunkd search child response timeout over: " + this.sid));
                        throw new RuntimeException(String.format("splunkd search child response timeout over: %s, cmd: \"%s\"", this.sid, this.searchChildCmd));
                    }
                    totalWait = 0L;
                    String chunkHeader = this.br.readLine();
                    if (chunkHeader == null) {
                        this.totalTime += System.currentTimeMillis() - start;
                        logger.debug((Object)("end of buffer reached for bucket: " + this.bucket));
                        logger.info((Object)("completed reading bucket result: " + this.bucket + ", in: " + this.totalTime + " millis, recs read: " + this.recs));
                        NativeSearchParallelizer.cleanup(this.searchProc, this.dispatchDir, this.deleteDispatch);
                        return false;
                    }
                    if ((chunkHeader = chunkHeader.trim()).isEmpty()) {
                        this.totalTime += System.currentTimeMillis() - start;
                        logger.debug((Object)("chunk header is empty for bucket: " + this.bucket));
                        continue;
                    }
                    parser = new CSVParser((Reader)new StringReader(chunkHeader), CSVFormat.DEFAULT);
                    Iterator recs = parser.iterator();
                    if (!recs.hasNext()) {
                        logger.debug((Object)("no record found in splunkd search header: " + chunkHeader + " for bucket" + this.bucket));
                        parser.close();
                        this.totalTime += System.currentTimeMillis() - start;
                        logger.info((Object)("completed reading bucket result: " + this.bucket + ", in: " + this.totalTime + " millis, recs read: " + recs));
                        NativeSearchParallelizer.cleanup(this.searchProc, this.dispatchDir, this.deleteDispatch);
                        return false;
                    }
                    CSVRecord header = (CSVRecord)recs.next();
                    if (header.size() != 3) {
                        logger.debug((Object)("header received is corrupt: " + chunkHeader + " for bucket: " + this.bucket + "; headers should be like: splunk 6.5.3,2958,754"));
                        parser.close();
                        this.totalTime += System.currentTimeMillis() - start;
                        logger.info((Object)("completed reading bucket result: " + this.bucket + ", in: " + this.totalTime + " millis, recs read: " + recs));
                        NativeSearchParallelizer.cleanup(this.searchProc, this.dispatchDir, this.deleteDispatch);
                        return false;
                    }
                    int infoCsvSize = Integer.parseInt(header.get(1));
                    char[] infoCsvChars = new char[infoCsvSize];
                    NativeSearchParallelizer.read(this.searchProc, this.br, infoCsvChars);
                    infoCsvChars = null;
                    int chunkSize = Integer.parseInt(header.get(2));
                    if (chunkSize <= 0) {
                        parser.close();
                        this.totalTime += System.currentTimeMillis() - start;
                        continue;
                    }
                    chunkChars = new char[chunkSize];
                    int totalRead = NativeSearchParallelizer.read(this.searchProc, this.br, chunkChars);
                    ++this.chunkId;
                    CharArrayReader chunkReader = new CharArrayReader(chunkChars);
                    this.chunkIter = new SearchChunkIterator(this.sid, this.searchChildCmd, this.chunkId, chunkSize, chunkReader, this.host, header, totalRead, this.metaInfo);
                    if (this.chunkIter.hasNext()) break;
                    logger.debug((Object)("chunk does not have any records, bucket: " + this.bucket));
                    this.totalTime += System.currentTimeMillis() - start;
                }
                chunkChars = null;
                this.totalTime += System.currentTimeMillis() - start;
                parser.close();
                return true;
            }
            catch (Throwable t) {
                this.totalTime += System.currentTimeMillis() - start;
                if (NativeSearchParallelizer.isAlive(this.searchProc)) {
                    this.searchProc.destroy();
                }
                logger.debug((Object)("could not parse chunk in bucket: " + this.bucket), t);
                NativeSearchParallelizer.deleteDispatch(this.deleteDispatch, this.dispatchDir);
                throw new RuntimeException("error processing chunk in bucket: " + this.bucket, t);
            }
        }

        @Override
        public SearchResult next() {
            ++this.recs;
            return this.chunkIter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SearchChunkIterator
    implements Iterator<SearchResult> {
        private SearchResult nextResult = null;
        private CSVParser parser = null;
        private SearchResult.FieldMeta[] header = null;
        private Iterator<CSVRecord> recs;
        private Reader r;
        private String sid;
        private int chunkId;
        private String searchChildCmd;
        private long chunkSize;
        private CSVRecord chunkHeader;
        private int totalBytesRead;
        private SearchResult metaInfo;

        SearchChunkIterator(String sid, String searchChildCmd, int chunkId, long chunkSize, Reader r, String hos, CSVRecord chunkHeader, int totalBytesRead, SearchResult metaInfo) throws IOException {
            this.searchChildCmd = searchChildCmd;
            this.totalBytesRead = totalBytesRead;
            this.chunkHeader = chunkHeader;
            this.sid = sid;
            this.chunkId = chunkId;
            this.chunkSize = chunkSize;
            this.r = r;
            this.parser = new CSVParser(r, CSVFormat.DEFAULT);
            this.recs = this.parser.iterator();
            CSVRecord headerRec = this.recs.next();
            int size = headerRec.size();
            this.header = new SearchResult.FieldMeta[size];
            for (int i = 0; i < size; ++i) {
                SearchResult.FieldMeta fieldName = SearchResult.FieldMeta.newFieldMeta(headerRec.get(i));
                fieldName.setType(SearchResultFactory.getType(fieldName));
                fieldName.setSequence(i);
                this.header[i] = fieldName;
            }
            this.metaInfo = metaInfo;
        }

        @Override
        public boolean hasNext() {
            if (this.nextResult != null) {
                return true;
            }
            try {
                if (!this.recs.hasNext()) {
                    if (this.parser != null) {
                        try {
                            this.r.close();
                            this.parser.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return false;
                }
                CSVRecord rec = this.recs.next();
                this.nextResult = SearchResultFactory.getInstance().createSearchResult(this.header, rec);
                this.nextResult = Utils.mergeMetaInfo(this.nextResult, this.metaInfo);
                return true;
            }
            catch (Throwable t) {
                logger.debug((Object)String.format("exception received while reading the next search result from chunk: %d, %s, cmd: \"%s\", chunkHeader %s, totalBytesRead %d, chunkSize %d", this.chunkId, this.sid, this.searchChildCmd, this.chunkHeader, this.totalBytesRead, this.chunkSize), t);
                try {
                    this.r.close();
                    this.parser.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new RuntimeException(t);
            }
        }

        @Override
        public SearchResult next() {
            SearchResult ret = this.nextResult;
            this.nextResult = null;
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

